/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.proxy;

import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.proxy.InterceptorSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.FileSourceCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterceptorSourceCodeGenerator
implements InterceptorSourceCodeGeneratorItf {
    protected InterfaceType it;
    protected MembraneDesc<?> membraneDesc;
    protected boolean mergeable;
    protected Juliac jc;

    public AbstractInterceptorSourceCodeGenerator() {
    }

    public AbstractInterceptorSourceCodeGenerator(InterfaceType it, MembraneDesc<?> membraneDesc, boolean mergeable, Juliac jc) {
        this.setInterfaceType(it);
        this.setMembraneDesc(membraneDesc);
        this.setMergeable(mergeable);
        this.setJuliac(jc);
    }

    @Override
    public void setInterfaceType(InterfaceType it) {
        this.it = it;
    }

    @Override
    public void setMembraneDesc(MembraneDesc<?> membraneDesc) {
        this.membraneDesc = membraneDesc;
    }

    @Override
    public void setMergeable(boolean mergeable) {
        this.mergeable = mergeable;
    }

    @Override
    public void setJuliac(Juliac jc) {
        this.jc = jc;
    }

    public String getTargetClassName() {
        String javaItfSignature = this.it.getFcItfSignature();
        String name = Utils.getJuliacGeneratedStrongTypeName(javaItfSignature);
        String suffix = this.getClassNameSuffix();
        String targetClassname = name + suffix;
        return targetClassname;
    }

    @Override
    public String[] getClassGenericTypeParameters() {
        UnifiedClass proxycl = this.jc.create(this.it.getFcItfSignature());
        String[] tps = proxycl.getTypeParameters();
        return tps;
    }

    @Override
    public int getClassModifiers() {
        return 1;
    }

    @Override
    public String getSuperClassName() {
        return null;
    }

    @Override
    public String[] getImplementedInterfaceNames() {
        String signature = this.jc.getInterfaceTypeSignature(this.it);
        return new String[]{signature};
    }

    @Override
    public void generateImports(FileSourceCodeVisitor fv) {
    }

    @Override
    public void generateStaticParts(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
    }

    @Override
    public void generateFields(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
    }

    @Override
    public void generateMethodInitFcController(BlockSourceCodeVisitor mv, UnifiedClass proxycl) {
    }

    @Override
    public void generateMethodClone(BlockSourceCodeVisitor mv, UnifiedClass proxycl) {
    }

    @Override
    public void generateMethodOthers(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
    }

    @Override
    public void generateProxyMethodBodyBeforeCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
    }

    @Override
    public void generateProxyMethodBodyAfterCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
    }

    @Override
    public void generateProxyMethodBodyFinallyCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
    }
}

