/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.proxy;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Date;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.proxy.ProxyClassGeneratorItf;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedClassHelper;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.FileSourceCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProxyClassGenerator
implements ProxyClassGeneratorItf {
    protected InterfaceType it;
    protected MembraneDesc<?> membraneDesc;
    protected boolean mergeable;
    protected Juliac jc;

    public AbstractProxyClassGenerator() {
    }

    public AbstractProxyClassGenerator(InterfaceType it, MembraneDesc<?> membraneDesc, boolean mergeable, Juliac jc) {
        this.setJuliac(jc);
        this.setInterfaceType(it);
        this.setMembraneDesc(membraneDesc);
        this.setMergeable(mergeable);
    }

    @Override
    public void setInterfaceType(InterfaceType it) {
        String signature = it.getFcItfSignature();
        UnifiedClass uc = this.jc.create(signature);
        if (!uc.isInterface()) {
            String msg = "Signature of InterfaceType " + signature + " must correspond to a Java interface (not a class)";
            throw new IllegalArgumentException(msg);
        }
        this.it = it;
    }

    @Override
    public void setMembraneDesc(MembraneDesc<?> membraneDesc) {
        this.membraneDesc = membraneDesc;
    }

    public void setMergeable(boolean mergeable) {
        this.mergeable = mergeable;
    }

    public void setJuliac(Juliac jc) {
        this.jc = jc;
    }

    @Override
    public String getTargetClassName() {
        String javaItfSignature = this.it.getFcItfSignature();
        String name = Utils.getJuliacGeneratedStrongTypeName(javaItfSignature);
        String suffix = this.getClassNameSuffix();
        String targetClassName = name + suffix;
        String rootedTargetClassName = this.jc.getRootedClassName(targetClassName);
        return rootedTargetClassName;
    }

    @Override
    public void generate(FileSourceCodeVisitor fv) throws IOException {
        this.generateFileHeaders(fv);
        String packageName = this.getPackageName();
        if (packageName != null) {
            fv.visitPackageName(packageName);
        }
        this.generateImports(fv);
        ClassSourceCodeVisitor cv = fv.visitPublicClass();
        this.generate(cv);
    }

    @Override
    public void generate(ClassSourceCodeVisitor cv) {
        UnifiedMethod[] proxymethods;
        int modifiers = this.getClassModifiers();
        if (this.mergeable) {
            modifiers = 1024;
        }
        String name = this.getClassName();
        String[] genericTypeParameters = this.getClassGenericTypeParameters();
        String superClassName = this.getSuperClassName();
        String[] implementedInterfaceNames = this.getImplementedInterfaceNames();
        cv.visit(modifiers, name, genericTypeParameters, superClassName, implementedInterfaceNames);
        UnifiedClass proxycl = this.jc.create(this.it.getFcItfSignature());
        this.generateFields(cv, proxycl);
        this.generateConstructors(cv, proxycl);
        this.generateMethods(cv, proxycl);
        for (UnifiedMethod proxym : proxymethods = UnifiedClassHelper.getMethodsWithMostSpecializedReturnType(proxycl)) {
            this.generateProxyMethod(cv, proxycl, proxym);
        }
        this.generateStaticParts(cv, proxycl);
        cv.visitEnd();
    }

    @Override
    public void generateFileHeaders(FileSourceCodeVisitor fv) {
        fv.visitFileHeader("/*");
        fv.visitFileHeader(" * Generated by: " + this.getClass().getName());
        fv.visitFileHeader(" * on: " + new Date().toString());
        fv.visitFileHeader(" */");
    }

    @Override
    public String getPackageName() {
        String targetclassname = this.getTargetClassName();
        int lastdot = targetclassname.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        String packagename = targetclassname.substring(0, lastdot);
        return packagename;
    }

    @Override
    public void generateImports(FileSourceCodeVisitor fv) {
    }

    @Override
    public int getClassModifiers() {
        return 1;
    }

    @Override
    public String getClassName() {
        String targetclassname = this.getTargetClassName();
        int lastdot = targetclassname.lastIndexOf(46);
        String shortclassname = targetclassname.substring(lastdot + 1);
        return shortclassname;
    }

    @Override
    public String[] getClassGenericTypeParameters() {
        UnifiedClass proxycl = this.jc.create(this.it.getFcItfSignature());
        String[] tps = proxycl.getTypeParameters();
        return tps;
    }

    @Override
    public String getSuperClassName() {
        return null;
    }

    @Override
    public String[] getImplementedInterfaceNames() {
        return null;
    }

    @Override
    public void generateStaticParts(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
    }

    @Override
    public void generateFields(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
    }

    @Override
    public void generateConstructors(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
    }

    @Override
    public void generateMethods(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
    }

    @Override
    public void generateProxyMethod(ClassSourceCodeVisitor cv, UnifiedClass proxycl, UnifiedMethod proxym) {
        int modifiers = 1;
        String[] genericReturnType = proxym.getTypeParameters();
        String returnType = proxym.getGenericReturnType();
        String name = proxym.getName();
        String[] parameters = proxym.getParameters();
        String[] exceptions = proxym.getGenericExceptionTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].startsWith("final")) continue;
            parameters[i] = "final " + parameters[i];
        }
        if (this.mergeable) {
            int mergeablemodifiers = 1025;
            String mergeablename = "_super_" + name;
            BlockSourceCodeVisitor mv = cv.visitMethod(mergeablemodifiers, genericReturnType, returnType, mergeablename, parameters, exceptions);
            mv.visitEnd();
        }
        BlockSourceCodeVisitor mv = cv.visitMethod(modifiers, genericReturnType, returnType, name, parameters, exceptions);
        this.generateProxyMethodBody(mv, proxycl, proxym);
        mv.visitEnd();
    }

    @Override
    public void generateProxyMethodBody(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        this.generateProxyMethodBodyBeforeCode(mv, proxycl, proxym);
        this.generateProxyMethodBodyDelegatingCode(mv, proxycl, proxym);
        this.generateProxyMethodBodyAfterCode(mv, proxycl, proxym);
        String rtypename = proxym.getGenericReturnType();
        if (!rtypename.equals("void")) {
            mv.visitIns("return", "ret");
        }
        this.generateProxyMethodBodyFinallyCode(mv, proxycl, proxym);
    }

    @Override
    public void generateProxyMethodBodyBeforeCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
    }

    @Override
    public void generateProxyMethodBodyDelegatingCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        UnifiedClass[] ptypes = proxym.getParameterTypes();
        String rtypename = proxym.getGenericReturnType();
        Object[] tpnames = proxym.getTypeParameterNames();
        String line = "";
        if (!rtypename.equals("void")) {
            line = line + rtypename + " ret = ";
        }
        String delegatingInstance = this.getDelegatingInstance(proxycl, proxym);
        String delegatingMethodName = this.getDelegatingMethodName(proxycl, proxym);
        line = line + delegatingInstance + ".";
        if (tpnames.length > 0) {
            line = line + "<" + Joiner.on(",").join(tpnames) + ">";
        }
        line = line + delegatingMethodName + "(";
        for (int j = 0; j < ptypes.length; ++j) {
            if (j != 0) {
                line = line + ",";
            }
            line = line + "arg" + Integer.toString(j);
        }
        mv.visitIns(line + ")");
    }

    @Override
    public void generateProxyMethodBodyAfterCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
    }

    @Override
    public void generateProxyMethodBodyFinallyCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
    }

    @Override
    public String getDelegatingMethodName(UnifiedClass proxycl, UnifiedMethod proxym) {
        String name = proxym.getName();
        if (this.mergeable) {
            return "_super_" + name;
        }
        return name;
    }
}

