/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.proxy;

import java.util.Arrays;
import java.util.HashSet;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.julia.Interceptor;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.proxy.AbstractProxyClassGenerator;
import org.objectweb.fractal.juliac.proxy.InterceptorSourceCodeGeneratorItf;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.FileSourceCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorClassGenerator
extends AbstractProxyClassGenerator {
    protected InterceptorSourceCodeGeneratorItf[] iscgs;
    protected boolean[] matches;

    public InterceptorClassGenerator() {
    }

    public InterceptorClassGenerator(InterceptorSourceCodeGeneratorItf[] iscgs, InterfaceType it, MembraneDesc<?> membraneDesc, boolean mergeable, Juliac jc) {
        this.init(iscgs);
        this.setJuliac(jc);
        this.setInterfaceType(it);
        this.setMembraneDesc(membraneDesc);
        this.setMergeable(mergeable);
    }

    public void init(InterceptorSourceCodeGeneratorItf[] iscgs) throws IllegalArgumentException {
        if (iscgs == null) {
            String msg = "Parameter should not be null";
            throw new IllegalArgumentException(msg);
        }
        this.iscgs = iscgs;
        this.matches = new boolean[this.iscgs.length];
    }

    @Override
    public void setInterfaceType(InterfaceType it) {
        super.setInterfaceType(it);
        if (this.iscgs != null) {
            for (InterceptorSourceCodeGeneratorItf iscg : this.iscgs) {
                iscg.setInterfaceType(it);
            }
            this.updateState();
        }
    }

    @Override
    public void setMembraneDesc(MembraneDesc<?> membraneDesc) {
        super.setMembraneDesc(membraneDesc);
        if (this.iscgs != null) {
            for (InterceptorSourceCodeGeneratorItf iscg : this.iscgs) {
                iscg.setMembraneDesc(membraneDesc);
            }
        }
    }

    @Override
    public void setMergeable(boolean mergeable) {
        super.setMergeable(mergeable);
        if (this.iscgs != null) {
            for (InterceptorSourceCodeGeneratorItf iscg : this.iscgs) {
                iscg.setMergeable(mergeable);
            }
        }
    }

    private void updateState() {
        for (int i = 0; i < this.iscgs.length; ++i) {
            this.matches[i] = this.iscgs[i].match();
        }
    }

    @Override
    public void generateImports(FileSourceCodeVisitor fv) {
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateImports(fv);
        }
    }

    @Override
    public void generateConstructors(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            BlockSourceCodeVisitor mv = cv.visitConstructor(1, null, null, null);
            mv.visitEnd();
            mv = cv.visitConstructor(2, null, new String[]{"Object obj"}, null);
            mv.visitIns("setFcItfDelegate(obj)");
            mv.visitEnd();
        }
    }

    @Override
    public void generateFields(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        this.generateFieldImpl(cv, proxycl);
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateFields(cv, proxycl);
        }
    }

    @Override
    public void generateMethods(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        this.generateMethodInitFcController(cv, proxycl);
        this.generateMethodClone(cv, proxycl);
        this.generateMethodGetFcItfDelegate(cv, proxycl);
        this.generateMethodSetFcItfDelegate(cv, proxycl);
        this.generateMethodOthers(cv, proxycl);
    }

    @Override
    public void generateProxyMethodBodyAfterCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        for (int i = this.iscgs.length - 1; i >= 0; --i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateProxyMethodBodyAfterCode(mv, proxycl, proxym);
        }
    }

    @Override
    public void generateProxyMethodBodyBeforeCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateProxyMethodBodyBeforeCode(mv, proxycl, proxym);
        }
    }

    @Override
    public void generateStaticParts(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateStaticParts(cv, proxycl);
        }
    }

    @Override
    public void generateProxyMethodBodyFinallyCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        for (int i = this.iscgs.length - 1; i >= 0; --i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateProxyMethodBodyFinallyCode(mv, proxycl, proxym);
        }
    }

    @Override
    public String[] getClassGenericTypeParameters() {
        for (int i = 0; i < this.matches.length; ++i) {
            String[] names;
            if (!this.matches[i] || (names = this.iscgs[i].getClassGenericTypeParameters()) == null) continue;
            return names;
        }
        return null;
    }

    @Override
    public int getClassModifiers() {
        int result = 0;
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            int mods = this.iscgs[i].getClassModifiers();
            result |= mods;
        }
        return result;
    }

    @Override
    public String getDelegatingInstance(UnifiedClass proxycl, UnifiedMethod proxym) {
        return this.mergeable ? "this" : "_impl";
    }

    @Override
    public String[] getImplementedInterfaceNames() {
        HashSet<String> all = new HashSet<String>();
        boolean allnull = true;
        if (!this.mergeable) {
            all.add(Interceptor.class.getName());
            allnull = false;
        }
        for (int i = 0; i < this.matches.length; ++i) {
            String[] names;
            if (!this.matches[i] || (names = this.iscgs[i].getImplementedInterfaceNames()) == null) continue;
            allnull = false;
            all.addAll(Arrays.asList(names));
        }
        if (allnull) {
            return null;
        }
        String[] result = all.toArray(new String[all.size()]);
        return result;
    }

    @Override
    public String getClassNameSuffix() {
        StringBuffer sb = new StringBuffer();
        sb.append("Interceptor");
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            String name = this.iscgs[i].getClassNameSuffix();
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public String getSuperClassName() throws IllegalArgumentException {
        String superClassName = null;
        for (int i = 0; i < this.matches.length; ++i) {
            String name;
            if (!this.matches[i] || (name = this.iscgs[i].getSuperClassName()) == null) continue;
            if (superClassName == null) {
                superClassName = name;
                continue;
            }
            if (superClassName.equals(name)) continue;
            String msg = "Interceptor class can not extend both " + superClassName + " and " + name;
            throw new IllegalArgumentException(msg);
        }
        return superClassName;
    }

    @Override
    public boolean match() {
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            return true;
        }
        return false;
    }

    public void generateFieldImpl(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            String signature = this.jc.getInterfaceTypeSignature(this.it);
            cv.visitField(2, signature, "_impl", null);
        }
    }

    public void generateMethodInitFcController(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            BlockSourceCodeVisitor mv = cv.visitMethod(1, null, "void", "initFcController", new String[]{InitializationContext.class.getName() + " ic"}, new String[]{InstantiationException.class.getName()});
            this.generateMethodInitFcController(mv, proxycl);
            mv.visitEnd();
        }
    }

    public void generateMethodInitFcController(BlockSourceCodeVisitor mv, UnifiedClass proxycl) {
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateMethodInitFcController(mv, proxycl);
        }
    }

    public void generateMethodClone(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            BlockSourceCodeVisitor mv = cv.visitMethod(1, null, "Object", "clone", null, null);
            this.generateMethodClone(mv, proxycl);
            mv.visitEnd();
        }
    }

    public void generateMethodClone(BlockSourceCodeVisitor mv, UnifiedClass proxycl) {
        String className = this.getClassName();
        mv.visitVar(className, "clone", "new", className + "(getFcItfDelegate())");
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateMethodClone(mv, proxycl);
        }
        mv.visitIns("return", "clone");
    }

    public void generateMethodGetFcItfDelegate(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            BlockSourceCodeVisitor mv = cv.visitMethod(1, null, "Object", "getFcItfDelegate", null, null);
            this.generateMethodGetFcItfDelegate(mv, proxycl);
            mv.visitEnd();
        }
    }

    public void generateMethodGetFcItfDelegate(BlockSourceCodeVisitor mv, UnifiedClass proxycl) {
        mv.visitIns("return", "_impl");
    }

    public void generateMethodSetFcItfDelegate(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            BlockSourceCodeVisitor mv = cv.visitMethod(1, null, "void", "setFcItfDelegate", new String[]{"Object obj"}, null);
            this.generateMethodSetFcItfDelegate(mv, proxycl);
            mv.visitEnd();
        }
    }

    public void generateMethodSetFcItfDelegate(BlockSourceCodeVisitor mv, UnifiedClass proxycl) {
        mv.visitSet("_impl", "(" + this.it.getFcItfSignature() + ")obj");
    }

    public void generateMethodOthers(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        for (int i = 0; i < this.matches.length; ++i) {
            if (!this.matches[i]) continue;
            this.iscgs[i].generateMethodOthers(cv, proxycl);
        }
    }
}

