/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.proxy;

import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.Interceptor;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.proxy.AbstractInterceptorSourceCodeGenerator;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ThenSourceCodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifeCycleSourceCodeGenerator
extends AbstractInterceptorSourceCodeGenerator {
    public LifeCycleSourceCodeGenerator() {
    }

    public LifeCycleSourceCodeGenerator(InterfaceType it, MembraneDesc<?> membraneDesc, boolean mergeable, Juliac jc) {
        super(it, membraneDesc, mergeable, jc);
    }

    @Override
    public String getClassNameSuffix() {
        String suffix = "LC";
        if (!this.mergeable) {
            String lcCtrlImplName = this.getLCCtrlImplName();
            int hash = lcCtrlImplName.hashCode();
            String hexhash = Integer.toHexString(hash);
            suffix = suffix + hexhash;
        }
        return suffix;
    }

    @Override
    public boolean match() {
        if (this.it.isFcClientItf()) {
            return false;
        }
        String name = this.it.getFcItfName();
        if (name.startsWith("//")) {
            return true;
        }
        return !name.endsWith("-controller") && !name.equals("component");
    }

    @Override
    public void generateFields(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (this.mergeable) {
            cv.visitField(1, "int", "_this_fcState", null);
            cv.visitField(1, "int", "_this_fcInvocationCounter", null);
        } else {
            String lcCtrlImplName = this.getLCCtrlImplName();
            cv.visitField(2, lcCtrlImplName, "_lc", null);
        }
    }

    @Override
    public void generateMethodInitFcController(BlockSourceCodeVisitor mv, UnifiedClass proxycl) {
        if (!this.mergeable) {
            String lcCtrlImplName = this.getLCCtrlImplName();
            mv.visitVar("Object", "olc", "ic.getInterface(\"lifecycle-controller\")");
            ThenSourceCodeVisitor then = mv.visitIf("!(", "olc", "instanceof", lcCtrlImplName, ")");
            BlockSourceCodeVisitor wdo = then.visitWhile("olc", "instanceof", Interceptor.class.getName());
            wdo.visitSet("olc", "((" + Interceptor.class.getName() + ")olc).getFcItfDelegate()").visitEnd();
            then.visitEnd();
            mv.visitSet("_lc", "(" + lcCtrlImplName + ")", "olc");
        }
    }

    @Override
    public void generateMethodClone(BlockSourceCodeVisitor mv, UnifiedClass proxycl) {
        mv.visitSet("clone._lc", "_lc");
    }

    @Override
    public void generateMethodOthers(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        if (this.mergeable) {
            BlockSourceCodeVisitor mv = cv.visitMethod(1025, null, "void", "_this_incrementFcInvocationCounter", null, null);
            mv.visitEnd();
            mv = cv.visitMethod(1025, null, "void", "_this_decrementFcInvocationCounter", null, null);
            mv.visitEnd();
        }
    }

    @Override
    public void generateProxyMethodBodyBeforeCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        if (this.mergeable) {
            BlockSourceCodeVisitor sync = mv.visitSync("this");
            ThenSourceCodeVisitor then = sync.visitIf("_this_fcState != 2");
            then.visitIns("_this_incrementFcInvocationCounter()");
            BlockSourceCodeVisitor _else = then.visitElse();
            _else.visitIns("_this_fcInvocationCounter++").visitEnd();
            sync.visitEnd();
        } else {
            BlockSourceCodeVisitor sync = mv.visitSync("_lc");
            ThenSourceCodeVisitor then = sync.visitIf("_lc.fcState != 2");
            then.visitIns("_lc.incrementFcInvocationCounter()");
            BlockSourceCodeVisitor _else = then.visitElse();
            _else.visitIns("_lc.fcInvocationCounter++").visitEnd();
            sync.visitEnd();
        }
        mv.visitln("      try {");
    }

    @Override
    public void generateProxyMethodBodyFinallyCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        mv.visitln("      }");
        mv.visitln("      finally {");
        if (this.mergeable) {
            BlockSourceCodeVisitor sync = mv.visitSync("this");
            ThenSourceCodeVisitor then = sync.visitIf("_this_fcState != 2");
            then.visitIns("_this_decrementFcInvocationCounter()");
            BlockSourceCodeVisitor _else = then.visitElse();
            _else.visitIns("_this_fcInvocationCounter--").visitEnd();
            sync.visitEnd();
        } else {
            BlockSourceCodeVisitor sync = mv.visitSync("_lc");
            ThenSourceCodeVisitor then = sync.visitIf("_lc.fcState != 2");
            then.visitIns("_lc.decrementFcInvocationCounter()");
            BlockSourceCodeVisitor _else = then.visitElse();
            _else.visitIns("_lc.fcInvocationCounter--").visitEnd();
            sync.visitEnd();
        }
        mv.visitln("      }");
    }

    private String getLCCtrlImplName() {
        String signature = LifeCycleController.class.getName();
        UnifiedClass uc = this.membraneDesc.getCtrlImpl(signature, this.jc);
        String name = uc.getName();
        return name;
    }
}

