/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.runtime;

import java.util.Iterator;
import java.util.TreeSet;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.factory.GenericFactory;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.api.type.TypeFactory;
import org.objectweb.fractal.julia.factory.ChainedInstantiationException;
import org.objectweb.fractal.julia.type.BasicComponentType;
import org.objectweb.fractal.julia.type.BasicInterfaceType;
import org.objectweb.fractal.juliac.runtime.ClassLoaderFcItf;
import org.objectweb.fractal.juliac.runtime.ClassLoaderItf;
import org.objectweb.fractal.juliac.runtime.Factory;
import org.objectweb.fractal.juliac.runtime.GenericFactoryFcItf;
import org.objectweb.fractal.juliac.runtime.RuntimeException;
import org.objectweb.fractal.juliac.runtime.TypeFactoryFcItf;

public class JuliacBootstrapComponentImpl
implements TypeFactory,
GenericFactory,
ClassLoaderItf,
Component {
    private ThreadLocal tl = new ThreadLocal();
    private Type type;
    private Object[] interfaces;
    static /* synthetic */ Class class$org$objectweb$fractal$juliac$runtime$Factory;

    public InterfaceType createFcItfType(String name, String signature, boolean isClient, boolean isOptional, boolean isCollection) {
        return new BasicInterfaceType(name, signature, isClient, isOptional, isCollection);
    }

    public ComponentType createFcType(InterfaceType[] interfaceTypes) throws InstantiationException {
        return new BasicComponentType(interfaceTypes);
    }

    public Component newFcInstance(Type type, Object controllerDesc, Object contentDesc) throws InstantiationException {
        Object contDesc;
        String ctrlDesc;
        ComponentType ct = this.checkType(type);
        String factoryClassName = this.getFactoryClassName(ct, ctrlDesc = this.checkControllerDesc(controllerDesc), contDesc = this.checkContentDesc(ctrlDesc, contentDesc));
        Class cl = this.loadClassIE(factoryClassName);
        Object f = this.instanciateClass(cl);
        if (!(f instanceof Factory)) {
            String msg = "Component initializer class " + factoryClassName + " should implement " + (class$org$objectweb$fractal$juliac$runtime$Factory == null ? (class$org$objectweb$fractal$juliac$runtime$Factory = JuliacBootstrapComponentImpl.class$("org.objectweb.fractal.juliac.runtime.Factory")) : class$org$objectweb$fractal$juliac$runtime$Factory).getName();
            throw new InstantiationException(msg);
        }
        Factory factory = (Factory)f;
        Component c = contDesc == null || contDesc instanceof String ? factory.newFcInstance() : factory.newFcInstance(contDesc);
        return c;
    }

    protected ComponentType checkType(Type type) throws InstantiationException {
        if (!(type instanceof ComponentType)) {
            String msg = "type should implement ComponentType";
            throw new InstantiationException(msg);
        }
        ComponentType ct = (ComponentType)type;
        return ct;
    }

    protected String checkControllerDesc(Object controllerDesc) throws InstantiationException {
        if (controllerDesc.getClass().isArray()) {
            Object[] array = (Object[])controllerDesc;
            ClassLoader classLoader = (ClassLoader)array[0];
            this.tl.set(classLoader);
            controllerDesc = array[1];
        }
        if (!(controllerDesc instanceof String)) {
            String msg = "controllerDesc should be a String";
            throw new InstantiationException(msg);
        }
        String ctrlDesc = (String)controllerDesc;
        return ctrlDesc;
    }

    protected Object checkContentDesc(String ctrlDesc, Object contentDesc) throws InstantiationException {
        if (ctrlDesc.endsWith("Template")) {
            Object[] cont = (Object[])contentDesc;
            contentDesc = cont[1];
        }
        return contentDesc;
    }

    protected String getFactoryClassName(ComponentType ct, String ctrlDesc, Object contDesc) {
        InterfaceType[] its = ct.getFcInterfaceTypes();
        TreeSet<String> names = new TreeSet<String>();
        for (int i = 0; i < its.length; ++i) {
            InterfaceType it = its[i];
            String name = it.getFcItfName();
            names.add(name);
        }
        StringBuffer sct = new StringBuffer("[");
        boolean first = true;
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            InterfaceType it = null;
            try {
                it = ct.getFcInterfaceType(name);
            }
            catch (NoSuchInterfaceException nsie) {
                throw new RuntimeException(nsie);
            }
            if (first) {
                first = false;
            } else {
                sct.append(',');
            }
            sct.append(it.toString());
        }
        sct.append(']');
        int hashct = sct.toString().hashCode();
        String hexhashct = Integer.toHexString(hashct);
        String membraneClassName = contDesc == null ? "juliac.generated." + ctrlDesc : (contDesc instanceof String ? contDesc : contDesc.getClass().getName()) + "FC" + ctrlDesc;
        String factoryClassName = membraneClassName + "FC" + hexhashct;
        return factoryClassName;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader cl = this.getClassLoader();
        Class<?> c = cl.loadClass(name);
        return c;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader cl = (ClassLoader)this.tl.get();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl;
    }

    protected Class loadClassIE(String name) throws InstantiationException {
        try {
            Class cl = this.loadClass(name);
            return cl;
        }
        catch (ClassNotFoundException cnfe) {
            throw new ChainedInstantiationException(cnfe, null, "");
        }
    }

    protected Object instanciateClass(Class cl) throws InstantiationException {
        try {
            Object o = cl.newInstance();
            return o;
        }
        catch (java.lang.InstantiationException ie) {
            throw new ChainedInstantiationException(ie, null, "");
        }
        catch (IllegalAccessException iae) {
            throw new ChainedInstantiationException(iae, null, "");
        }
    }

    public Object getFcInterface(String arg0) throws NoSuchInterfaceException {
        Object[] interfaces = this.getFcInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String name = ((Interface)interfaces[i]).getFcItfName();
            if (!name.equals(arg0)) continue;
            return interfaces[i];
        }
        throw new NoSuchInterfaceException(arg0);
    }

    public Object[] getFcInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new Object[]{new TypeFactoryFcItf(this, "type-factory", TypeFactoryFcItf.TYPE, false, this), new GenericFactoryFcItf(this, "generic-factory", GenericFactoryFcItf.TYPE, false, this), new ClassLoaderFcItf(this, "classloader", ClassLoaderFcItf.TYPE, false, this)};
        }
        return this.interfaces;
    }

    public Type getFcType() {
        if (this.type == null) {
            try {
                this.type = new BasicComponentType(new InterfaceType[]{TypeFactoryFcItf.TYPE, GenericFactoryFcItf.TYPE, ClassLoaderFcItf.TYPE});
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return this.type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

