/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.ucf;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.objectweb.fractal.juliac.ucf.UClass;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UCMethod
implements UnifiedMethod {
    private Method method;
    private UClass uClass;

    public UCMethod(UClass uClass, Method method) {
        this.uClass = uClass;
        this.method = method;
    }

    @Override
    public UClass getDeclaringClass() {
        return this.uClass;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        A a = this.method.getAnnotation(annotationType);
        return a;
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] annots = this.method.getAnnotations();
        return annots;
    }

    @Override
    public UnifiedClass[] getExceptionTypes() {
        Class<?>[] params = this.method.getExceptionTypes();
        UnifiedClass[] ucs = new UnifiedClass[params.length];
        for (int i = 0; i < params.length; ++i) {
            ucs[i] = new UClass(params[i]);
        }
        return ucs;
    }

    @Override
    public String[] getGenericExceptionTypes() {
        Type[] throwns = this.method.getGenericExceptionTypes();
        String[] gets = new String[throwns.length];
        for (int i = 0; i < throwns.length; ++i) {
            String typename;
            gets[i] = typename = this.uClass.toString(throwns[i]);
        }
        return gets;
    }

    @Override
    public String getGenericReturnType() {
        Type type = this.method.getGenericReturnType();
        String typename = this.uClass.toString(type);
        return typename;
    }

    @Override
    public int getModifiers() {
        int result = this.method.getModifiers();
        return result;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public String[] getParameters() {
        Type[] tps = this.method.getGenericParameterTypes();
        String[] params = new String[tps.length];
        for (int i = 0; i < tps.length; ++i) {
            String typename = this.uClass.toString(tps[i]);
            StringBuffer sb = new StringBuffer(typename);
            sb.append(" arg");
            sb.append(i);
            params[i] = sb.toString();
        }
        return params;
    }

    @Override
    public UnifiedClass[] getParameterTypes() {
        Class<?>[] params = this.method.getParameterTypes();
        UnifiedClass[] ucs = new UnifiedClass[params.length];
        for (int i = 0; i < params.length; ++i) {
            ucs[i] = new UClass(params[i]);
        }
        return ucs;
    }

    @Override
    public UnifiedClass getReturnType() {
        Class<?> cl = this.method.getReturnType();
        UClass uc = new UClass(cl);
        return uc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        sb.append(this.getName());
        String[] params = this.getParameters();
        sb.append('(');
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            if (i != 0) {
                sb.append(',');
            }
            sb.append(param);
        }
        sb.append(')');
        String[] exceptions = this.getGenericExceptionTypes();
        if (exceptions != null && exceptions.length != 0) {
            sb.append(" throws ");
            for (int i = 0; i < exceptions.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(exceptions[i]);
            }
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    public String[] getTypeParameterNames() {
        TypeVariable<Method>[] tvs = this.method.getTypeParameters();
        if (tvs.length == 0) {
            return new String[0];
        }
        String[] tps = new String[tvs.length];
        for (int i = 0; i < tvs.length; ++i) {
            TypeVariable<Method> tv = tvs[i];
            tps[i] = tv.getName();
        }
        return tps;
    }

    @Override
    public String[] getTypeParameters() {
        TypeVariable<Method>[] tvs = this.method.getTypeParameters();
        if (tvs.length == 0) {
            return new String[0];
        }
        String[] tps = new String[tvs.length];
        for (int i = 0; i < tvs.length; ++i) {
            TypeVariable<Method> tv = tvs[i];
            Type[] bounds = tv.getBounds();
            if (bounds.length == 0) {
                String msg = "Unsupported array bounds of length 0 for: " + tv;
                throw new RuntimeException(msg);
            }
            StringBuffer sb = new StringBuffer(tv.getName());
            if (bounds.length != 1 || !Object.class.equals((Object)bounds[0])) {
                sb.append(" extends ");
                for (int j = 0; j < bounds.length; ++j) {
                    if (j != 0) {
                        sb.append(" & ");
                    }
                    String s = this.uClass.toString(bounds[j]);
                    sb.append(s);
                }
            }
            tps[i] = sb.toString();
        }
        return tps;
    }
}

