/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.ucf;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.JuliacRuntimeException;
import org.objectweb.fractal.juliac.conf.JuliacConfig;
import org.objectweb.fractal.juliac.ucf.UCField;
import org.objectweb.fractal.juliac.ucf.UCMethod;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedField;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UClass
implements UnifiedClass {
    private Class<?> cl;
    private Juliac jc;
    private Map<Type, Type> genericTypeValues = new HashMap<Type, Type>();
    private static final Map<String, Class<?>> primitives = new HashMap<String, Class<?>>(){
        private static final long serialVersionUID = 4126982862148826431L;
        {
            this.put("boolean", Boolean.TYPE);
            this.put("char", Character.TYPE);
            this.put("byte", Byte.TYPE);
            this.put("short", Short.TYPE);
            this.put("int", Integer.TYPE);
            this.put("long", Long.TYPE);
            this.put("float", Float.TYPE);
            this.put("double", Double.TYPE);
            this.put("void", Void.TYPE);
        }
    };
    private static final Map<Class<?>, UClass> boxed = new HashMap<Class<?>, UClass>(){
        private static final long serialVersionUID = 2398856843237335831L;
        {
            this.put(Boolean.TYPE, new UClass(Boolean.class));
            this.put(Character.TYPE, new UClass(Character.class));
            this.put(Byte.TYPE, new UClass(Byte.class));
            this.put(Short.TYPE, new UClass(Short.class));
            this.put(Integer.TYPE, new UClass(Integer.class));
            this.put(Long.TYPE, new UClass(Long.class));
            this.put(Float.TYPE, new UClass(Float.class));
            this.put(Double.TYPE, new UClass(Double.class));
            this.put(Void.TYPE, new UClass(Void.class));
        }
    };
    private static final Map<Class<?>, String> nulvalues = new HashMap<Class<?>, String>(){
        private static final long serialVersionUID = -8428019352784119543L;
        {
            this.put(Boolean.TYPE, "false");
            this.put(Character.TYPE, " ");
            this.put(Byte.TYPE, "0");
            this.put(Short.TYPE, "0");
            this.put(Integer.TYPE, "0");
            this.put(Long.TYPE, "0");
            this.put(Float.TYPE, "0.0f");
            this.put(Double.TYPE, "0.0");
        }
    };

    public UClass(String name, Juliac jc) throws ClassNotFoundException {
        this.jc = jc;
        JuliacConfig jconf = jc.getJuliacConfig();
        ClassLoader classloader = jconf.getClassLoader();
        try {
            Class<?> cl = classloader.loadClass(name);
            this.setClass(cl);
        }
        catch (ClassNotFoundException e) {
            if (primitives.containsKey(name)) {
                this.cl = primitives.get(name);
            }
            throw new ClassNotFoundException(name);
        }
    }

    public UClass(Class<?> cl) {
        this.setClass(cl);
    }

    private void setClass(Class<?> cl) {
        this.cl = cl;
        if (cl.isPrimitive()) {
            return;
        }
        Stack<Class> genericInterfaces = new Stack<Class>();
        HashSet<Class> interfacesAlreadyAnalized = new HashSet<Class>();
        genericInterfaces.add(cl);
        while (!genericInterfaces.isEmpty()) {
            Type[] ginterfaces;
            Class genericInterface = (Class)genericInterfaces.pop();
            for (Type ginterface : ginterfaces = genericInterface.getGenericInterfaces()) {
                if (ginterface instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)ginterface;
                    Class rawType = (Class)parameterizedType.getRawType();
                    if (!interfacesAlreadyAnalized.add(rawType)) continue;
                    TypeVariable<Class<T>>[] rawTypeTypeParameters = rawType.getTypeParameters();
                    Type[] typeArguments = parameterizedType.getActualTypeArguments();
                    for (int i = 0; i < rawTypeTypeParameters.length; ++i) {
                        TypeVariable rawTypeTypeParameter = rawTypeTypeParameters[i];
                        Type typeArgument = typeArguments[i];
                        Type typeVariableValue = this.genericTypeValues.get(typeArgument);
                        if (typeVariableValue == null) {
                            this.genericTypeValues.put(rawTypeTypeParameter, typeArgument);
                            continue;
                        }
                        this.genericTypeValues.put(rawTypeTypeParameter, typeVariableValue);
                    }
                    genericInterfaces.push(rawType);
                    continue;
                }
                if (ginterface instanceof Class) {
                    genericInterfaces.push((Class)ginterface);
                    continue;
                }
                String msg = "SuperGenericInterface is not a class : " + ginterface + "(" + ginterface.getClass() + ")";
                throw new JuliacRuntimeException(msg);
            }
        }
    }

    @Override
    public UnifiedClass box() {
        if (this.cl.isPrimitive()) {
            UClass b = boxed.get(this.cl);
            return b;
        }
        return this;
    }

    @Override
    public boolean isAssignableFrom(UnifiedClass uc) {
        try {
            UClass other = this.toUClass(uc);
            boolean b = this.cl.isAssignableFrom(other.cl);
            return b;
        }
        catch (ClassNotFoundException ucnfe) {
            boolean b = uc.isAssignableTo(this);
            return b;
        }
    }

    @Override
    public boolean isAssignableTo(UnifiedClass uc) {
        try {
            UClass other = this.toUClass(uc);
            boolean b = other.cl.isAssignableFrom(this.cl);
            return b;
        }
        catch (ClassNotFoundException ucnfe) {
            return false;
        }
    }

    @Override
    public boolean isInterface() {
        boolean isInterface = this.cl.isInterface();
        return isInterface;
    }

    @Override
    public boolean isPrimitive() {
        boolean isPrimitive = this.cl.isPrimitive();
        return isPrimitive;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        A a = this.cl.getAnnotation(annotationType);
        return a;
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] annots = this.cl.getAnnotations();
        return annots;
    }

    @Override
    public UnifiedClass getDeclaringClass() {
        Class<?> dc = this.cl.getDeclaringClass();
        if (dc == null) {
            return null;
        }
        UClass udc = new UClass(dc);
        return udc;
    }

    @Override
    public UnifiedField[] getDeclaredFields() {
        Field[] fields = this.cl.getDeclaredFields();
        UnifiedField[] ufields = new UnifiedField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ufields[i] = new UCField(this, fields[i]);
        }
        return ufields;
    }

    @Override
    public UnifiedClass[] getInterfaces() {
        Class<?>[] classes = this.cl.getInterfaces();
        UnifiedClass[] ucs = new UnifiedClass[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            ucs[i] = new UClass(classes[i]);
        }
        return ucs;
    }

    @Override
    public UnifiedField getDeclaredField(String name) throws NoSuchFieldException {
        Field field = this.cl.getDeclaredField(name);
        UCField ufield = new UCField(this, field);
        return ufield;
    }

    @Override
    public UnifiedField[] getFields() {
        Field[] fields = this.cl.getFields();
        UnifiedField[] ufields = new UnifiedField[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ufields[i] = new UCField(this, fields[i]);
        }
        return ufields;
    }

    @Override
    public UnifiedMethod[] getMethods() {
        Method[] meths = this.cl.getMethods();
        UnifiedMethod[] umeths = new UnifiedMethod[meths.length];
        for (int i = 0; i < meths.length; ++i) {
            umeths[i] = new UCMethod(this, meths[i]);
        }
        return umeths;
    }

    @Override
    public UnifiedMethod getMethod(String name, Class<?> ... types) throws NoSuchMethodException {
        Method m = this.cl.getMethod(name, types);
        UCMethod um = new UCMethod(this, m);
        return um;
    }

    @Override
    public int getModifiers() {
        int mods = this.cl.getModifiers();
        return mods;
    }

    @Override
    public String getName() {
        return this.getName(this.cl);
    }

    @Override
    public String getNullValue() {
        if (nulvalues.containsKey(this.cl)) {
            String ret = nulvalues.get(this.cl);
            return ret;
        }
        return "null";
    }

    @Override
    public UnifiedClass getSuperclass() {
        Class<?> sup = this.cl.getSuperclass();
        UClass uc = new UClass(sup);
        return uc;
    }

    @Override
    public String[] getTypeParameters() {
        TypeVariable<Class<?>>[] tvs = this.cl.getTypeParameters();
        String[] rets = new String[tvs.length];
        for (int i = 0; i < tvs.length; ++i) {
            StringBuffer sb = new StringBuffer();
            String s = tvs[i].toString();
            sb.append(s);
            Type[] bounds = tvs[i].getBounds();
            if (bounds.length != 0 && !bounds[0].equals(Object.class)) {
                sb.append(" extends ");
                for (int j = 0; j < bounds.length; ++j) {
                    if (j != 0) {
                        sb.append(" & ");
                    }
                    Type bound = bounds[j];
                    s = this.toString(bound);
                    sb.append(s);
                }
            }
            rets[i] = sb.toString();
        }
        return rets;
    }

    @Override
    public String[] getTypeParameterNames() {
        TypeVariable<Class<?>>[] tvs = this.cl.getTypeParameters();
        String[] rets = new String[tvs.length];
        for (int i = 0; i < tvs.length; ++i) {
            rets[i] = tvs[i].toString();
        }
        return rets;
    }

    @Override
    public String getValueDelimiter() {
        if (this.cl.equals(String.class)) {
            return "\"";
        }
        if (this.cl.equals(Character.TYPE) || this.cl.equals(Character.class)) {
            return "'";
        }
        return "";
    }

    public boolean equals(Object other) {
        if (!(other instanceof UnifiedClass)) {
            return false;
        }
        String name = this.getName();
        String othername = ((UnifiedClass)other).getName();
        return name.equals(othername);
    }

    public String toString() {
        return this.getName();
    }

    public String getName(Class<?> cl) {
        if (cl.isArray()) {
            Class element = cl.getComponentType();
            element = (Class)this.resolveGenericType(element);
            return this.getName(element) + "[]";
        }
        String name = cl.getName();
        if (name.indexOf(36) != -1) {
            name = name.replace('$', '.');
        }
        return name;
    }

    private UClass toUClass(UnifiedClass uc) throws ClassNotFoundException {
        if (uc instanceof UClass) {
            return (UClass)uc;
        }
        String name = uc.getName();
        if (this.jc == null) {
            String msg = "Constructor (String,Juliac) should have been invoked for creating this instance instead of constructor (Class<?>)";
            throw new JuliacRuntimeException(msg);
        }
        UClass other = new UClass(name, this.jc);
        return other;
    }

    String toString(Type type) {
        if ((type = this.resolveGenericType(type)) instanceof Class) {
            String s = this.getName((Class)type);
            return s;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            String s = this.toString(rawType);
            StringBuilder sb = new StringBuilder(s);
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                sb.append(i == 0 ? (char)'<' : ',');
                s = this.toString(actualTypeArguments[i]);
                sb.append(s);
            }
            if (actualTypeArguments.length > 0) {
                sb.append('>');
            }
            return sb.toString();
        }
        return type.toString();
    }

    private final Type resolveGenericType(Type type) {
        Type result = type;
        if (type instanceof TypeVariable && this.genericTypeValues.containsKey((TypeVariable)type)) {
            result = this.genericTypeValues.get(type);
        }
        return result;
    }
}

