/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.ucf;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedField;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedClassHelper {
    public static UnifiedMethod[] getMethodsWithMostSpecializedReturnType(UnifiedClass unifiedClass) {
        UnifiedMethod[] methods;
        HashMap methodsByName = new HashMap();
        for (UnifiedMethod method : methods = unifiedClass.getMethods()) {
            UnifiedMethod[] _methodsArray;
            String methodName = method.getName();
            boolean methodAlreadyExists = methodsByName.containsKey(methodName);
            if (!methodAlreadyExists) {
                HashSet<UnifiedMethod> set = new HashSet<UnifiedMethod>();
                set.add(method);
                methodsByName.put(methodName, set);
                continue;
            }
            Collection _methods = (Collection)methodsByName.get(methodName);
            for (UnifiedMethod _method : _methodsArray = _methods.toArray(new UnifiedMethod[0])) {
                String[] _parameters;
                String[] parameters = method.getParameters();
                boolean bl = methodAlreadyExists = parameters.length == (_parameters = _method.getParameters()).length;
                if (!methodAlreadyExists) continue;
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i].equals(_parameters[i])) continue;
                    methodAlreadyExists = false;
                    break;
                }
                if (!methodAlreadyExists) continue;
                UnifiedClass returnType = method.getReturnType();
                UnifiedClass _returnType = _method.getReturnType();
                if (_returnType.isAssignableFrom(returnType)) {
                    _methods.remove(_method);
                    _methods.add(method);
                    continue;
                }
                if (returnType.isAssignableFrom(_returnType)) break;
            }
            if (methodAlreadyExists) continue;
            _methods.add(method);
        }
        HashSet<UnifiedMethod> unifiedMethods = new HashSet<UnifiedMethod>();
        for (Collection _methods : methodsByName.values()) {
            for (UnifiedMethod _method : _methods) {
                unifiedMethods.add(_method);
            }
        }
        return unifiedMethods.toArray(new UnifiedMethod[0]);
    }

    public static <A extends Annotation> A getAnnotation(UnifiedClass uc, Class<A> annotationClass) {
        A annot = uc.getAnnotation(annotationClass);
        if (annot != null) {
            return annot;
        }
        UnifiedClass supercl = uc.getSuperclass();
        if (!supercl.getName().equals(Object.class.getName())) {
            annot = UnifiedClassHelper.getAnnotation(supercl, annotationClass);
            return annot;
        }
        return null;
    }

    public static UnifiedField[] getAllFields(UnifiedClass uc) {
        ArrayList<UnifiedField> result = new ArrayList<UnifiedField>();
        UnifiedClassHelper.addAllFields(uc, result);
        return result.toArray(new UnifiedField[result.size()]);
    }

    public static void addAllFields(UnifiedClass uc, List<UnifiedField> list) {
        UnifiedField[] fields;
        for (UnifiedField field : fields = uc.getDeclaredFields()) {
            list.add(field);
        }
        UnifiedClass supercl = uc.getSuperclass();
        if (!supercl.getName().equals(Object.class.getName())) {
            UnifiedClassHelper.addAllFields(supercl, list);
        }
    }

    public static boolean override(UnifiedField src, UnifiedField target) {
        String targetname;
        String srcname = src.getName();
        boolean b = srcname.equals(targetname = target.getName());
        if (!b) {
            return false;
        }
        UnifiedClass srccl = src.getDeclaringClass();
        UnifiedClass targetcl = target.getDeclaringClass();
        return targetcl.isAssignableFrom(srccl);
    }

    public static UnifiedField[] removeOverriden(UnifiedField[] fields) {
        ArrayList<UnifiedField> res = new ArrayList<UnifiedField>();
        res.addAll(Arrays.asList(fields));
        for (int i = 0; i < fields.length; ++i) {
            for (int j = 0; j < fields.length; ++j) {
                boolean b;
                if (j == i || !(b = UnifiedClassHelper.override(fields[j], fields[i]))) continue;
                res.remove(fields[i]);
            }
        }
        return res.toArray(new UnifiedField[res.size()]);
    }

    public static Annotation getAnnotation(UnifiedClass uc, String ... annotClassNames) {
        Annotation[] annots;
        for (Annotation annot : annots = uc.getAnnotations()) {
            for (String annotClassName : annotClassNames) {
                String name = annot.annotationType().getName();
                if (!name.equals(annotClassName)) continue;
                return annot;
            }
        }
        return null;
    }

    public static Annotation getAnnotation(UnifiedMethod um, String ... annotClassNames) {
        Annotation[] annots;
        for (Annotation annot : annots = um.getAnnotations()) {
            for (String annotClassName : annotClassNames) {
                String name = annot.annotationType().getName();
                if (!name.equals(annotClassName)) continue;
                return annot;
            }
        }
        return null;
    }
}

