/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.visit;

import java.io.PrintWriter;
import org.objectweb.fractal.juliac.visit.CodeHelper;

public abstract class AbstractCodeWriter {
    private final String DEFAULT_INDENT = "  ";
    private final PrintWriter pw;
    protected boolean indented = false;
    protected int indent;

    protected AbstractCodeWriter(PrintWriter pw, int level, boolean indented) {
        this.pw = pw;
        this.indent = level;
        this.indented = indented;
    }

    protected AbstractCodeWriter(PrintWriter pw, int level) {
        this(pw, level, false);
    }

    protected AbstractCodeWriter(PrintWriter pw) {
        this(pw, 0);
    }

    protected final PrintWriter writer() {
        return this.pw;
    }

    protected final void write(Object ... code) {
        if (code == null || code.length == 0) {
            return;
        }
        if (!this.indented) {
            for (int i = 0; i < this.indent; ++i) {
                this.writer().print("  ");
            }
            this.indented = true;
        }
        this.writer().print(CodeHelper.asString(code));
        this.writer().flush();
    }

    protected final void writeln(Object ... code) {
        this.write(code);
        this.writer().println();
        this.indented = false;
    }
}

