/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.visit;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import org.objectweb.fractal.juliac.visit.AbstractCodeWriter;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.CatchSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ThenSourceCodeVisitor;

public class AbstractSourceCodeWriter
extends AbstractCodeWriter
implements BlockSourceCodeVisitor {
    private int state = 0;
    private static final int BEGIN_STATE = 0;
    private static final int FINAL_STATE = 2;

    public AbstractSourceCodeWriter(PrintWriter writer) {
        super(writer, 1);
    }

    private final BlockSourceCodeVisitor illegalState() {
        throw new IllegalStateException("Block body cannot be visited at this stage of the visit");
    }

    public BlockSourceCodeVisitor visitBegin() {
        Preconditions.checkState(this.state == 0, "Block beginning cannot be visited at this stage of the visit");
        this.writeln(";");
        this.state = 2;
        return this;
    }

    public void visit(Object code) {
        this.illegalState();
    }

    public BlockSourceCodeVisitor visitln(Object ... code) {
        return this.illegalState();
    }

    public BlockSourceCodeVisitor visitComment(String comment) {
        return this.illegalState();
    }

    public BlockSourceCodeVisitor visitVar(Object type, String name, Object ... code) {
        return this.illegalState();
    }

    public BlockSourceCodeVisitor visitIns(Object ... code) {
        return this.illegalState();
    }

    public BlockSourceCodeVisitor visitSet(String name, Object ... code) {
        return this.illegalState();
    }

    public ThenSourceCodeVisitor visitIf(Object ... condition) {
        return (ThenSourceCodeVisitor)this.illegalState();
    }

    public BlockSourceCodeVisitor visitWhile(Object ... condition) {
        return this.illegalState();
    }

    public BlockSourceCodeVisitor visitFor(Object ... condition) {
        return this.illegalState();
    }

    public CatchSourceCodeVisitor visitTry() {
        return (CatchSourceCodeVisitor)this.illegalState();
    }

    public BlockSourceCodeVisitor visitSync(String obj) {
        return this.illegalState();
    }

    public void visitEnd() {
    }
}

