/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.visit;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.PrintWriter;
import org.objectweb.fractal.juliac.visit.AbstractCodeWriter;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.CatchSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.CatchSourceCodeWriter;
import org.objectweb.fractal.juliac.visit.CodeHelper;
import org.objectweb.fractal.juliac.visit.ThenSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ThenSourceCodeWriter;

public class BlockSourceCodeWriter
extends AbstractCodeWriter
implements BlockSourceCodeVisitor {
    protected int state = 0;
    protected static final int BEGIN_STATE = 0;
    protected static final int BODY_STATE = 1;
    protected static final int FINAL_STATE = 2;

    public BlockSourceCodeWriter(PrintWriter pw, int il, boolean indented) {
        super(pw, il, indented);
    }

    public BlockSourceCodeVisitor visitBegin() {
        Preconditions.checkState(this.state == 0, "Block beginning cannot be visited at this stage of the visit");
        this.writeln("{");
        ++this.indent;
        this.state = 1;
        return this;
    }

    private final void checkBodyState(String text) {
        Preconditions.checkState(this.state == 1, "Block " + text + " cannot be visited at this stage of the visit");
    }

    public void visit(Object code) {
        this.checkBodyState("body");
        this.writer().write(CodeHelper.asString(code));
    }

    public final BlockSourceCodeVisitor visitln(Object ... code) {
        this.checkBodyState("body");
        this.writer().write(CodeHelper.asString(code) + "\n");
        return this;
    }

    public BlockSourceCodeVisitor visitComment(String comment) {
        this.checkBodyState("body");
        this.visitln("// " + comment);
        return this;
    }

    public BlockSourceCodeVisitor visitIns(Object ... code) {
        this.checkBodyState("body");
        this.write(code);
        this.writeln(";");
        return this;
    }

    public BlockSourceCodeVisitor visitVar(Object type, String name, Object ... code) {
        if (code == null || code.length == 0) {
            return this.visitIns(type, name);
        }
        return this.visitIns(type, name, "=", CodeHelper.asString(code));
    }

    public BlockSourceCodeVisitor visitSet(String name, Object ... code) {
        return this.visitIns(Lists.asList(name, "=", code).toArray());
    }

    public ThenSourceCodeVisitor visitIf(Object ... condition) {
        this.checkBodyState("if");
        this.writeln("if", "(", CodeHelper.asString(condition), ")");
        return (ThenSourceCodeVisitor)new ThenSourceCodeWriter(this.writer(), this.indent).visitBegin();
    }

    public BlockSourceCodeVisitor visitWhile(Object ... condition) {
        this.checkBodyState("while");
        this.writeln("while", "(", CodeHelper.asString(condition), ")");
        return new BlockSourceCodeWriter(this.writer(), this.indent, false).visitBegin();
    }

    public BlockSourceCodeVisitor visitFor(Object ... condition) {
        this.checkBodyState("for");
        this.writeln("for", "(", CodeHelper.asString(condition), ")");
        return new BlockSourceCodeWriter(this.writer(), this.indent, false).visitBegin();
    }

    public CatchSourceCodeVisitor visitTry() {
        this.checkBodyState("try");
        this.writeln("try");
        return (CatchSourceCodeVisitor)new CatchSourceCodeWriter(this.writer(), this.indent).visitBegin();
    }

    public BlockSourceCodeVisitor visitSync(String obj) {
        this.checkBodyState("synchronized");
        this.writeln("synchronized(" + obj + ")");
        return new BlockSourceCodeWriter(this.writer(), this.indent, false).visitBegin();
    }

    public void visitEnd() {
        Preconditions.checkState(this.state == 1, "Block end cannot be visited at this stage of the visit");
        --this.indent;
        this.writeln("}");
        this.writeln(new Object[0]);
        this.state = 2;
    }
}

