/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.visit;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import org.objectweb.fractal.juliac.visit.AbstractCodeWriter;
import org.objectweb.fractal.juliac.visit.AbstractSourceCodeWriter;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeWriter;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;

public class ClassSourceCodeWriter
extends AbstractCodeWriter
implements ClassSourceCodeVisitor {
    private String className;
    private int state = 1;
    private static final int DECLARATION_STATE = 1;
    private static final int BODY_STATE = 2;
    private static final int END_STATE = 3;
    private static final int FINAL_STATE = 4;

    public ClassSourceCodeWriter(PrintWriter pw) {
        super(pw);
    }

    public ClassSourceCodeWriter(PrintWriter pw, int level) {
        super(pw, level);
    }

    public void visit(int modifiers, String name, String[] genericTypeParameters, String superClassName, String[] implementedInterfaceNames) {
        if (this.state < 1) {
            this.state = 1;
        }
        Preconditions.checkState(this.state == 1, "Class declaration cannot be visited at this stage of the visit");
        this.className = name;
        this.writeln(new Object[0]);
        this.write(Modifier.toString(modifiers), "class", name + this.generics(genericTypeParameters));
        if (superClassName != null) {
            this.writeln(new Object[0]);
            this.write("extends", superClassName);
        }
        if (implementedInterfaceNames != null) {
            this.writeln(new Object[0]);
            this.write("implements", Joiner.on(",").join(implementedInterfaceNames));
        }
        this.writeln(" {");
        this.writeln(new Object[0]);
        ++this.indent;
        this.state = 2;
    }

    public BlockSourceCodeVisitor visitStaticPart() {
        Preconditions.checkState(this.state == 2, "Class body cannot be visited at this stage of the visit");
        this.write("static");
        return new BlockSourceCodeWriter(this.writer(), this.indent, false).visitBegin();
    }

    public void visitField(int modifiers, String type, String name, String expression) {
        Preconditions.checkState(this.state == 2, "Class body cannot be visited at this stage of the visit");
        String value = expression != null ? "= " + expression : "";
        this.writeln(Modifier.toString(modifiers), type, name + value + ";");
    }

    public BlockSourceCodeVisitor visitConstructor(int modifiers, String[] genericTypeParameters, String[] parameters, String[] exceptions) {
        Preconditions.checkState(this.state == 2, "Class body cannot be visited at this stage of the visit");
        this.write(Modifier.toString(modifiers), this.generics(genericTypeParameters) + this.className + this.parameters(parameters) + this.exceptions(exceptions));
        this.indented = false;
        return new BlockSourceCodeWriter(this.writer(), this.indent, false).visitBegin();
    }

    public BlockSourceCodeVisitor visitMethod(int modifiers, String[] typeParameters, String returnType, String name, String[] parameters, String[] exceptions) {
        Preconditions.checkState(this.state == 2, "Class method cannot be visited at this stage of the visit");
        this.write(Modifier.toString(modifiers), this.generics(typeParameters) + returnType, name + this.parameters(parameters) + this.exceptions(exceptions));
        AbstractCodeWriter bv = Modifier.isAbstract(modifiers) ? new AbstractSourceCodeWriter(this.writer()) : new BlockSourceCodeWriter(this.writer(), this.indent, false);
        this.indented = false;
        return bv.visitBegin();
    }

    public ClassSourceCodeVisitor visitInnerClass() {
        Preconditions.checkState(this.state == 2, "Class body can not be visited at this stage of the visit");
        return new ClassSourceCodeWriter(this.writer(), this.indent);
    }

    public void visitEnd() {
        if (this.state == 1 || this.state == 2) {
            this.state = 3;
        }
        Preconditions.checkState(this.state == 3, "Class end can not be visited at this stage of the visit");
        --this.indent;
        this.writeln("}");
        this.state = 4;
    }

    private final String generics(String[] genericTypeParameters) {
        if (genericTypeParameters != null && genericTypeParameters.length != 0) {
            return "<" + Joiner.on(",").join(genericTypeParameters) + ">";
        }
        return "";
    }

    private final String parameters(String[] parameters) {
        if (parameters != null && parameters.length != 0) {
            return "(" + Joiner.on(",").join(parameters) + ")";
        }
        return "()";
    }

    private final String exceptions(String[] exceptions) {
        if (exceptions != null && exceptions.length != 0) {
            return " throws " + Joiner.on(",").join(exceptions);
        }
        return "";
    }
}

