/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.visit;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class CodeHelper {
    public static final String asString(Object o) {
        Preconditions.checkNotNull(o);
        if (o instanceof Class) {
            return ((Class)o).getName();
        }
        return Strings.nullToEmpty(o.toString());
    }

    public static final String[] convert(Object ... o) {
        String[] res = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            res[i] = CodeHelper.asString(o[i]);
        }
        return res;
    }

    public static final String asString(String sep, Object ... o) {
        if (o == null || o.length == 0) {
            return null;
        }
        return Joiner.on(sep).skipNulls().join(CodeHelper.convert(o));
    }

    public static final String asString(Object ... code) {
        return CodeHelper.asString(" ", code);
    }

    public static final String _throw(Object ex, Object ... params) {
        return "throw " + CodeHelper._new(ex, params);
    }

    public static final String _new(Object cls, Object ... params) {
        String res = "new " + CodeHelper.asString(cls) + "(";
        if (params != null & params.length > 0) {
            res = res + CodeHelper.asString(",", params);
        }
        return res + ")";
    }
}

