/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.juliac.visit;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import org.objectweb.fractal.juliac.visit.AbstractCodeWriter;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeWriter;
import org.objectweb.fractal.juliac.visit.FileSourceCodeVisitor;

public class FileSourceCodeWriter
extends AbstractCodeWriter
implements FileSourceCodeVisitor {
    private int state = 0;
    private static final int FILE_HEADER_STATE = 0;
    private static final int PACKAGE_NAME_STATE = 1;
    private static final int IMPORTS_STATE = 2;
    private static final int CLASS_STATE = 3;
    private static final int END_STATE = 4;

    public FileSourceCodeWriter(PrintWriter pw) {
        super(pw);
    }

    public void visitFileHeader(String header) {
        Preconditions.checkState(this.state == 0, "File headers can not be visited at this stage of the visit");
        this.writeln(header);
    }

    public void visitPackageName(String name) {
        if (this.state < 1) {
            this.state = 1;
        }
        Preconditions.checkState(this.state == 1, "Package name can not be visited at this stage of the visit");
        this.writeln(new Object[0]);
        this.writeln("package", name + ";");
        this.writeln(new Object[0]);
        this.state = 2;
    }

    public void visitImport(String name) {
        if (this.state < 2) {
            this.state = 2;
        }
        Preconditions.checkState(this.state == 2, "Imports can not be visited at this stage of the visit");
        this.writeln("import", name + ";");
    }

    public ClassSourceCodeVisitor visitPublicClass() {
        if (this.state < 3) {
            this.state = 3;
        }
        Preconditions.checkState(this.state == 3, "Class declaration can not be visited at this stage of the visit");
        this.state = 4;
        return new ClassSourceCodeWriter(this.writer());
    }
}

