/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.objectweb.util.monolog.TestSuite;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.LevelFactory;

public class TestLevel
extends TestCase {
    public static final String[] SETTER_METHODS = new String[]{"setLevelFactoryClassName"};
    protected LevelFactory lf = null;
    private Level l = null;
    static /* synthetic */ Class class$org$objectweb$util$monolog$TestLevel;

    public TestLevel() {
        super("");
    }

    public void setLevelFactoryClassName(String lfcn) {
        try {
            this.lf = (LevelFactory)Class.forName(lfcn).newInstance();
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("The specified class is not a Level factory: " + lfcn);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Level factory class is not availlable: " + lfcn);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Syntax error !");
            System.out.println("java TestLevel <level factory class name>");
            System.exit(12);
        }
        Object[] params = new Object[]{args[0]};
        try {
            TestSuite suite = new TestSuite(class$org$objectweb$util$monolog$TestLevel == null ? (class$org$objectweb$util$monolog$TestLevel = TestLevel.class$("org.objectweb.util.monolog.TestLevel")) : class$org$objectweb$util$monolog$TestLevel, SETTER_METHODS, params);
            TestRunner.run((Test)suite);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static TestSuite getTestSuite(String lfcn) {
        Object[] params = new Object[]{lfcn};
        try {
            return new TestSuite(class$org$objectweb$util$monolog$TestLevel == null ? (class$org$objectweb$util$monolog$TestLevel = TestLevel.class$("org.objectweb.util.monolog.TestLevel")) : class$org$objectweb$util$monolog$TestLevel, SETTER_METHODS, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void testInterLevelDef() {
        TestLevel.assertEquals("Predefined level unreconized", BasicLevel.DEBUG, this.lf.getLevel("DEBUG").getIntValue());
        this.l = this.lf.defineLevel("MY_LEVEL", "DEBUG + 1");
        TestLevel.assertNotNull("Null level", this.l);
        TestLevel.assertEquals("intermediate level definition", BasicLevel.DEBUG + 1, this.l.getIntValue());
    }

    public void testInterLevelDefWithOther() {
        this.lf.defineLevel("MY_LEVEL", "DEBUG + 1");
        this.l = this.lf.defineLevel("MY_LEVEL2", "MY_LEVEL + 1");
        TestLevel.assertEquals("intermediate level definition based on another intermediate level", BasicLevel.DEBUG + 2, this.l.getIntValue());
    }

    public void testInterLevelDefByMinus() {
        this.l = this.lf.defineLevel("TOTO", "DEBUG - 1");
        TestLevel.assertEquals("intermediate level definition minus operator", BasicLevel.DEBUG - 1, this.l.getIntValue());
    }

    public void testInterLevelDefWithFigures() {
        this.l = this.lf.defineLevel("TOTO2", "INFO +156 ");
        TestLevel.assertEquals("intermediate level definition, number with several figures", BasicLevel.INFO + 156, this.l.getIntValue());
    }

    public void testInterLevelWithLowerCase() {
        this.l = this.lf.defineLevel("TOTO3", "   InFO + 1 ");
        TestLevel.assertEquals("intermediate level definition, level name with lower case", BasicLevel.INFO + 1, this.l.getIntValue());
    }

    public void testInterLevelJustNb() {
        this.l = this.lf.defineLevel("TOTO4", "23455");
        TestLevel.assertEquals("intermediate level definition, level value is just a number", 23455, this.l.getIntValue());
        this.l = this.lf.defineLevel("TOTO7", 23455);
        TestLevel.assertEquals("intermediate level definition, level value is just a number", 23455, this.l.getIntValue());
    }

    public void testInterLevelJustOther() {
        this.lf.defineLevel("TOTO3", "   InFO + 1 ");
        this.l = this.lf.defineLevel("TOTO5", "TOTO3");
        TestLevel.assertEquals("intermediate level definition, level value is just another intermediate level", BasicLevel.INFO + 1, this.l.getIntValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

