/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog;

import junit.framework.Assert;
import org.objectweb.util.monolog.TestHelper;
import org.objectweb.util.monolog.TestSuite;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.TopicalLogger;

public class TestLogger
extends TestHelper {
    public static final String LOG_FILE_NAME = "test.log";
    public static final String LOG_PATTERN = "%m%n";
    TopicalLogger l = null;
    static /* synthetic */ Class class$org$objectweb$util$monolog$TestLogger;

    public TestLogger() {
    }

    public TestLogger(String s) {
        super(s);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Syntax error !");
            System.out.println("java TestLogger <logger factory class name>");
            System.exit(1);
        }
        TestHelper.run(class$org$objectweb$util$monolog$TestLogger == null ? (class$org$objectweb$util$monolog$TestLogger = TestLogger.class$("org.objectweb.util.monolog.TestLogger")) : class$org$objectweb$util$monolog$TestLogger, new String[0], new String[0], args[0]);
    }

    public static TestSuite _getTestSuite(String lfcn) {
        return TestHelper.getTestSuite(class$org$objectweb$util$monolog$TestLogger == null ? (class$org$objectweb$util$monolog$TestLogger = TestLogger.class$("org.objectweb.util.monolog.TestLogger")) : class$org$objectweb$util$monolog$TestLogger, new String[0], new String[0], lfcn);
    }

    public void testNbLogger() {
        TestLogger.assertEquals("nb initial loggers", 1, lf.getLoggers().length);
    }

    public void testRootLoggerConf() {
        this.l = (TopicalLogger)lf.getLogger("");
        TestLogger.assertNotNull("Root logger undefined", this.l);
        String[] ts = this.l.getTopic();
        TestLogger.assertNotNull("Topic list is null", ts);
        TestLogger.assertEquals("several topic", 1, ts.length);
        TestLogger.assertNotNull("Topic list is null", ts[0]);
        TestLogger.assertEquals("name 'root' not equals to ''", this.l, lf.getLogger("root"));
        TestLogger.assertTrue("several topic", ts[0].length() == 0 || "root".equals(ts[0]));
    }

    public void testGetOneLoggerByName() {
        this.l = (TopicalLogger)lf.getLogger("foo");
        TestLogger.assertEquals("same name but 2 instances", this.l, lf.getLogger("foo"));
        String[] topics = ((TopicalLogger)lf.getLogger("foo")).getTopic();
        TestLogger.assertNotNull("Topic list is null", topics);
        TestLogger.assertEquals("several topic", 1, topics.length);
        TestLogger.assertNotNull("Topic elem is null", topics[0]);
        TestLogger.assertTrue("bad name", topics[0].equals("foo"));
    }

    public void testGetAllLoggerConf() {
        int i;
        int iternumber = 20;
        for (int i2 = 0; i2 < iternumber; ++i2) {
            this.l = (TopicalLogger)lf.getLogger("foo" + i2);
        }
        TopicalLogger[] locs = (TopicalLogger[])lf.getLoggers();
        TestLogger.assertNotNull("LoggerConf list is null", locs);
        TopicalLogger[] locs2 = new TopicalLogger[iternumber];
        for (int i3 = 0; i3 < locs.length; ++i3) {
            TestLogger.assertNotNull("LoggerConf list element is null", locs[i3]);
            String[] ts = locs[i3].getTopic();
            TestLogger.assertNotNull("topic list is null", ts);
            TestLogger.assertEquals("bad Topic list size", 1, ts.length);
            TestLogger.assertNotNull("Null topic", ts[0]);
            int j = 0;
            if (ts[0].length() <= 3 || !ts[0].startsWith("foo", 0)) continue;
            try {
                j = Integer.parseInt(ts[0].substring(3, ts[0].length()));
            }
            catch (NumberFormatException e) {
                TestLogger.fail("Bad topic name: " + ts[0]);
            }
            TestLogger.assertNull("duplicate LoggerConf", locs2[j]);
            locs2[j] = locs[i3];
            TestLogger.assertEquals("bad topic", (Object)("foo" + j), (Object)ts[0]);
        }
        boolean allset = true;
        for (i = 0; i < iternumber && allset; ++i) {
            allset = locs2[i] != null;
        }
        if (!allset) {
            for (i = 0; i < iternumber; ++i) {
                if (locs2[i] == null) {
                    System.out.println("losc2[" + i + "]=null");
                    continue;
                }
                System.out.println("losc2[" + i + "]=" + locs2[i].getTopic()[0]);
            }
            TestLogger.assertTrue("Some logger has not been found", allset);
        }
    }

    public void testMultipleTopic() {
        this.l = (TopicalLogger)lf.getLogger("foo");
        TestLogger.assertEquals("same name but 2 instances", this.l, lf.getLogger("foo"));
        try {
            this.l.addTopic("bar");
            this.l.addTopic("azerty");
            this.l.addTopic("querty");
        }
        catch (Exception e) {
            TestLogger.fail("does not support multiple topic");
        }
        String[] tcs = this.l.getTopic();
        TestLogger.assertNotNull("Topic list is null", tcs);
        TestLogger.assertEquals("Wrong topic number", 4, tcs.length);
        String[] tcs2 = new String[4];
        for (int i = 0; i < tcs.length; ++i) {
            TestLogger.assertNotNull("Null topic", tcs[i]);
            if (tcs[i].equals("foo")) {
                TestLogger.assertNull("duplicate first name", tcs2[0]);
                tcs2[0] = tcs[i];
                continue;
            }
            if (tcs[i].equals("bar")) {
                TestLogger.assertNull("duplicate name", tcs2[1]);
                tcs2[1] = tcs[i];
                continue;
            }
            if (tcs[i].equals("azerty")) {
                TestLogger.assertNull("duplicate name", tcs2[2]);
                tcs2[2] = tcs[i];
                continue;
            }
            if (!tcs[i].equals("querty")) continue;
            TestLogger.assertNull("duplicate name", tcs2[3]);
            tcs2[3] = tcs[i];
        }
    }

    public void testSimpleInheritanceLevel() {
        this.l = (TopicalLogger)lf.getLogger("test.simple.inheritance.level.toto");
        this.l.setIntLevel(BasicLevel.WARN);
        this.l = (TopicalLogger)lf.getLogger("test.simple.inheritance.level.toto.titi");
        TestLogger.assertTrue("wrong isLoggable return 1", this.l.isLoggable(BasicLevel.WARN));
        TestLogger.assertTrue("wrong isLoggable return 2", !this.l.isLoggable(BasicLevel.DEBUG));
        this.l.setIntLevel(BasicLevel.DEBUG);
        TestLogger.assertTrue("wrong isLoggable return 3", this.l.isLoggable(BasicLevel.WARN));
        TestLogger.assertTrue("wrong isLoggable return 4", this.l.isLoggable(BasicLevel.DEBUG));
    }

    public void testTopicsInheritanceLevel() {
        this.l = (TopicalLogger)lf.getLogger("test.topic.inheritance.level.toto");
        this.l.setIntLevel(BasicLevel.WARN);
        this.l = (TopicalLogger)lf.getLogger("test.topic.inheritance.level.toto.titi");
        TestLogger.assertTrue("wrong isLoggable return 1", this.l.isLoggable(BasicLevel.WARN));
        TestLogger.assertTrue("wrong isLoggable return 2", !this.l.isLoggable(BasicLevel.DEBUG));
        try {
            this.l.addTopic("test.topic.inheritance.level.tutu.titi");
        }
        catch (Exception e) {
            Assert.fail("Multiple topic error: " + e.getMessage());
        }
        this.l = (TopicalLogger)lf.getLogger("test.topic.inheritance.level.tutu");
        this.l.setIntLevel(BasicLevel.DEBUG);
        TestLogger.assertTrue("wrong isLoggable return 3", this.l.isLoggable(BasicLevel.WARN));
        TestLogger.assertTrue("wrong isLoggable return 4", this.l.isLoggable(BasicLevel.DEBUG));
    }

    public void testLogInCollocatedHandler() {
        this.quietRootLogger();
        this.l = (TopicalLogger)lf.getLogger("test.simple.log");
        Handler hc = hf.createHandler("myhandler", "file");
        hc.setAttribute("output", LOG_FILE_NAME);
        hc.setAttribute("pattern", LOG_PATTERN);
        hc.setAttribute("activation", lf);
        try {
            this.l.addHandler(hc);
        }
        catch (Exception e) {
            TestLogger.fail(e.getMessage());
        }
        this.l.setIntLevel(BasicLevel.DEBUG);
        this.l.log(BasicLevel.DEBUG, (Object)"collocated Handler bar");
        String[] found = this.getFirstLines(LOG_FILE_NAME, 1);
        TestLogger.assertNotNull("TestHelper error", found);
        TestLogger.assertNotNull("TestHelper error", found[0]);
        TestLogger.assertTrue("no log in collocated Handler", found[0].endsWith("collocated Handler bar"));
    }

    public void testLogInSeveralCollocatedHandler() {
        this.quietRootLogger();
        this.l = (TopicalLogger)lf.getLogger("test.simple.log");
        Handler hc1 = hf.createHandler("myhandler", "file");
        hc1.setAttribute("output", "test.log1");
        hc1.setAttribute("pattern", LOG_PATTERN);
        hc1.setAttribute("activation", hf);
        Handler hc2 = hf.createHandler("myhandler2", "file");
        hc2.setAttribute("output", "test.log2");
        hc2.setAttribute("pattern", LOG_PATTERN);
        hc2.setAttribute("activation", hf);
        try {
            this.l.addHandler(hc1);
            this.l.addHandler(hc2);
        }
        catch (Exception e) {
            TestLogger.fail(e.getMessage());
        }
        this.l.setIntLevel(BasicLevel.DEBUG);
        this.l.log(BasicLevel.DEBUG, (Object)"several collocated Handler bar");
        String[] found = this.getFirstLines("test.log1", 1);
        TestLogger.assertNotNull("TestHelper error", found);
        TestLogger.assertNotNull("TestHelper error", found[0]);
        TestLogger.assertTrue("no log in collocated Handler", found[0].endsWith("several collocated Handler bar"));
        found = this.getFirstLines("test.log2", 1);
        TestLogger.assertNotNull("TestHelper error", found);
        TestLogger.assertNotNull("TestHelper error", found[0]);
        TestLogger.assertTrue("no log in collocated Handler", found[0].endsWith("several collocated Handler bar"));
    }

    public void testLogInInheritedHandler() {
        this.quietRootLogger();
        this.l = (TopicalLogger)lf.getLogger("test.simple.log");
        Handler hc = hf.createHandler("myhandler", "file");
        hc.setAttribute("output", LOG_FILE_NAME);
        hc.setAttribute("pattern", LOG_PATTERN);
        hc.setAttribute("activation", hf);
        try {
            this.l.addHandler(hc);
        }
        catch (Exception e) {
            TestLogger.fail(e.getMessage());
        }
        this.l.setIntLevel(BasicLevel.DEBUG);
        this.l = (TopicalLogger)lf.getLogger("test.simple.log.foo");
        this.l.log(BasicLevel.DEBUG, (Object)"inherited Handler bar");
        String[] found = this.getLastLines(LOG_FILE_NAME, 1);
        TestLogger.assertNotNull("TestHelper error", found);
        TestLogger.assertNotNull("TestHelper error", found[0]);
        TestLogger.assertTrue("no log in inherited Handler", found[0].endsWith("inherited Handler bar"));
    }

    public void testLogInSeveralInheritedHandler() {
        this.quietRootLogger();
        this.l = (TopicalLogger)lf.getLogger("test.simple.log");
        Handler hc1 = hf.createHandler("myhandler", "file");
        hc1.setAttribute("output", "test.log1");
        hc1.setAttribute("pattern", LOG_PATTERN);
        hc1.setAttribute("activation", hf);
        Handler hc2 = hf.createHandler("myhandler2", "file");
        hc2.setAttribute("output", "test.log2");
        hc2.setAttribute("pattern", LOG_PATTERN);
        hc2.setAttribute("activation", hf);
        try {
            this.l.addHandler(hc1);
            this.l = (TopicalLogger)lf.getLogger("test.simple.log.foo");
            this.l.addHandler(hc2);
        }
        catch (Exception e) {
            TestLogger.fail(e.getMessage());
        }
        this.l = (TopicalLogger)lf.getLogger("test.simple.log.foo.bar");
        this.l.setIntLevel(BasicLevel.DEBUG);
        this.l.log(BasicLevel.DEBUG, (Object)"several collocated Handler bar");
        String[] found = this.getFirstLines("test.log1", 1);
        TestLogger.assertNotNull("TestHelper error", found);
        TestLogger.assertNotNull("TestHelper error", found[0]);
        TestLogger.assertTrue("no log in collocated Handler", found[0].endsWith("several collocated Handler bar"));
        found = this.getFirstLines("test.log2", 1);
        TestLogger.assertNotNull("TestHelper error", found);
        TestLogger.assertNotNull("TestHelper error", found[0]);
        TestLogger.assertTrue("no log in collocated Handler", found[0].endsWith("several collocated Handler bar"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

