/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.wrapper.common.LevelImpl;
import org.objectweb.util.monolog.wrapper.config.BasicHandler;
import org.objectweb.util.monolog.wrapper.config.BasicLogger;

public class BasicFactory
implements MonologFactory,
Serializable {
    protected HashMap nameToLevel = null;
    protected HashMap intToNames = new HashMap();
    protected HashMap handlers = null;
    protected HashMap loggers = null;
    protected String resourceBundleName = null;

    public BasicFactory() {
        this.nameToLevel = new HashMap();
        this.handlers = new HashMap();
        this.loggers = new HashMap();
        this.defineDefaultLevels();
        this.defineRootLogger();
    }

    protected void defineDefaultLevels() {
        this.defineLevel("INHERIT", -1);
        this.defineLevel("DEBUG", 10000);
        this.defineLevel("INFO", 20000);
        this.defineLevel("WARN", 30000);
        this.defineLevel("ERROR", 40000);
        this.defineLevel("FATAL", 50000);
    }

    protected void defineRootLogger() {
        this.getLogger("").setLevel(this.getLevel("WARN"));
    }

    public Level defineLevel(String name, int value) {
        return this.defineLevel(new LevelImpl(name, value));
    }

    public Level defineLevel(String name, String value) {
        return this.defineLevel(new LevelImpl(name, value, this));
    }

    public Level getLevel(String name) {
        return (Level)this.nameToLevel.get(name);
    }

    public Level getLevel(int value) {
        Object temp = this.intToNames.get(new Integer(value));
        if (temp == null) {
            return null;
        }
        if (temp instanceof String) {
            return this.getLevel((String)temp);
        }
        if (temp instanceof ArrayList) {
            return this.getLevel((String)((ArrayList)temp).get(0));
        }
        return null;
    }

    public Level[] getLevels() {
        return this.nameToLevel.values().toArray(new Level[0]);
    }

    public void removeLevel(String name) {
        Level removed = (Level)this.nameToLevel.remove(name);
        if (removed != null) {
            Integer i = new Integer(removed.getIntValue());
            Object temp = this.intToNames.get(i);
            if (temp instanceof String) {
                this.intToNames.remove(i);
            } else if (temp instanceof ArrayList) {
                ((ArrayList)temp).remove(name);
            }
        }
    }

    private Level defineLevel(Level l) {
        String name = l.getName();
        int value = l.getIntValue();
        Level res = (Level)this.nameToLevel.get(name);
        if (res != null) {
            return res.getIntValue() == value ? res : null;
        }
        res = l;
        this.nameToLevel.put(name, res);
        Integer i = new Integer(value);
        Object temp = this.intToNames.get(i);
        if (temp != null) {
            ArrayList al;
            if (temp instanceof String) {
                if (!((Level)temp).getName().equalsIgnoreCase(name)) {
                    ArrayList<Object> al2 = new ArrayList<Object>(5);
                    al2.add(temp);
                    al2.add(name);
                    this.intToNames.put(i, al2);
                }
            } else if (temp instanceof ArrayList && !(al = (ArrayList)temp).contains(name)) {
                al.add(name);
            }
        } else {
            this.intToNames.put(i, name);
        }
        return res;
    }

    public void configure(Properties prop) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String key) {
        HashMap hashMap = this.loggers;
        synchronized (hashMap) {
            Logger res = (Logger)this.loggers.get(key);
            if (res == null) {
                res = new BasicLogger(key, this);
                this.loggers.put(key, res);
            }
            return res;
        }
    }

    public Logger getLogger(String key, String resourceBundleName) {
        return this.getLogger(key);
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String rbn) {
        this.resourceBundleName = rbn;
    }

    public Logger[] getLoggers() {
        return this.loggers.values().toArray(new Logger[0]);
    }

    public Handler createHandler(String hn, String handlertype) {
        Handler res = (Handler)this.handlers.get(hn);
        if (res != null) {
            return null;
        }
        res = new BasicHandler(hn, handlertype);
        this.handlers.put(hn, res);
        return res;
    }

    public Handler[] getHandlers() {
        return this.handlers.values().toArray(new Handler[0]);
    }

    public Handler getHandler(String hn) {
        return (Handler)this.handlers.get(hn);
    }

    public Handler removeHandler(String hn) {
        return (Handler)this.handlers.remove(hn);
    }
}

