/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog.wrapper.javaLog;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.wrapper.javaLog.LevelImpl;
import org.objectweb.util.monolog.wrapper.javaLog.MonologFormatter;

public class GenericHandler
extends java.util.logging.Handler
implements Handler {
    public java.util.logging.Handler handler = null;
    protected String type;
    protected String name;
    Map attributes = null;

    public GenericHandler(String name, String type) {
        this.type = type;
        this.name = name;
        this.attributes = new HashMap();
    }

    public GenericHandler(String name, java.util.logging.Handler h) {
        this.handler = h;
        this.name = name;
        this.attributes = new HashMap();
        if (h instanceof FileHandler) {
            this.type = "file";
        } else if (h instanceof ConsoleHandler) {
            this.type = "console";
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[0]);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Object setAttribute(String _name, Object value) {
        if (!_name.equalsIgnoreCase("activation")) {
            return this.attributes.put(_name, value);
        }
        MonologFactory mf = (MonologFactory)value;
        String output = (String)this.attributes.get("output");
        String pattern = (String)this.attributes.get("pattern");
        String level = (String)this.attributes.get("level");
        String append = (String)this.attributes.get("appendMode");
        String nbfile = (String)this.attributes.get("fileNumber");
        String fileSize = (String)this.attributes.get("maxSize");
        boolean appendVal = true;
        if (append != null && append.length() > 0) {
            appendVal = Boolean.getBoolean(append);
        }
        int levelVal = BasicLevel.DEBUG;
        if (level != null && level.length() > 0) {
            levelVal = org.objectweb.util.monolog.wrapper.common.LevelImpl.evaluate(level, mf);
        }
        if ("console".equalsIgnoreCase(this.type)) {
            this.handler = new ConsoleHandler();
        } else if ("file".equalsIgnoreCase(this.type) || "rollingfile".equalsIgnoreCase(this.type)) {
            int limit = 0;
            if (fileSize != null && fileSize.length() > 0) {
                limit = Integer.parseInt(fileSize);
            }
            int count = 1;
            if (nbfile != null && nbfile.length() > 0) {
                count = Integer.parseInt(nbfile);
            }
            try {
                this.handler = new FileHandler(output, limit, count, appendVal);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.handler.setFormatter(new MonologFormatter(pattern));
        this.handler.setLevel(LevelImpl.int2Level(levelVal));
        return null;
    }

    public void close() {
        this.handler.close();
    }

    public void flush() {
        this.handler.flush();
    }

    public String getEncoding() {
        return this.handler.getEncoding();
    }

    public Filter getFilter() {
        return this.handler.getFilter();
    }

    public Formatter getFormatter() {
        return this.handler.getFormatter();
    }

    public Level getLevel() {
        System.out.println("handler(" + this.name + ").getLevel(): " + this.handler.getLevel().getName());
        return this.handler.getLevel();
    }

    public boolean isLoggable(LogRecord record) {
        return this.handler.isLoggable(record);
    }

    public void publish(LogRecord record) {
        this.handler.publish(record);
    }

    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        this.handler.setEncoding(encoding);
    }

    protected void setException(Exception exception) {
    }

    public void setFilter(Filter newFilter) {
        this.handler.setFilter(newFilter);
    }

    public void setFormatter(Formatter newFormatter) {
        this.handler.setFormatter(newFormatter);
    }

    public void setLevel(Level newLevel) {
        this.handler.setLevel(newLevel);
    }
}

