/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.julia.Interceptor;
import org.ow2.frascati.tinfi.TinfiRuntimeException;
import org.ow2.frascati.tinfi.api.IntentHandler;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.control.content.SCAExtendedContentController;
import org.ow2.frascati.tinfi.oasis.RequestContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TinfiComponentInterceptor<T>
implements Interceptor {
    protected T impl;
    private Component owner;
    private Component fcComp;
    private SCAExtendedContentController cc;
    private Interface itf;
    protected Map<Method, List<IntentHandler>> intentHandlersMap;
    protected Method[] methods;

    @Override
    public void initFcController(InitializationContext ic) throws InstantiationException {
        Interceptor owner = (Interceptor)ic.getInterface("component");
        this.owner = (Component)owner.getFcItfDelegate();
    }

    @Override
    public void setFcItfDelegate(Object impl) {
        this.impl = impl;
    }

    public T getFcItfDelegate() {
        return this.impl;
    }

    @Override
    public abstract Object clone();

    protected void initFcClone(TinfiComponentInterceptor<T> clone) {
        clone.owner = this.owner;
        clone.itf = this.itf;
    }

    public void setFcItf(Interface itf) {
        this.itf = itf;
    }

    public Interface getFcItf() {
        return this.itf;
    }

    protected void initIntentHandlersMap(Method[] methods) {
        this.methods = methods;
        this.intentHandlersMap = new HashMap<Method, List<IntentHandler>>();
        for (Method method : methods) {
            ArrayList handlers = new ArrayList();
            this.intentHandlersMap.put(method, handlers);
        }
    }

    public void addIntentHandler(IntentHandler handler) {
        for (Map.Entry<Method, List<IntentHandler>> entry : this.intentHandlersMap.entrySet()) {
            List<IntentHandler> handlers = entry.getValue();
            handlers.add(handler);
        }
    }

    public void addIntentHandler(IntentHandler handler, Method method) throws NoSuchMethodException {
        if (!this.intentHandlersMap.containsKey(method)) {
            throw new NoSuchMethodException();
        }
        List<IntentHandler> handlers = this.intentHandlersMap.get(method);
        handlers.add(handler);
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public List<IntentHandler> listIntentHandler() {
        ArrayList<IntentHandler> all = new ArrayList<IntentHandler>();
        for (Map.Entry<Method, List<IntentHandler>> entry : this.intentHandlersMap.entrySet()) {
            List<IntentHandler> handlers = entry.getValue();
            all.addAll(handlers);
        }
        return all;
    }

    public List<IntentHandler> listIntentHandler(Method method) throws NoSuchMethodException {
        if (!this.intentHandlersMap.containsKey(method)) {
            throw new NoSuchMethodException();
        }
        List<IntentHandler> handlers = this.intentHandlersMap.get(method);
        ArrayList<IntentHandler> all = new ArrayList<IntentHandler>();
        all.addAll(handlers);
        return all;
    }

    public void removeIntentHandler(IntentHandler handler) {
        for (Map.Entry<Method, List<IntentHandler>> entry : this.intentHandlersMap.entrySet()) {
            List<IntentHandler> handlers = entry.getValue();
            handlers.remove(handler);
        }
    }

    public void removeIntentHandler(IntentHandler handler, Method method) throws NoSuchMethodException {
        if (!this.intentHandlersMap.containsKey(method)) {
            throw new NoSuchMethodException();
        }
        List<IntentHandler> handlers = this.intentHandlersMap.get(method);
        handlers.remove(handler);
    }

    protected T pushFcAndGet(String serviceName, Class<?> businessInterface, T service) {
        SCAExtendedContentController cc = this.getFcSCAContentCtrlItf();
        RequestContextImpl rc = new RequestContextImpl(serviceName, businessInterface, service);
        cc.pushRequestContext(rc);
        try {
            Object content = cc.getFcContent();
            return (T)content;
        }
        catch (ContentInstantiationException e) {
            throw new TinfiRuntimeException(e);
        }
    }

    protected void releaseFcAndPop(Object content, boolean isEndMethod) {
        SCAExtendedContentController cc = this.getFcSCAContentCtrlItf();
        cc.releaseFcContent(content, isEndMethod);
        cc.popRequestContext();
    }

    protected Component getFcComponent() {
        if (this.fcComp == null) {
            this.fcComp = this.getFcInterface("component", Component.class);
        }
        return this.fcComp;
    }

    private SCAExtendedContentController getFcSCAContentCtrlItf() {
        if (this.cc == null) {
            this.cc = this.getFcInterface("/sca-content-controller", SCAExtendedContentController.class);
        }
        return this.cc;
    }

    private <TT> TT getFcInterface(String name, Class<TT> type) throws TinfiRuntimeException {
        try {
            Object itf = this.owner.getFcInterface(name);
            return (TT)itf;
        }
        catch (NoSuchInterfaceException e) {
            throw new TinfiRuntimeException(e);
        }
    }
}

