/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.control.component;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import org.oasisopen.sca.ComponentContext;
import org.oasisopen.sca.RequestContext;
import org.oasisopen.sca.ServiceReference;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.type.InterfaceType;
import org.ow2.frascati.tinfi.TinfiComponentOutInterface;
import org.ow2.frascati.tinfi.TinfiRuntimeException;
import org.ow2.frascati.tinfi.api.control.SCAPropertyController;
import org.ow2.frascati.tinfi.control.content.SCAExtendedContentController;
import org.ow2.frascati.tinfi.oasis.ServiceReferenceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentContextMixin
implements ComponentContext {
    public Component _this_weaveableC;
    public SCAPropertyController _this_weaveableSCAPC;
    public SCAExtendedContentController _this_weaveableSCACC;

    @Override
    public String getURI() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <B> ServiceReference<B> cast(B target) throws IllegalArgumentException {
        if (!(target instanceof ServiceReference)) {
            String msg = "Not a reference: " + target;
            throw new IllegalArgumentException(msg);
        }
        ServiceReference ci = (ServiceReference)target;
        Class businessInterface = ci.getBusinessInterface();
        Object service = ci.getService();
        String signature = businessInterface.getName();
        String clname = signature + "FcSR";
        try {
            Class<?> cl = Class.forName(clname);
            Constructor<?>[] ctrs = cl.getConstructors();
            Constructor<?> ctr = ctrs[0];
            Object sr = ctr.newInstance(businessInterface, service);
            ServiceReference ret = (ServiceReference)sr;
            return ret;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public <B> B getService(Class<B> businessInterface, String referenceName) throws TinfiRuntimeException {
        ServiceReference sr;
        B fcCltItf = this.getFcCltItf(businessInterface, referenceName);
        TinfiComponentOutInterface tco = (TinfiComponentOutInterface)fcCltItf;
        ServiceReference service = sr = tco.getServiceReference();
        return (B)service;
    }

    @Override
    public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, String referenceName) {
        B service = this.getFcCltItf(businessInterface, referenceName);
        ServiceReferenceImpl<B> sr = new ServiceReferenceImpl<B>(businessInterface, service);
        return sr;
    }

    @Override
    public <B> Collection<ServiceReference<B>> getServiceReferences(Class<B> businessInterface, String referenceName) throws IllegalArgumentException {
        Collection<B> services = this.getFcCltColItf(businessInterface, referenceName);
        ArrayList<ServiceReference<B>> srs = new ArrayList<ServiceReference<B>>();
        for (B service : services) {
            ServiceReferenceImpl<B> sr = new ServiceReferenceImpl<B>(businessInterface, service);
            srs.add(sr);
        }
        return srs;
    }

    @Override
    public <B> Collection<B> getServices(Class<B> businessInterface, String referenceName) throws IllegalArgumentException {
        Collection<B> fcCltItfs = this.getFcCltColItf(businessInterface, referenceName);
        ArrayList services = new ArrayList();
        for (B fcCltItf : fcCltItfs) {
            ServiceReference sr;
            TinfiComponentOutInterface tco = (TinfiComponentOutInterface)fcCltItf;
            ServiceReference service = sr = tco.getServiceReference();
            services.add(service);
        }
        return services;
    }

    @Override
    public <B> B getProperty(Class<B> type, String propertyName) throws IllegalArgumentException {
        if (!this._this_weaveableSCAPC.containsPropertyName(propertyName)) {
            String msg = "No such property: " + propertyName;
            throw new IllegalArgumentException(msg);
        }
        Object value = this._this_weaveableSCAPC.getValue(propertyName);
        try {
            Object ret = value;
            return (B)ret;
        }
        catch (ClassCastException cce) {
            String msg = "Property " + propertyName + " is not of type " + type.getName();
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public <B> ServiceReference<B> createSelfReference(Class<B> businessInterface) {
        B service = this.getFcSrvItf(businessInterface);
        ServiceReferenceImpl<B> sr = new ServiceReferenceImpl<B>(businessInterface, service);
        return sr;
    }

    @Override
    public <B> ServiceReference<B> createSelfReference(Class<B> businessInterface, String serviceName) {
        B service = this.getFcSrvItf(businessInterface, serviceName);
        ServiceReferenceImpl<B> sr = new ServiceReferenceImpl<B>(businessInterface, service);
        return sr;
    }

    @Override
    public RequestContext getRequestContext() {
        RequestContext rc = this._this_weaveableSCACC.peekRequestContext();
        return rc;
    }

    private <B> B getFcSrvItf(Class<B> cl) throws TinfiRuntimeException {
        Object[] itfs;
        for (Object o : itfs = this._this_weaveableC.getFcInterfaces()) {
            Class<?> itfClass;
            Interface itf = (Interface)o;
            InterfaceType it = (InterfaceType)itf.getFcItfType();
            if (it.isFcClientItf() || !cl.isAssignableFrom(itfClass = itf.getClass())) continue;
            Interface ret = itf;
            return (B)ret;
        }
        String msg = "No such default service";
        throw new TinfiRuntimeException(msg);
    }

    private <B> B getFcSrvItf(Class<B> cl, String name) throws TinfiRuntimeException {
        Interface itf = null;
        try {
            itf = (Interface)this._this_weaveableC.getFcInterface(name);
        }
        catch (NoSuchInterfaceException e) {
            throw new TinfiRuntimeException(e);
        }
        InterfaceType it = (InterfaceType)itf.getFcItfType();
        if (it.isFcClientItf()) {
            String msg = "No such service: " + name;
            throw new TinfiRuntimeException(msg);
        }
        Class<?> itfClass = itf.getClass();
        if (!cl.isAssignableFrom(itfClass)) {
            String msg = "Service can not be casted to: " + cl.getName();
            throw new TinfiRuntimeException(msg);
        }
        Interface ret = itf;
        return (B)ret;
    }

    private <B> B getFcCltItf(Class<B> cl, String name) throws TinfiRuntimeException {
        Interface itf = null;
        try {
            itf = (Interface)this._this_weaveableC.getFcInterface(name);
        }
        catch (NoSuchInterfaceException e) {
            throw new TinfiRuntimeException(e);
        }
        InterfaceType it = (InterfaceType)itf.getFcItfType();
        if (!it.isFcClientItf()) {
            String msg = "No such reference: " + name;
            throw new TinfiRuntimeException(msg);
        }
        Class<?> itfClass = itf.getClass();
        if (!cl.isAssignableFrom(itfClass)) {
            String msg = "Reference can not be casted to: " + cl.getName();
            throw new TinfiRuntimeException(msg);
        }
        Interface ret = itf;
        return (B)ret;
    }

    private <B> Collection<B> getFcCltColItf(Class<B> cl, String name) throws TinfiRuntimeException {
        Object[] itfs;
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (Object o : itfs = this._this_weaveableC.getFcInterfaces()) {
            Interface itf = (Interface)o;
            String itfname = itf.getFcItfName();
            if (!itfname.startsWith(name)) continue;
            InterfaceType it = (InterfaceType)itf.getFcItfType();
            if (!it.isFcClientItf()) {
                String msg = "No such reference: " + name;
                throw new TinfiRuntimeException(msg);
            }
            Class<?> itfClass = itf.getClass();
            if (!cl.isAssignableFrom(itfClass)) {
                String msg = "Reference can not be casted to: " + cl.getName();
                throw new TinfiRuntimeException(msg);
            }
            Interface elt = itf;
            ret.add(elt);
        }
        return ret;
    }
}

