/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.control.content;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.oasisopen.sca.ComponentContext;
import org.oasisopen.sca.annotation.Callback;
import org.oasisopen.sca.annotation.ComponentName;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Context;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Scope;
import org.objectweb.fractal.fraclet.annotations.Attribute;
import org.objectweb.fractal.fraclet.annotations.Lifecycle;
import org.objectweb.fractal.fraclet.annotations.Requires;
import org.objectweb.fractal.fraclet.extensions.Controller;
import org.objectweb.fractal.fraclet.types.Step;
import org.osoa.sca.annotations.ConversationAttributes;
import org.osoa.sca.annotations.ConversationID;
import org.ow2.frascati.tinfi.annotations.Provides;
import org.ow2.frascati.tinfi.control.content.IllegalContentClassMetaData;
import org.ow2.frascati.tinfi.reflect.AnnotatedElementFilter;
import org.ow2.frascati.tinfi.reflect.CompositeOrFilter;
import org.ow2.frascati.tinfi.reflect.DuplicationInjectionPointException;
import org.ow2.frascati.tinfi.reflect.Filter;
import org.ow2.frascati.tinfi.reflect.Filters;
import org.ow2.frascati.tinfi.reflect.InjectionPoint;
import org.ow2.frascati.tinfi.reflect.InjectionPointImpl;
import org.ow2.frascati.tinfi.reflect.InjectionPointMap;
import org.ow2.frascati.tinfi.reflect.LifecycleAnnotatedElementFilter;
import org.ow2.frascati.tinfi.reflect.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentClassMetaData {
    private static Map<Class<?>, ContentClassMetaData> ccmds = new HashMap();
    public Class<?> fcContentClass;
    public boolean eagerinit;
    public String scope;
    public boolean convattr;
    public long convMaxAge = 0L;
    public long convMaxIdleTime = 0L;
    public java.lang.reflect.Constructor<?> constructorAnnotatedElement;
    public Method providesMethod;
    public Method initMethod;
    public Method destroyMethod;
    public Method startMethod;
    public Method stopMethod;
    public InjectionPoint[] controllerAnnotatedElements;
    public InjectionPoint contextAnnotatedElement;
    public InjectionPoint componentNameAnnotatedElement;
    public InjectionPoint conversationIDAnnotatedElement;
    public InjectionPointMap refs;
    public InjectionPointMap props;
    public Map<String, Method> setters;
    public InjectionPoint[] callbacks;

    public static ContentClassMetaData get(Class<?> c) throws IllegalContentClassMetaData {
        ContentClassMetaData ccmd = ccmds.get(c);
        if (ccmd == null) {
            ccmd = new ContentClassMetaData(c);
            ccmds.put(c, ccmd);
        }
        return ccmd;
    }

    private ContentClassMetaData(Class<?> fcContentClass) throws IllegalContentClassMetaData {
        Annotation annot;
        int i;
        Filter<AnnotatedElement> filter;
        java.lang.reflect.Constructor<?>[] constructors;
        java.lang.reflect.Constructor<?>[] ctors;
        this.fcContentClass = fcContentClass;
        Annotation scopeAnnot = Util.getAnnotation(fcContentClass, Scope.class.getName(), "org.osoa.sca.annotations.Scope");
        this.scope = (String)Util.getAnnotationParamValue(scopeAnnot, "value");
        this.eagerinit = Util.isAnnotationPresent(fcContentClass, EagerInit.class.getName(), "org.osoa.sca.annotations.EagerInit");
        if (this.eagerinit && (this.scope == null || !this.scope.equals("COMPOSITE"))) {
            String msg = "Class " + fcContentClass + " annotated with @EagerInit should be composite-scoped";
            throw new IllegalContentClassMetaData(msg);
        }
        Annotation convAttrAnnot = Util.getAnnotation(fcContentClass, ConversationAttributes.class.getName());
        boolean bl = this.convattr = convAttrAnnot != null;
        if (this.convattr) {
            String ma = (String)Util.getAnnotationParamValue(convAttrAnnot, "maxAge");
            this.convMaxAge = ContentClassMetaData.convDurationToMilli(ma);
            String mit = (String)Util.getAnnotationParamValue(convAttrAnnot, "maxIdleTime");
            this.convMaxIdleTime = ContentClassMetaData.convDurationToMilli(mit);
        }
        if ((ctors = Filters.filter(constructors = fcContentClass.getDeclaredConstructors(), filter = new AnnotatedElementFilter(Constructor.class.getName(), "org.osoa.sca.annotations.Constructor"))).length > 1) {
            String msg = "Only one constructor should be annotated with @Constructor";
            throw new IllegalContentClassMetaData(msg);
        }
        this.constructorAnnotatedElement = ctors.length == 1 ? ctors[0] : null;
        Method[] methods = Util.getAllMethods(fcContentClass);
        filter = new AnnotatedElementFilter(Provides.class.getName());
        Method[] provides = Filters.filter(methods, filter);
        provides = Util.removeOverriden(provides);
        this.providesMethod = this.checkUniqueAnnotatedFactoryMethod(provides, Provides.class.getName());
        filter = new CompositeOrFilter(new AnnotatedElementFilter(Init.class.getName(), "org.osoa.sca.annotations.Init"), new LifecycleAnnotatedElementFilter(Step.CREATE));
        Method[] inits = Filters.filter(methods, filter);
        inits = Util.removeOverriden(inits);
        this.initMethod = this.checkUniqueAnnotatedVoidMethod(inits, Init.class.getName(), "org.osoa.sca.annotations.Init", Lifecycle.class.getName() + "(step=Step.CREATE)");
        filter = new CompositeOrFilter(new AnnotatedElementFilter(Destroy.class.getName(), "org.osoa.sca.annotations.Destroy"), new LifecycleAnnotatedElementFilter(Step.DESTROY));
        Method[] destroys = Filters.filter(methods, filter);
        destroys = Util.removeOverriden(destroys);
        this.destroyMethod = this.checkUniqueAnnotatedVoidMethod(destroys, Destroy.class.getName(), "org.osoa.sca.annotations.Destroy", Lifecycle.class.getName() + "(step=Step.DESTROY)");
        filter = new LifecycleAnnotatedElementFilter(Step.START);
        Method[] starts = Filters.filter(methods, filter);
        starts = Util.removeOverriden(starts);
        this.startMethod = this.checkUniqueAnnotatedVoidMethod(starts, Lifecycle.class.getName() + "(step=Step.START)");
        filter = new LifecycleAnnotatedElementFilter(Step.STOP);
        Method[] stops = Filters.filter(methods, filter);
        stops = Util.removeOverriden(stops);
        this.stopMethod = this.checkUniqueAnnotatedVoidMethod(stops, Lifecycle.class.getName() + "(step=Step.STOP)");
        AccessibleObject[] aos = Util.getAllAnnotatedSettersAndFields(fcContentClass, Controller.class.getName());
        this.controllerAnnotatedElements = new InjectionPoint[aos.length];
        for (i = 0; i < aos.length; ++i) {
            annot = Util.getAnnotation(aos[i], Controller.class.getName());
            this.controllerAnnotatedElements[i] = InjectionPointImpl.getInjectionPoint(aos[i], annot);
        }
        this.contextAnnotatedElement = this.getSingletonAnnotatedFieldOrSetter(ComponentContext.class, Context.class.getName(), "org.osoa.sca.annotations.Context");
        this.componentNameAnnotatedElement = this.getSingletonAnnotatedFieldOrSetter(String.class, ComponentName.class.getName(), "org.osoa.sca.annotations.ComponentName");
        this.conversationIDAnnotatedElement = this.getSingletonAnnotatedFieldOrSetter(Object.class, ConversationID.class.getName());
        this.refs = new InjectionPointMap(fcContentClass, Reference.class.getName(), "org.osoa.sca.annotations.Reference", Requires.class.getName());
        try {
            this.refs.putAll();
        }
        catch (DuplicationInjectionPointException dipe) {
            throw new IllegalContentClassMetaData(dipe);
        }
        this.props = new InjectionPointMap(fcContentClass, Property.class.getName(), "org.osoa.sca.annotations.Property", Attribute.class.getName());
        try {
            this.props.putAll();
        }
        catch (DuplicationInjectionPointException dipe) {
            throw new IllegalContentClassMetaData(dipe);
        }
        this.setters = Util.getAllUnAnnotatedSetterMethods(fcContentClass);
        aos = Util.getAllAnnotatedSettersAndFields(fcContentClass, Callback.class.getName(), "org.osoa.sca.annotations.Callback");
        this.callbacks = new InjectionPoint[aos.length];
        for (i = 0; i < aos.length; ++i) {
            annot = Util.getAnnotation(aos[i], Callback.class.getName(), "org.osoa.sca.annotations.Callback");
            this.callbacks[i] = InjectionPointImpl.getInjectionPoint(aos[i], annot);
        }
    }

    private InjectionPoint getSingletonAnnotatedFieldOrSetter(Class<?> type, String ... annotClassNames) throws IllegalContentClassMetaData {
        AccessibleObject[] aos = Util.getAllAnnotatedSettersAndFields(this.fcContentClass, annotClassNames);
        if ((aos = Util.removeOverriden(aos)).length == 0) {
            return null;
        }
        if (aos.length > 1) {
            String str = Arrays.deepToString(annotClassNames);
            String msg = "More than one element annotated with @" + str + " in " + this.fcContentClass.getName();
            throw new IllegalContentClassMetaData(msg);
        }
        AccessibleObject ao = aos[0];
        Annotation[] annots = ao.getAnnotations();
        for (String annotClassName : annotClassNames) {
            for (Annotation annot : annots) {
                InjectionPoint ip;
                Class<?> iptype;
                String name = annot.annotationType().getName();
                if (!name.equals(annotClassName) || !type.isAssignableFrom(iptype = (ip = InjectionPointImpl.getInjectionPoint(ao, annot)).getType())) continue;
                return ip;
            }
        }
        String msg = ao.toString() + " should be injectable with " + type.getName();
        throw new IllegalContentClassMetaData(msg);
    }

    private Method checkUniqueAnnotatedVoidMethod(Method[] methods, String ... names) throws IllegalContentClassMetaData {
        Method method = this.checkUnique(methods, names);
        if (method == null) {
            return null;
        }
        if (!method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) {
            String str = Arrays.deepToString(names);
            String msg = "The signature of the @" + str + " annotated method (" + method.getName() + ") should be ():void";
            throw new IllegalContentClassMetaData(msg);
        }
        return method;
    }

    private Method checkUniqueAnnotatedFactoryMethod(Method[] methods, String ... names) throws IllegalContentClassMetaData {
        Method method = this.checkUnique(methods, names);
        if (method == null) {
            return null;
        }
        Class<?> rtype = method.getReturnType();
        if (!this.fcContentClass.isAssignableFrom(rtype) || method.getParameterTypes().length != 0) {
            String str = Arrays.deepToString(names);
            String msg = "The signature of the @" + str + " annotated method (" + method.getName() + ") should be ():" + this.fcContentClass.getName();
            throw new IllegalContentClassMetaData(msg);
        }
        return method;
    }

    private Method checkUnique(Method[] methods, String ... names) throws IllegalContentClassMetaData {
        if (methods.length == 0) {
            return null;
        }
        if (methods.length > 1) {
            String str = Arrays.deepToString(names);
            String msg = "More than one method annotated with @" + str + " in " + this.fcContentClass.getName();
            throw new IllegalContentClassMetaData(msg);
        }
        Method method = methods[0];
        return method;
    }

    private static long convDurationToMilli(String duration) throws IllegalContentClassMetaData {
        int space = duration.indexOf(32);
        if (space == -1) {
            String msg = "No space in duration string: " + duration;
            throw new IllegalContentClassMetaData(msg);
        }
        String numberStr = duration.substring(0, space);
        int number = Integer.parseInt(numberStr);
        if (number < 0) {
            String msg = "Negative duration: " + duration;
            throw new IllegalContentClassMetaData(msg);
        }
        if (space + 1 == duration.length()) {
            String msg = "No time unit in: " + duration;
            throw new IllegalContentClassMetaData(msg);
        }
        String unit = duration.substring(space + 1);
        long l = number;
        if (unit.equals("seconds")) {
            l *= 1000L;
        } else if (unit.equals("minutes")) {
            l *= 60000L;
        } else if (unit.equals("hours")) {
            l *= 3600000L;
        } else if (unit.equals("days")) {
            l *= 86400000L;
        } else if (unit.equals("years")) {
            l *= 1471228928L;
        } else {
            String msg = "Unsupported time unit in: " + duration;
            throw new IllegalContentClassMetaData(msg);
        }
        return l;
    }
}

