/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.control.content.scope;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.oasisopen.sca.ComponentContext;
import org.oasisopen.sca.RequestContext;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.Property;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.fraclet.types.Contingency;
import org.objectweb.fractal.julia.ComponentInterface;
import org.objectweb.fractal.julia.Interceptor;
import org.ow2.frascati.tinfi.CallbackManager;
import org.ow2.frascati.tinfi.TinfiComponentOutInterface;
import org.ow2.frascati.tinfi.TinfiRuntimeException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.api.control.SCAPropertyController;
import org.ow2.frascati.tinfi.control.content.ContentClassMetaData;
import org.ow2.frascati.tinfi.control.content.scope.ScopeManager;
import org.ow2.frascati.tinfi.reflect.InjectionPoint;
import org.ow2.frascati.tinfi.reflect.InjectionPointFieldImpl;
import org.ow2.frascati.tinfi.reflect.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScopeManager
implements ScopeManager {
    protected ContentClassMetaData ccmd;
    protected Component comp;
    private boolean instantiatedOnce = false;
    protected ThreadLocal<Stack<RequestContext>> tl = new ThreadLocal();

    public AbstractScopeManager(Component comp, ContentClassMetaData ccmd) {
        this.comp = comp;
        this.ccmd = ccmd;
    }

    @Override
    public void setFcContent(Object content) throws ContentInstantiationException {
        String msg = "setFcContent(Object) can only be invoked for composite-scoped components";
        throw new ContentInstantiationException(msg);
    }

    protected Object createAndInitializeFcInstance() throws ContentInstantiationException {
        ArrayList<String> initnames = new ArrayList<String>();
        try {
            Object content = this.createFcInstance(initnames);
            this.initializeFcInstance(content, initnames);
            return content;
        }
        catch (Exception e) {
            if (e instanceof ContentInstantiationException) {
                throw (ContentInstantiationException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ContentInstantiationException(e);
        }
    }

    private Object createFcInstance(List<String> initnames) throws java.lang.InstantiationException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchInterfaceException {
        Object content = null;
        if (this.ccmd.constructorAnnotatedElement != null) {
            Annotation[][] paramsAnnots;
            ComponentType ct = (ComponentType)this.comp.getFcType();
            Constructor<?> ctor = this.ccmd.constructorAnnotatedElement;
            Annotation[][] arr$ = paramsAnnots = ctor.getParameterAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Annotation[] paramAnnots;
                for (Annotation pannot : paramAnnots = arr$[i$]) {
                    if (!(pannot instanceof Property)) continue;
                    Property propannot = (Property)pannot;
                    String name = propannot.name();
                    initnames.add(name);
                }
            }
            Object[] values = new Object[initnames.size()];
            for (int i = 0; i < initnames.size(); ++i) {
                String name = initnames.get(i);
                try {
                    Object sr;
                    InterfaceType it = ct.getFcInterfaceType(name);
                    values[i] = sr = this.getServiceReference(it);
                    continue;
                }
                catch (NoSuchInterfaceException nsie) {
                    SCAPropertyController scapc = (SCAPropertyController)this.comp.getFcInterface("sca-property-controller");
                    if (!scapc.containsPropertyName(name)) {
                        String msg = "Identifier " + name + " in @Constructor attributes for class " + this.ccmd.fcContentClass + " is neither a reference name, nor a property name";
                        throw new InstantiationException(msg);
                    }
                    values[i] = scapc.getValue(name);
                }
            }
            ctor = this.ccmd.constructorAnnotatedElement;
            content = ctor.newInstance(values);
        } else if (this.ccmd.providesMethod != null) {
            Object obj = this.ccmd.fcContentClass.newInstance();
            content = this.ccmd.providesMethod.invoke(obj, new Object[0]);
        } else {
            content = this.ccmd.fcContentClass.newInstance();
        }
        return content;
    }

    protected void initializeFcInstance(Object content, List<String> initnames) throws ContentInstantiationException, IllegalAccessException, InvocationTargetException, NoSuchInterfaceException {
        CallbackManager cm;
        InjectionPoint ip;
        String[] propnames;
        InterfaceType[] its;
        for (InjectionPoint ip2 : this.ccmd.controllerAnnotatedElements) {
            Annotation annot = ip2.getAnnotation();
            String name = (String)Util.getAnnotationParamValue(annot, "name");
            Object ctrlItf = this.comp.getFcInterface(name);
            Class<?> ctrlItfCl = ctrlItf.getClass();
            Class<?> type = ip2.getType();
            if (!type.isAssignableFrom(ctrlItfCl)) {
                String msg = "The type " + ctrlItfCl.getName() + " of the " + name + " control interface can not be injected into " + type;
                throw new ContentInstantiationException(msg);
            }
            ip2.set(content, ctrlItf);
        }
        if (this.ccmd.contextAnnotatedElement != null) {
            ComponentContext compCtx = (ComponentContext)this.comp.getFcInterface("sca-component-controller");
            this.ccmd.contextAnnotatedElement.set(content, compCtx);
        }
        if (this.ccmd.componentNameAnnotatedElement != null) {
            NameController nc = (NameController)this.comp.getFcInterface("name-controller");
            String name = nc.getFcName();
            this.ccmd.componentNameAnnotatedElement.set(content, name);
        }
        ComponentType ct = (ComponentType)this.comp.getFcType();
        for (InterfaceType it : its = ct.getFcInterfaceTypes()) {
            String name = it.getFcItfName();
            if (name.equals("component") || name.endsWith("-controller") || !it.isFcClientItf()) continue;
            Object sr = this.getServiceReference(it);
            if (this.ccmd.refs.containsKey(name)) {
                InjectionPoint ip3 = (InjectionPoint)this.ccmd.refs.get(name);
                if (sr instanceof Map) {
                    Annotation annot = ip3.getAnnotation();
                    String annotClName = annot.annotationType().getName();
                    Collection l = null;
                    if (annotClName.equals("org.objectweb.fractal.fraclet.annotations.Requires")) {
                        ip3.set(content, sr);
                        l = ((Map)sr).values();
                    } else {
                        Collection col = ((Map)sr).values();
                        l = new ArrayList(col);
                        ip3.set(content, l);
                    }
                    for (Object o : l) {
                        this.checkMandatoryReferenceHasBeenSet(o, ip3, name);
                    }
                    continue;
                }
                ip3.set(content, sr);
                this.checkMandatoryReferenceHasBeenSet(sr, ip3, name);
                continue;
            }
            if (this.ccmd.setters.containsKey(name)) {
                Method setter = this.ccmd.setters.get(name);
                setter.invoke(content, sr);
                continue;
            }
            if (initnames.contains(name)) continue;
            String msg = "Reference or property " + name + " can not be injected on " + this.ccmd.fcContentClass;
            throw new ContentInstantiationException(msg);
        }
        SCAPropertyController scapc = (SCAPropertyController)this.comp.getFcInterface("sca-property-controller");
        for (String name : propnames = scapc.getPropertyNames()) {
            boolean hasBeenSet = scapc.hasBeenSet(name);
            if (!hasBeenSet) continue;
            Object value = scapc.getValue(name);
            if (this.ccmd.props.containsKey(name)) {
                InjectionPoint ip4 = (InjectionPoint)this.ccmd.props.get(name);
                ip4.set(content, value);
                continue;
            }
            if (this.ccmd.setters.containsKey(name)) {
                Method setter = this.ccmd.setters.get(name);
                setter.invoke(content, value);
                continue;
            }
            if (initnames.contains(name)) continue;
            String msg = "Reference or property " + name + " can not be injected on " + this.ccmd.fcContentClass;
            throw new ContentInstantiationException(msg);
        }
        Set names = this.ccmd.props.keySet();
        if (!this.instantiatedOnce) {
            for (String name : names) {
                if (!this.ccmd.props.containsKey(name) || !((ip = (InjectionPoint)this.ccmd.props.get(name)) instanceof InjectionPointFieldImpl)) continue;
                Object value = ip.get(content);
                Class<?> type = ip.getType();
                scapc.setValue(name, value);
                scapc.setType(name, type);
            }
            this.instantiatedOnce = true;
        }
        for (String name : names) {
            Annotation annot;
            boolean isRequired;
            if (scapc.hasBeenSet(name) || !(isRequired = ((Boolean)Util.getAnnotationParamValue(annot = (ip = (InjectionPoint)this.ccmd.props.get(name)).getAnnotation(), "required")).booleanValue())) continue;
            NameController nc = (NameController)this.comp.getFcInterface("name-controller");
            String msg = "Mandatory property(s) " + name + " in component " + nc.getFcName() + " should have been set";
            throw new ContentInstantiationException(msg);
        }
        if (this.ccmd.callbacks.length > 0 && !(cm = CallbackManager.get()).isEmpty()) {
            ServiceReference<?> cr = cm.peek();
            Class<?> businessItf = cr.getBusinessInterface();
            for (InjectionPoint ip5 : this.ccmd.callbacks) {
                Class<?> type = ip5.getType();
                if (!type.isAssignableFrom(businessItf)) continue;
                ip5.set(content, cr);
                break;
            }
        }
        if (this.ccmd.initMethod != null) {
            Method init = this.ccmd.initMethod;
            init.invoke(content, new Object[0]);
        }
    }

    private void checkMandatoryReferenceHasBeenSet(Object sr, InjectionPoint ip, String name) throws ContentInstantiationException, NoSuchInterfaceException {
        Annotation annot = ip.getAnnotation();
        boolean isRequired = false;
        try {
            isRequired = (Boolean)Util.getAnnotationParamValue(annot, "required");
        }
        catch (NullPointerException npe) {
            Contingency contingency = (Contingency)((Object)Util.getAnnotationParamValue(annot, "contingency"));
            if (contingency == null) {
                String msg = "required or contingency parameter expected on annotation " + annot;
                throw new TinfiRuntimeException(msg);
            }
            isRequired = contingency.equals((Object)Contingency.MANDATORY);
        }
        if (isRequired && sr == null) {
            NameController nc = (NameController)this.comp.getFcInterface("name-controller");
            String msg = "Mandatory reference " + name + " in component " + nc.getFcName() + " should have been set";
            throw new ContentInstantiationException(msg);
        }
    }

    private Object getServiceReference(InterfaceType it) throws NoSuchInterfaceException {
        String name = it.getFcItfName();
        if (it.isFcCollectionItf()) {
            Object[] itfs = this.comp.getFcInterfaces();
            HashMap<String, Object> srs = new HashMap<String, Object>();
            for (Object o : itfs) {
                Interface itf = (Interface)o;
                String itfname = itf.getFcItfName();
                if (!itfname.startsWith(name)) continue;
                Object sr = this.getServiceReference(itf);
                srs.put(itfname, sr);
            }
            return srs;
        }
        Object itf = this.comp.getFcInterface(name);
        Object sr = this.getServiceReference(itf);
        return sr;
    }

    private Object getServiceReference(Object clientItf) {
        ComponentInterface itf = (ComponentInterface)clientItf;
        Interceptor outInterceptor = (Interceptor)itf.getFcItfImpl();
        Object delegate = outInterceptor.getFcItfDelegate();
        if (delegate == null) {
            return null;
        }
        TinfiComponentOutInterface tcoi = (TinfiComponentOutInterface)clientItf;
        ServiceReference sr = tcoi.getServiceReference();
        return sr;
    }

    protected void destroyFcInstance(Object content) {
        if (this.ccmd.destroyMethod != null) {
            Method destroy = this.ccmd.destroyMethod;
            try {
                destroy.invoke(content, new Object[0]);
            }
            catch (Exception e) {
                throw new TinfiRuntimeException(e);
            }
        }
    }

    @Override
    public void pushRequestContext(RequestContext rc) {
        Stack<RequestContext> stack = this.tl.get();
        if (stack == null) {
            stack = new Stack();
            this.tl.set(stack);
        }
        stack.push(rc);
    }

    @Override
    public RequestContext popRequestContext() {
        Stack<RequestContext> stack = this.tl.get();
        RequestContext rc = stack.pop();
        return rc;
    }

    @Override
    public RequestContext peekRequestContext() {
        Stack<RequestContext> stack = this.tl.get();
        RequestContext rc = stack.peek();
        return rc;
    }
}

