/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.control.intent;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.ComponentInterface;
import org.objectweb.fractal.julia.Controller;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.juliac.runtime.ClassLoaderItf;
import org.objectweb.fractal.juliac.runtime.Juliac;
import org.ow2.frascati.tinfi.TinfiComponentInterceptor;
import org.ow2.frascati.tinfi.TinfiRuntimeException;
import org.ow2.frascati.tinfi.api.IntentHandler;
import org.ow2.frascati.tinfi.api.control.SCAIntentController;
import org.ow2.frascati.tinfi.reflect.AnnotatedElementFilter;
import org.ow2.frascati.tinfi.reflect.Filters;
import org.ow2.frascati.tinfi.reflect.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SCAIntentControllerMixin
implements Controller,
SCAIntentController {
    private Class<?> cl;
    private Map<Method, TinfiComponentInterceptor<?>> mtcis;
    private Map<Method, Method> mms;
    public Component _this_weaveableOptC;

    private SCAIntentControllerMixin() {
    }

    @Override
    public void initFcController(InitializationContext ic) throws InstantiationException {
        this.cl = (Class)ic.content;
        this._super_initFcController(ic);
    }

    @Override
    public <T extends Annotation> void addFcIntentHandler(IntentHandler handler, Class<T> annotcl, String value) {
        List<Method> methods = this.getFcMatchingMethods(annotcl, value);
        for (Method method : methods) {
            TinfiComponentInterceptor<?> tci = this.getFcInterceptor(method);
            Method m = this.getFcItfMethod(method);
            try {
                tci.addIntentHandler(handler, m);
            }
            catch (NoSuchMethodException e) {
                throw new TinfiRuntimeException(e);
            }
        }
    }

    private <T extends Annotation> List<Method> getFcMatchingMethods(Class<T> annotcl, String value) {
        Method[] ms;
        ArrayList<Method> ret = new ArrayList<Method>();
        Method[] methods = Util.getAllMethods(this.cl);
        AnnotatedElementFilter filter = new AnnotatedElementFilter(annotcl.getName());
        for (Method method : ms = Filters.filter(methods, filter)) {
            T annot = method.getAnnotation(annotcl);
            if (annot == null) continue;
            Class<?> cl = annot.getClass();
            try {
                Method mvalue = cl.getMethod("value", new Class[0]);
                String[] values = null;
                try {
                    values = (String[])mvalue.invoke(annot, new Object[0]);
                }
                catch (Exception e) {
                    throw new TinfiRuntimeException(e);
                }
                for (String v : values) {
                    if (!v.equals(value)) continue;
                    ret.add(method);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return ret;
    }

    private TinfiComponentInterceptor<?> getFcInterceptor(Method method) {
        if (this.mtcis == null) {
            this.initFcMaps();
        }
        if (!this.mtcis.containsKey(method)) {
            String msg = "No interceptor for component method: " + method.toString();
            throw new TinfiRuntimeException(msg);
        }
        TinfiComponentInterceptor<?> tci = this.mtcis.get(method);
        return tci;
    }

    private Method getFcItfMethod(Method method) {
        if (this.mms == null) {
            this.initFcMaps();
        }
        if (!this.mms.containsKey(method)) {
            String msg = "No interface method for component method: " + method.toString();
            throw new TinfiRuntimeException(msg);
        }
        Method m = this.mms.get(method);
        return m;
    }

    private void initFcMaps() {
        Object[] itfs;
        this.mtcis = new HashMap();
        this.mms = new HashMap<Method, Method>();
        Method[] methods = this.cl.getMethods();
        for (Object o : itfs = this._this_weaveableOptC.getFcInterfaces()) {
            Interface itf = (Interface)o;
            String name = itf.getFcItfName();
            if (name.endsWith("-controller") || name.equals("component")) continue;
            Object i = ((ComponentInterface)itf).getFcItfImpl();
            TinfiComponentInterceptor tci = (TinfiComponentInterceptor)i;
            InterfaceType it = (InterfaceType)itf.getFcItfType();
            String signature = it.getFcItfSignature();
            Class<?> business = SCAIntentControllerMixin.loadFcClass(signature);
            Method[] ms = business.getMethods();
            for (Method method : methods) {
                for (Method m : ms) {
                    if (!SCAIntentControllerMixin.areSame(m, method)) continue;
                    this.mtcis.put(method, tci);
                    this.mms.put(method, m);
                }
            }
        }
    }

    private static Class<?> loadFcClass(String name) {
        Component boot = new Juliac().newFcInstance();
        ClassLoaderItf loader = null;
        try {
            loader = (ClassLoaderItf)boot.getFcInterface("classloader");
        }
        catch (NoSuchInterfaceException nsie) {
            throw new RuntimeException(nsie);
        }
        try {
            Class cl = loader.loadClass(name);
            return cl;
        }
        catch (ClassNotFoundException cnfe) {
            throw new TinfiRuntimeException(cnfe);
        }
    }

    private static boolean areSame(Method m1, Method m2) {
        Class<?>[] ptypes2;
        String name2;
        String name1 = m1.getName();
        if (!name1.equals(name2 = m2.getName())) {
            return false;
        }
        Class<?>[] ptypes1 = m1.getParameterTypes();
        if (ptypes1.length != (ptypes2 = m2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < ptypes1.length; ++i) {
            Class<?> ptype1 = ptypes1[i];
            Class<?> ptype2 = ptypes2[i];
            if (ptype1.equals(ptype2)) continue;
            return false;
        }
        return true;
    }

    public abstract void _super_initFcController(InitializationContext var1) throws InstantiationException;
}

