/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.control.property;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.ow2.frascati.tinfi.api.control.SCAPropertyController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SCAPropertyControllerMixin
implements SCAPropertyController {
    private Map<String, Object> values = new HashMap<String, Object>();
    private Map<String, Class<?>> types = new HashMap();

    @Override
    public void setType(String name, Class<?> type) {
        this.types.put(name, type);
    }

    @Override
    public void setValue(String name, Object value) throws IllegalArgumentException {
        Class<?> type;
        boolean isInstance;
        if (this.types.containsKey(name) && !(isInstance = (type = this.types.get(name)).isInstance(value))) {
            String msg = "The type of the specified value " + value + " is not assignable to the type " + type.getName() + " previously defined with setType().";
            throw new IllegalArgumentException(msg);
        }
        this.values.put(name, value);
        this._super_setValue(name, value);
    }

    @Override
    public Class<?> getType(String name) {
        if (this.types.containsKey(name)) {
            Class<?> type = this.types.get(name);
            return type;
        }
        Class<?> type = this._super_getType(name);
        return type;
    }

    @Override
    public Object getValue(String name) {
        Object value = this.values.get(name);
        return value;
    }

    @Override
    public boolean containsPropertyName(String name) {
        boolean b = this.values.containsKey(name);
        if (!b) {
            b = this._super_containsPropertyName(name);
        }
        return b;
    }

    @Override
    public String[] getPropertyNames() {
        HashSet<String> keys = new HashSet<String>(this.values.keySet());
        String[] declared = this._super_getPropertyNames();
        keys.addAll(Arrays.asList(declared));
        String[] names = keys.toArray(new String[keys.size()]);
        return names;
    }

    @Override
    public boolean hasBeenSet(String name) {
        boolean b = this.values.containsKey(name);
        return b;
    }

    protected abstract void _super_setValue(String var1, Object var2) throws IllegalArgumentException;

    protected abstract Class<?> _super_getType(String var1);

    protected abstract String[] _super_getPropertyNames();

    protected abstract boolean _super_containsPropertyName(String var1);
}

