/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.oasis;

import javax.security.auth.Subject;
import org.oasisopen.sca.RequestContext;
import org.oasisopen.sca.ServiceReference;
import org.ow2.frascati.tinfi.CallbackManager;
import org.ow2.frascati.tinfi.SecuritySubjectManager;
import org.ow2.frascati.tinfi.oasis.ServiceReferenceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestContextImpl<B>
implements RequestContext {
    private String serviceName;
    private Class<B> businessInterface;
    private B service;

    public RequestContextImpl(String serviceName, Class<B> businessInterface, B service) {
        this.serviceName = serviceName;
        this.businessInterface = businessInterface;
        this.service = service;
    }

    @Override
    public Subject getSecuritySubject() {
        SecuritySubjectManager ssm = SecuritySubjectManager.get();
        Subject subject = ssm.getSecuritySubject();
        return subject;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public <CB> ServiceReference<CB> getServiceReference() {
        return new ServiceReferenceImpl<B>(this.businessInterface, this.service);
    }

    @Override
    public <CB> CB getCallback() {
        CallbackManager cm = CallbackManager.get();
        ServiceReference<?> cr = cm.peek();
        Object service = cr.getService();
        return (CB)service;
    }

    @Override
    public <CB> ServiceReference<CB> getCallbackReference() {
        CallbackManager cm = CallbackManager.get();
        ServiceReference<?> cr = cm.peek();
        return cr;
    }
}

