/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.oasis;

import org.oasisopen.sca.ServiceReference;
import org.osoa.sca.ConversationEndedException;
import org.osoa.sca.NoRegisteredCallbackException;
import org.osoa.sca.annotations.Conversational;
import org.ow2.frascati.tinfi.TinfiComponentOutInterface;
import org.ow2.frascati.tinfi.osoa.ConversationImpl;
import org.ow2.frascati.tinfi.osoa.ConversationManager;
import org.ow2.frascati.tinfi.osoa.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceReferenceImpl<B>
implements ServiceReference<B> {
    private static final long serialVersionUID = 9040793165153075363L;
    private Class<B> businessInterface;
    protected B service;
    private Object callback;
    private Conversational conversationAnnotation;
    protected Object callbackID;
    private ThreadLocal<ConversationImpl> conversation;

    public ServiceReferenceImpl(Class<B> businessInterface, B service) {
        this.businessInterface = businessInterface;
        this.service = service;
        this.conversationAnnotation = businessInterface.getAnnotation(Conversational.class);
    }

    public Object _getCallback() {
        if (this.callback == null) {
            throw new NoRegisteredCallbackException();
        }
        return this.callback;
    }

    public Object _getCallbackID() {
        return this.callbackID;
    }

    public void _setCallback(Object callback) {
        this.callback = callback;
    }

    public void _setCallbackID(Object callbackID) {
        this.callbackID = callbackID;
    }

    public boolean _isConversational() {
        return this.conversationAnnotation != null;
    }

    public ConversationImpl _getConversation() throws IllegalStateException {
        ConversationImpl conv;
        if (!this._isConversational()) {
            String msg = "This reference is not conversational";
            throw new IllegalStateException(msg);
        }
        if (this.conversation == null) {
            this.conversation = new ThreadLocal();
        }
        if ((conv = this.conversation.get()) == null) {
            conv = new ConversationImpl();
            this.conversation.set(conv);
        }
        return conv;
    }

    public Object _getConversationID() {
        if (!this._isConversational()) {
            String msg = "This reference is not conversational";
            throw new IllegalStateException(msg);
        }
        return this._getConversation().getConversationID();
    }

    public void _setConversationID(Object conversationId) throws IllegalStateException {
        if (!this._isConversational()) {
            String msg = "This reference is not conversational";
            throw new IllegalStateException(msg);
        }
        if (this._getConversation().getConversationID() != null) {
            String msg = "A conversion has already been associated with this service reference";
            throw new IllegalStateException(msg);
        }
        if (conversationId == null) {
            conversationId = Math.random();
        }
        this._getConversation().setConversationID(conversationId);
    }

    @Override
    public Class<B> getBusinessInterface() {
        return this.businessInterface;
    }

    @Override
    public B getService() {
        ServiceReference sr;
        TinfiComponentOutInterface tco = (TinfiComponentOutInterface)this.service;
        ServiceReference service = sr = tco.getServiceReference();
        return (B)service;
    }

    public B _getDelegate() {
        return this.service;
    }

    protected void _pushConversation(ConversationImpl conv) throws ConversationEndedException {
        ConversationState convstate = conv.getFcState();
        if (convstate.equals((Object)ConversationState.STOPPED)) {
            throw new ConversationEndedException();
        }
        if (convstate.equals((Object)ConversationState.CREATED)) {
            String conversationId = Thread.currentThread().toString() + ':' + this.getService().toString();
            conv.setConversationID(conversationId);
            conv.start();
        }
        ConversationManager cm = ConversationManager.get();
        cm.push(conv);
    }

    protected ConversationImpl _popConversation() {
        ConversationManager cm = ConversationManager.get();
        ConversationImpl conv = cm.pop();
        return conv;
    }

    protected ConversationImpl _peekConversation() {
        ConversationManager cm = ConversationManager.get();
        ConversationImpl conv = cm.peek();
        return conv;
    }
}

