/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.opt.oo;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import org.oasisopen.sca.annotation.Callback;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.type.BasicInterfaceType;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.api.SpoonSupportItf;
import org.objectweb.fractal.juliac.conf.JuliacConfig;
import org.objectweb.fractal.juliac.conf.JulietLoader;
import org.objectweb.fractal.juliac.desc.ControllerDesc;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.desc.SimpleMembraneDesc;
import org.objectweb.fractal.juliac.opt.FCSourceCodeGenerator;
import org.objectweb.fractal.juliac.proxy.AbstractProxyClassGenerator;
import org.objectweb.fractal.juliac.proxy.InterfaceImplementationClassGenerator;
import org.objectweb.fractal.juliac.proxy.ProxyClassGeneratorItf;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedClassHelper;
import org.ow2.frascati.tinfi.control.content.IllegalContentClassMetaData;
import org.ow2.frascati.tinfi.membrane.SCAComposite;
import org.ow2.frascati.tinfi.membrane.SCACompositeWithContent;
import org.ow2.frascati.tinfi.membrane.SCAContainer;
import org.ow2.frascati.tinfi.membrane.SCAPrimitive;
import org.ow2.frascati.tinfi.opt.oo.CallBackInterfaceClassGenerator;
import org.ow2.frascati.tinfi.opt.oo.ClientInterfaceClassGenerator;
import org.ow2.frascati.tinfi.opt.oo.InitializerOOCtrlClassGenerator;
import org.ow2.frascati.tinfi.opt.oo.MembraneInitializerOOCtrlClassGenerator;
import org.ow2.frascati.tinfi.opt.oo.SCAContentControllerClassGenerator;
import org.ow2.frascati.tinfi.opt.oo.ServerInterfaceClassGenerator;
import org.ow2.frascati.tinfi.opt.oo.ServiceReferenceClassGenerator;
import org.ow2.frascati.tinfi.reflect.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FCOOCtrlSourceCodeGenerator
extends FCSourceCodeGenerator<List<ControllerDesc>> {
    @Override
    public void init(Juliac jc) throws IOException {
        super.init(jc);
        JuliacConfig jconf = jc.getJuliacConfig();
        this.mloader = jconf.getJulietLoader();
    }

    @Override
    public void postInit() throws IOException {
        JuliacConfig jconf = this.jc.getJuliacConfig();
        JulietLoader julietLoader = jconf.getJulietLoader();
        julietLoader.put("scaPrimitive", SCAPrimitive.class);
        julietLoader.put("scaComposite", SCAComposite.class);
        julietLoader.put("scaContainer", SCAContainer.class);
        julietLoader.put("scaCompositeWithContent", SCACompositeWithContent.class);
    }

    public InitializerOOCtrlClassGenerator getInitializerClassGenerator() {
        return new InitializerOOCtrlClassGenerator();
    }

    @Override
    public ProxyClassGeneratorItf getInterfaceClassGenerator(InterfaceType it, MembraneDesc<?> membraneDesc) {
        InterfaceImplementationClassGenerator pcg = null;
        String itname = it.getFcItfName();
        pcg = itname.endsWith("-controller") || itname.equals("component") ? new InterfaceImplementationClassGenerator(it, membraneDesc, false, this.jc) : (it.isFcClientItf() ? new ClientInterfaceClassGenerator(it, membraneDesc, false, this.jc) : new ServerInterfaceClassGenerator(it, membraneDesc, false, this.jc));
        return pcg;
    }

    @Override
    protected void generateInterfaceImpl(InterfaceType it, String ctrlDesc) throws IOException {
        String itname = it.getFcItfName();
        if (itname.endsWith("-controller") || itname.equals("component")) {
            InterfaceImplementationClassGenerator cg = new InterfaceImplementationClassGenerator(it, null, false, this.jc);
            this.jc.generateSourceCode(cg);
        } else {
            AbstractProxyClassGenerator cg = new ServerInterfaceClassGenerator(it, null, false, this.jc);
            this.jc.generateSourceCode(cg);
            if (it.isFcClientItf()) {
                cg = new ClientInterfaceClassGenerator(it, null, false, this.jc);
                this.jc.generateSourceCode(cg);
            }
            cg = new ServiceReferenceClassGenerator(it, null, false, this.jc);
            this.jc.generateSourceCode(cg);
            String signature = it.getFcItfSignature();
            UnifiedClass cl = this.jc.create(signature);
            Annotation annot = UnifiedClassHelper.getAnnotation(cl, Callback.class.getName(), "org.osoa.sca.annotations.Callback");
            if (annot != null) {
                Class cbcl = (Class)Util.getAnnotationParamValue(annot, "value");
                BasicInterfaceType cbit = new BasicInterfaceType("callback", cbcl.getName(), false, false, false);
                cg = new ServiceReferenceClassGenerator(cbit, null, false, this.jc);
                this.jc.generateSourceCode(cg);
                cg = new CallBackInterfaceClassGenerator(cbit, null, false, this.jc);
                this.jc.generateSourceCode(cg);
            }
        }
    }

    @Override
    public MembraneDesc<List<ControllerDesc>> generateMembraneImpl(ComponentType ct, String ctrldesc, String contentClassName) throws IOException {
        InterfaceType[] its = ct.getFcInterfaceTypes();
        this.generateInterfaceImpl(its, ctrldesc);
        InterfaceType[] membraneits = this.mloader.getMembraneType(ct, ctrldesc);
        this.generateInterfaceImpl(membraneits, ctrldesc);
        List<ControllerDesc> ctrlDescs = this.mloader.getCtrlImplLayers(ct, ctrldesc);
        for (ControllerDesc ctrlDesc : ctrlDescs) {
            List<String> ctrlImplLayers = ctrlDesc.getLayerImplNames();
            String ctrlImplClassName = ctrlDesc.getImplName();
            if (ctrlImplClassName.startsWith("(") || ctrlImplLayers == null) continue;
            ctrlImplClassName = Utils.getJuliacGeneratedStrongTypeName(ctrlImplClassName);
            ctrlImplClassName = this.jc.getRootedClassName(ctrlImplClassName);
            ctrlDesc.setImplName(ctrlImplClassName);
            if (this.jc.hasBeenGenerated(ctrlImplClassName)) continue;
            SpoonSupportItf spoon = this.jc.getSpoon();
            spoon.mixAndGenerate(ctrlImplClassName, ctrlImplLayers);
        }
        SimpleMembraneDesc md = new SimpleMembraneDesc(null, ctrldesc, membraneits, ctrlDescs);
        ProxyClassGeneratorItf icg = this.getInterceptorClassGenerator(ct, ctrldesc);
        md.setInterceptorClassGenerator(icg);
        this.generateInterceptorImpl(its, md);
        this.generateInterceptorImpl(membraneits, md);
        this.generateSCAContentControllerImpl(contentClassName);
        this.generateMembraneInitializer(md, ct, contentClassName);
        return md;
    }

    private void generateSCAContentControllerImpl(String contentClassName) throws IOException {
        if (contentClassName == null) {
            return;
        }
        try {
            SCAContentControllerClassGenerator cg = new SCAContentControllerClassGenerator(this.jc, contentClassName);
            this.jc.generateSourceCode(cg);
        }
        catch (IllegalContentClassMetaData iccmd) {
            IOException ioe = new IOException();
            ioe.initCause(iccmd);
            throw ioe;
        }
    }

    private void generateMembraneInitializer(MembraneDesc<List<ControllerDesc>> membraneDesc, ComponentType ct, String contentClassName) throws IOException {
        InitializerOOCtrlClassGenerator icg = this.getInitializerClassGenerator();
        icg.init(this.jc, this, membraneDesc, ct, contentClassName);
        MembraneInitializerOOCtrlClassGenerator micg = icg.getMembraneInitializerClassGenerator();
        this.jc.generateSourceCode(micg);
    }
}

