/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.opt.oo;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.JuliacRuntimeException;
import org.objectweb.fractal.juliac.conf.JuliacConfig;
import org.objectweb.fractal.juliac.opt.ClassGenerator;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.CatchSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ThenSourceCodeVisitor;
import org.ow2.frascati.tinfi.TinfiRuntimeException;
import org.ow2.frascati.tinfi.control.content.ContentClassMetaData;
import org.ow2.frascati.tinfi.control.content.IllegalContentClassMetaData;
import org.ow2.frascati.tinfi.reflect.InjectionPoint;
import org.ow2.frascati.tinfi.reflect.InjectionPointFieldImpl;
import org.ow2.frascati.tinfi.reflect.InjectionPointMethodImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCAContentControllerClassGenerator
extends ClassGenerator {
    private static final String SUFFIX = "FCSCAContentControllerImpl";
    private Juliac jc;
    private String contentClassName;
    private ContentClassMetaData ccmd;
    private static final Map<Class<?>, Class<?>> boxed = new HashMap<Class<?>, Class<?>>(){
        private static final long serialVersionUID = -4311595724796658568L;
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Character.TYPE, Character.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Short.TYPE, Short.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
        }
    };

    public SCAContentControllerClassGenerator(Juliac jc, String contentClassName) throws IllegalContentClassMetaData {
        this.jc = jc;
        this.contentClassName = contentClassName;
        JuliacConfig jconf = jc.getJuliacConfig();
        ClassLoader classloader = jconf.getClassLoader();
        Class<?> cl = null;
        try {
            cl = classloader.loadClass(contentClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JuliacRuntimeException(cnfe);
        }
        this.ccmd = ContentClassMetaData.get(cl);
    }

    @Override
    public String getTargetClassName() {
        String targetClassName = this.contentClassName + SUFFIX;
        String rootedTargetClassName = this.jc.getRootedClassName(targetClassName);
        return rootedTargetClassName;
    }

    @Override
    public String getSuperClassName() {
        return "juliac.generated.SCAContentControllerImpl";
    }

    @Override
    public void generateMethods(ClassSourceCodeVisitor cv) {
        this.generateMethodSetPropertyValue(cv);
    }

    protected void generateMethodSetPropertyValue(ClassSourceCodeVisitor cv) {
        BlockSourceCodeVisitor mv = cv.visitMethod(1, null, "void", "setPropertyValue", new String[]{"String name", "Object value"}, null);
        if (this.ccmd.props.size() != 0) {
            this.generateMethodSetPropertyValue(mv);
        }
        mv.visitEnd();
    }

    protected void generateMethodSetPropertyValue(BlockSourceCodeVisitor mv) {
        mv.visitIns("Object[] contents = sm.getFcCurrentContents()");
        Set set = this.ccmd.props.entrySet();
        Iterator<Map.Entry<String, InjectionPoint>> iterator = set.iterator();
        BlockSourceCodeVisitor fv = mv.visitFor("Object content : contents");
        this.generateMethodSetPropertyValue(fv, iterator);
        fv.visitEnd();
    }

    protected void generateMethodSetPropertyValue(BlockSourceCodeVisitor blockv, Iterator<Map.Entry<String, InjectionPoint>> iterator) {
        Map.Entry<String, InjectionPoint> entry = iterator.next();
        String ipname = entry.getKey();
        InjectionPoint ip = entry.getValue();
        String condition = "name.equals(\"" + ipname + "\")";
        ThenSourceCodeVisitor thenv = blockv.visitIf(condition);
        String prefix = "((" + this.contentClassName + ")content).";
        Class<?> type = ip.getType();
        if (type.isPrimitive()) {
            type = boxed.get(type);
        }
        String tname = SCAContentControllerClassGenerator.getName(type);
        String value = "(" + tname + ")value";
        if (ip instanceof InjectionPointFieldImpl) {
            InjectionPointFieldImpl ipf = (InjectionPointFieldImpl)ip;
            Field f = ipf.getField();
            int mod = f.getModifiers();
            String fname = f.getName();
            Class<?> dc = f.getDeclaringClass();
            if (this.isAccessibleWithStaticInvocation(mod, dc)) {
                thenv.visitIns(prefix, fname, "=", value);
            } else {
                CatchSourceCodeVisitor catchv = thenv.visitTry();
                catchv.visitIns(Field.class.getName(), "field =", dc, ".class.getDeclaredField(\"" + fname + "\")");
                catchv.visitIns("field.setAccessible(true)");
                catchv.visitIns("field.set(content,value)");
                catchv = catchv.visitCatch(Exception.class, "e");
                catchv.visitIns("throw new", TinfiRuntimeException.class.getName(), "(e)");
                catchv.visitEnd();
            }
        } else {
            InjectionPointMethodImpl ipm = (InjectionPointMethodImpl)ip;
            Method setter = ipm.getSetterMethod();
            int mod = setter.getModifiers();
            String mname = setter.getName();
            Class<?> dc = setter.getDeclaringClass();
            if (this.isAccessibleWithStaticInvocation(mod, dc)) {
                thenv.visitIns(prefix, mname, "(", value, ")");
            } else {
                CatchSourceCodeVisitor catchv = thenv.visitTry();
                catchv.visitIns(Method.class.getName(), "setter =", dc, ".class.getDeclaredMethod(\"" + mname + "\",", type.getName(), ".class)");
                catchv.visitIns("setter.setAccessible(true)");
                catchv.visitIns("setter.invoke(content,value)");
                catchv = catchv.visitCatch(Exception.class, "e");
                catchv.visitIns("throw new", TinfiRuntimeException.class.getName(), "(e)");
                catchv.visitEnd();
            }
        }
        if (iterator.hasNext()) {
            BlockSourceCodeVisitor elsev = thenv.visitElse();
            this.generateMethodSetPropertyValue(elsev, iterator);
            elsev.visitEnd();
        } else {
            thenv.visitEnd();
        }
    }

    private boolean isAccessibleWithStaticInvocation(int mod, Class<?> dc) {
        if (Modifier.isPrivate(mod)) {
            return false;
        }
        if (Modifier.isPublic(mod)) {
            return true;
        }
        String targetClassName = this.getTargetClassName();
        int l = targetClassName.lastIndexOf(46);
        String targetPackageName = targetClassName.substring(0, l);
        String dpname = dc.getPackage().getName();
        boolean b = dpname.equals(targetPackageName);
        return b;
    }

    private static String getName(Class<?> cl) {
        if (cl.isArray()) {
            Class<?> element = cl.getComponentType();
            return SCAContentControllerClassGenerator.getName(element) + "[]";
        }
        String name = cl.getName();
        if (name.indexOf(36) != -1) {
            name = name.replace('$', '.');
        }
        return name;
    }
}

