/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.opt.oo;

import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.proxy.AbstractInterceptorSourceCodeGenerator;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.osoa.sca.annotations.EndsConversation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCAContentInterceptorSourceCodeGenerator
extends AbstractInterceptorSourceCodeGenerator {
    public SCAContentInterceptorSourceCodeGenerator() {
    }

    public SCAContentInterceptorSourceCodeGenerator(InterfaceType it, MembraneDesc<?> membraneDesc, boolean mergeable, Juliac jc) {
        super(it, membraneDesc, mergeable, jc);
    }

    @Override
    public String getClassNameSuffix() {
        return "SCACC";
    }

    @Override
    public boolean match() {
        String itname = this.it.getFcItfName();
        if (itname.equals("component") || itname.endsWith("-controller")) {
            return false;
        }
        return !this.it.isFcClientItf();
    }

    @Override
    public void setMergeable(boolean mergeable) {
        if (mergeable) {
            String msg = "This generator can not generate mergeable code";
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public void generateProxyMethodBodyBeforeCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        mv.visit("    ");
        mv.visit(this.it.getFcItfSignature());
        String[] tpnames = proxycl.getTypeParameterNames();
        if (tpnames.length != 0) {
            String s = Utils.getTypeParameterNamesSignature(tpnames);
            mv.visit(s);
        }
        mv.visit(" impl = pushFcAndGet(\"");
        mv.visit(this.it.getFcItfName());
        mv.visitln("\"," + this.it.getFcItfSignature() + ".class,this);");
        mv.visitln("    try {");
    }

    @Override
    public void generateProxyMethodBodyFinallyCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        mv.visitln("    }");
        mv.visitln("    finally {");
        mv.visit("      releaseFcAndPop(impl,");
        if (proxym.getAnnotation(EndsConversation.class) == null) {
            mv.visit("false");
        } else {
            mv.visit("true");
        }
        mv.visitln(");");
        mv.visitln("    }");
    }
}

