/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.opt.oo;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.proxy.AbstractInterceptorSourceCodeGenerator;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.ow2.frascati.tinfi.IntentJoinPointImpl;
import org.ow2.frascati.tinfi.TinfiRuntimeException;
import org.ow2.frascati.tinfi.api.IntentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCAIntentInterceptorSourceCodeGenerator
extends AbstractInterceptorSourceCodeGenerator {
    public SCAIntentInterceptorSourceCodeGenerator() {
    }

    public SCAIntentInterceptorSourceCodeGenerator(InterfaceType it, MembraneDesc<?> membraneDesc, boolean mergeable, Juliac jc) {
        super(it, membraneDesc, mergeable, jc);
    }

    @Override
    public String getClassNameSuffix() {
        return "Intent";
    }

    @Override
    public boolean match() {
        return true;
    }

    @Override
    public void setMergeable(boolean mergeable) {
        if (mergeable) {
            String msg = "This generator can not generate mergeable code";
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public void generateStaticParts(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        BlockSourceCodeVisitor bv = cv.visitStaticPart();
        bv.visitln("    try {");
        bv.visitln("      METHODS = new java.lang.reflect.Method[]{");
        UnifiedMethod[] proxymethods = proxycl.getMethods();
        String proxyclname = proxycl.getName();
        for (int i = 0; i < proxymethods.length; ++i) {
            UnifiedMethod proxym = proxymethods[i];
            String proxymname = proxym.getName();
            UnifiedClass[] paramtypes = proxym.getParameterTypes();
            bv.visit("        ");
            bv.visit(proxyclname);
            bv.visit(".class.getMethod(\"");
            bv.visit(proxymname);
            bv.visit("\"");
            for (UnifiedClass paramtype : paramtypes) {
                String paramtypename = paramtype.getName();
                bv.visit(",");
                bv.visit(paramtypename);
                bv.visit(".class");
            }
            bv.visitln("),");
        }
        bv.visitln("      };");
        bv.visitln("    }");
        bv.visitln("    catch( NoSuchMethodException e ) {");
        bv.visit("      throw new ");
        bv.visit(TinfiRuntimeException.class.getName());
        bv.visitln("(e);");
        bv.visitln("    }");
        bv.visitEnd();
    }

    @Override
    public void generateFields(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        int modifiers = 10;
        String type = "java.lang.reflect.Method[]";
        String name = "METHODS";
        cv.visitField(modifiers, type, name, null);
    }

    @Override
    public void generateMethodInitFcController(BlockSourceCodeVisitor mv, UnifiedClass proxycl) {
        mv.visitln("    initIntentHandlersMap(METHODS);");
    }

    @Override
    public void generateMethodClone(BlockSourceCodeVisitor mv, UnifiedClass proxycl) {
        mv.visitln("    clone.initIntentHandlersMap(METHODS);");
    }

    @Override
    public void generateProxyMethodBodyBeforeCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        int i;
        int idx = -1;
        String proxymstring = proxym.toString();
        UnifiedMethod[] ums = proxycl.getMethods();
        for (int i2 = 0; i2 < ums.length; ++i2) {
            UnifiedMethod um = ums[i2];
            String umstring = um.toString();
            if (!umstring.equals(proxymstring)) continue;
            idx = i2;
            break;
        }
        if (idx == -1) {
            String msg = proxym + " should have been found in the array of methods of " + proxycl;
            throw new TinfiRuntimeException(msg);
        }
        mv.visit("    java.util.List<");
        mv.visit(IntentHandler.class.getName());
        mv.visit("> handlers = intentHandlersMap.get(METHODS[");
        mv.visit(Integer.toString(idx));
        mv.visitln("]);");
        mv.visitln("    try {");
        String proxymname = proxym.getName();
        UnifiedClass[] ptypes = proxym.getParameterTypes();
        String rtypename = proxym.getGenericReturnType();
        String[] tpnames = proxym.getTypeParameterNames();
        mv.visitln("      if( handlers.size() == 0 ) {");
        mv.visit("        ");
        if (!rtypename.equals("void")) {
            mv.visit(rtypename + " ret = ");
        }
        mv.visit("impl.");
        if (tpnames.length > 0) {
            mv.visit("<");
            for (i = 0; i < tpnames.length; ++i) {
                if (i > 0) {
                    mv.visit(",");
                }
                mv.visit(tpnames[i]);
            }
            mv.visit(">");
        }
        mv.visit(proxymname);
        mv.visit("(");
        for (int j = 0; j < ptypes.length; ++j) {
            if (j != 0) {
                mv.visit(",");
            }
            mv.visit("arg");
            mv.visit(Integer.toString(j));
        }
        mv.visitln(");");
        if (!rtypename.equals("void")) {
            mv.visitln("        return ret;");
        }
        mv.visitln("      }");
        mv.visitln("      else {");
        mv.visit("        ");
        mv.visit(Component.class.getName());
        mv.visitln(" comp = getFcComponent();");
        mv.visit("        ");
        mv.visit(Interface.class.getName());
        mv.visitln(" itf = getFcItf();");
        mv.visit("        ");
        mv.visit(IntentJoinPointImpl.class.getName());
        mv.visit("<");
        mv.visit(this.it.getFcItfSignature());
        mv.visit("> ijp = new ");
        mv.visit(IntentJoinPointImpl.class.getName());
        mv.visitln("();");
        mv.visit("        ijp.init(handlers,comp,itf,impl,METHODS[");
        mv.visit(Integer.toString(idx));
        mv.visit("]");
        for (i = 0; i < ptypes.length; ++i) {
            mv.visit(",(Object)arg");
            mv.visit(Integer.valueOf(i).toString());
        }
        mv.visitln(");");
    }

    @Override
    public void generateProxyMethodBodyFinallyCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        UnifiedClass[] excepts;
        mv.visitln("      }");
        mv.visitln("    }");
        mv.visitln("    catch( Throwable t ) {");
        for (UnifiedClass except : excepts = proxym.getExceptionTypes()) {
            mv.visit("      if( t instanceof ");
            mv.visit(except.getName());
            mv.visitln(" ) {");
            mv.visit("        throw (");
            mv.visit(except.getName());
            mv.visitln(") t;");
            mv.visitln("      }");
        }
        mv.visitln("      if( t instanceof RuntimeException ) {");
        mv.visitln("        throw (RuntimeException) t;");
        mv.visitln("      }");
        mv.visit("      throw new ");
        mv.visit(TinfiRuntimeException.class.getName());
        mv.visitln("(t);");
        mv.visitln("    }");
    }
}

