/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.opt.oo;

import java.lang.annotation.Annotation;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.Callback;
import org.oasisopen.sca.annotation.OneWay;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.ComponentInterface;
import org.objectweb.fractal.julia.type.BasicInterfaceType;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.Utils;
import org.objectweb.fractal.juliac.desc.MembraneDesc;
import org.objectweb.fractal.juliac.proxy.AbstractProxyClassGenerator;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedClassHelper;
import org.objectweb.fractal.juliac.ucf.UnifiedMethod;
import org.objectweb.fractal.juliac.visit.BlockSourceCodeVisitor;
import org.objectweb.fractal.juliac.visit.ClassSourceCodeVisitor;
import org.osoa.sca.annotations.Conversational;
import org.osoa.sca.annotations.EndsConversation;
import org.ow2.frascati.tinfi.CallbackManager;
import org.ow2.frascati.tinfi.TinfiRuntimeException;
import org.ow2.frascati.tinfi.oasis.ServiceReferenceImpl;
import org.ow2.frascati.tinfi.opt.oo.CallBackInterfaceClassGenerator;
import org.ow2.frascati.tinfi.osoa.ConversationImpl;
import org.ow2.frascati.tinfi.reflect.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceReferenceClassGenerator
extends AbstractProxyClassGenerator {
    private Conversational conversationalItf;
    private Annotation oneWayMeth;
    private Class<?> callbackClass;

    public ServiceReferenceClassGenerator() {
    }

    public ServiceReferenceClassGenerator(InterfaceType it, MembraneDesc<?> membraneDesc, boolean mergeable, Juliac jc) {
        super(it, membraneDesc, mergeable, jc);
    }

    @Override
    public boolean match() {
        return true;
    }

    @Override
    public String getClassNameSuffix() {
        return "FcSR";
    }

    @Override
    public void setMergeable(boolean mergeable) {
        if (mergeable) {
            String msg = "This generator can not generate mergeable code";
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public String getSuperClassName() {
        StringBuffer sb = new StringBuffer();
        sb.append(ServiceReferenceImpl.class.getName());
        sb.append('<');
        String signature = this.it.getFcItfSignature();
        sb.append(signature);
        UnifiedClass proxycl = this.jc.create(signature);
        String[] tpnames = proxycl.getTypeParameterNames();
        if (tpnames.length != 0) {
            String s = Utils.getTypeParameterNamesSignature(tpnames);
            sb.append(s);
        }
        sb.append('>');
        return sb.toString();
    }

    @Override
    public String[] getImplementedInterfaceNames() {
        String signature = this.it.getFcItfSignature();
        UnifiedClass proxycl = this.jc.create(signature);
        String[] tpnames = proxycl.getTypeParameterNames();
        if (tpnames.length != 0) {
            String s = Utils.getTypeParameterNamesSignature(tpnames);
            signature = signature + s;
        }
        return new String[]{signature};
    }

    @Override
    public void generateConstructors(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        super.generateConstructors(cv, proxycl);
        String signature = this.it.getFcItfSignature();
        String[] tpnames = proxycl.getTypeParameterNames();
        if (tpnames.length != 0) {
            String s = Utils.getTypeParameterNamesSignature(tpnames);
            signature = signature + s;
        }
        String[] parameters = new String[]{"Class<" + signature + "> businessInterface", signature + " service"};
        BlockSourceCodeVisitor mv = cv.visitConstructor(1, null, parameters, null);
        mv.visitln("    super(businessInterface,service);");
        mv.visitEnd();
    }

    @Override
    public void generateMethods(ClassSourceCodeVisitor cv, UnifiedClass proxycl) {
        String signature = this.it.getFcItfSignature();
        BlockSourceCodeVisitor mv = cv.visitMethod(1, null, signature, "getService", null, null);
        mv.visitln("    return this;");
        mv.visitEnd();
    }

    @Override
    public void generateProxyMethodBodyBeforeCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        super.generateProxyMethodBodyBeforeCode(mv, proxycl, proxym);
        String signature = this.it.getFcItfSignature();
        String[] tpnames = proxycl.getTypeParameterNames();
        if (tpnames.length != 0) {
            String s = Utils.getTypeParameterNamesSignature(tpnames);
            signature = signature + s;
        }
        this.conversationalItf = proxycl.getAnnotation(Conversational.class);
        this.oneWayMeth = UnifiedClassHelper.getAnnotation(proxym, OneWay.class.getName(), "org.osoa.sca.annotations.OneWay");
        this.callbackClass = Void.class;
        Annotation callback = UnifiedClassHelper.getAnnotation(proxycl, Callback.class.getName(), "org.osoa.sca.annotations.Callback");
        if (callback != null) {
            this.callbackClass = (Class)Util.getAnnotationParamValue(callback, "value");
        }
        if (this.oneWayMeth != null) {
            UnifiedClass rtype = proxym.getReturnType();
            if (!rtype.getName().equals("void")) {
                String msg = "@OneWay annotated method " + proxym.toString() + " in " + proxycl.getName() + " should return void";
                throw new TinfiRuntimeException(msg);
            }
            mv.visitln("    new Thread() {");
            mv.visitln("      public void run() {");
        }
        if (this.conversationalItf != null) {
            mv.visitln("        " + ConversationImpl.class.getName() + " conv = _getConversation();");
            mv.visitln("        _pushConversation(conv);");
        }
        if (this.callbackClass != Void.class) {
            BasicInterfaceType cbit = new BasicInterfaceType("callback", this.callbackClass.getName(), false, false, false);
            AbstractProxyClassGenerator cg = new CallBackInterfaceClassGenerator(cbit, null, this.mergeable, this.jc);
            String cbitfclname = cg.getTargetClassName();
            cg = new ServiceReferenceClassGenerator(cbit, null, this.mergeable, this.jc);
            String cbcrclname = cg.getTargetClassName();
            mv.visit("        " + ComponentInterface.class.getName() + " ci = (");
            mv.visitln(ComponentInterface.class.getName() + ") service;");
            mv.visitln("        " + Component.class.getName() + " owner = ci.getFcItfOwner();");
            mv.visit("        " + InterfaceType.class.getName() + " it = ");
            mv.visit(Utils.javaify(cbit).toString());
            mv.visitln(";");
            mv.visitln("        " + cbitfclname + " cbci = new " + cbitfclname + "(owner,\"callback\",it,false,null);");
            mv.visit("        " + ServiceReference.class.getName() + "<" + this.callbackClass.getName() + "> cb = ");
            mv.visit("new " + cbcrclname + "(");
            mv.visitln(this.callbackClass.getName() + ".class,cbci);");
            mv.visitln("        _setCallback(cb);");
            mv.visitln("        " + CallbackManager.class.getName() + " cbm = " + CallbackManager.class.getName() + ".get();");
            mv.visitln("        cbm.push(cb);");
        }
    }

    @Override
    public void generateProxyMethodBodyAfterCode(BlockSourceCodeVisitor mv, UnifiedClass proxycl, UnifiedMethod proxym) {
        super.generateProxyMethodBodyAfterCode(mv, proxycl, proxym);
        EndsConversation end = proxym.getAnnotation(EndsConversation.class);
        if (end != null) {
            if (this.conversationalItf == null) {
                mv.visitln("    " + ConversationImpl.class.getName() + " conv = _peekConversation();");
            }
            mv.visitln("    conv.end();");
        }
        if (this.conversationalItf != null) {
            mv.visitln("    conv.access();");
            mv.visitln("    _popConversation();");
        }
        if (this.callbackClass != Void.class) {
            mv.visitln("    cbm.pop();");
            mv.visitln("    _setCallback(null);");
        }
        if (this.oneWayMeth != null) {
            mv.visitln("      }");
            mv.visitln("    }.start();");
        }
    }

    @Override
    public String getDelegatingInstance(UnifiedClass proxycl, UnifiedMethod proxym) {
        return "service";
    }
}

