/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.osoa;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.fractal.api.Component;
import org.osoa.sca.Conversation;
import org.osoa.sca.ConversationEndedException;
import org.ow2.frascati.tinfi.api.control.ContentInstantiationException;
import org.ow2.frascati.tinfi.control.content.ContentClassMetaData;
import org.ow2.frascati.tinfi.control.content.scope.AbstractScopeManager;
import org.ow2.frascati.tinfi.osoa.ConversationImpl;
import org.ow2.frascati.tinfi.osoa.ConversationManager;

public class ConversationScopeManager
extends AbstractScopeManager {
    private Map<Conversation, Object> contentMapConversationalScope = new HashMap<Conversation, Object>();

    public ConversationScopeManager(Component comp, ContentClassMetaData ccmd) {
        super(comp, ccmd);
    }

    public Object getFcContent() throws ContentInstantiationException {
        long idleTime;
        long current;
        long age;
        ConversationManager cm = ConversationManager.get();
        ConversationImpl conv = null;
        try {
            conv = cm.peek();
        }
        catch (EmptyStackException ese) {
            // empty catch block
        }
        Object content = null;
        if (this.contentMapConversationalScope.containsKey(conv)) {
            content = this.contentMapConversationalScope.get(conv);
        } else {
            content = this.createAndInitializeFcInstance();
            if (this.ccmd.conversationIDAnnotatedElement != null) {
                Object conversationID = conv.getConversationID();
                try {
                    this.ccmd.conversationIDAnnotatedElement.set(content, conversationID);
                }
                catch (IllegalAccessException e) {
                    throw new ContentInstantiationException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ContentInstantiationException(e);
                }
            }
            this.contentMapConversationalScope.put(conv, content);
        }
        if (this.ccmd.convMaxAge != 0L && (age = (current = System.currentTimeMillis()) - conv.getCreation()) > this.ccmd.convMaxAge) {
            conv.end();
            this.contentMapConversationalScope.remove(conv);
            String msg = "Conversation has expired (maxAge: " + this.ccmd.convMaxAge + ")";
            throw new ConversationEndedException(msg);
        }
        if (this.ccmd.convMaxIdleTime != 0L && (idleTime = (current = System.currentTimeMillis()) - conv.getLastAccess()) > this.ccmd.convMaxIdleTime) {
            conv.end();
            this.contentMapConversationalScope.remove(conv);
            String msg = "Conversation has expired (maxIdleTime: " + this.ccmd.convMaxIdleTime + ")";
            throw new ConversationEndedException(msg);
        }
        return content;
    }

    public void releaseFcContent(Object content, boolean isEndMethod) {
        this.destroyFcInstance(content);
    }

    public Object[] getFcCurrentContents() {
        Collection<Object> contents = this.contentMapConversationalScope.values();
        return contents.toArray(new Object[contents.size()]);
    }
}

