/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.ow2.frascati.tinfi.reflect.InjectionPoint;
import org.ow2.frascati.tinfi.reflect.InjectionPointFieldImpl;
import org.ow2.frascati.tinfi.reflect.InjectionPointMethodImpl;
import org.ow2.frascati.tinfi.reflect.Util;

public abstract class InjectionPointImpl
implements InjectionPoint {
    private Annotation annot;

    public InjectionPointImpl(Annotation annot) {
        this.annot = annot;
    }

    public Annotation getAnnotation() {
        return this.annot;
    }

    public static InjectionPoint getInjectionPoint(AccessibleObject ao, Annotation annot) {
        InjectionPointImpl ip = null;
        if (ao instanceof Method) {
            Method setter = (Method)ao;
            try {
                Method getter = Util.getGetterForSetter(setter);
                ip = new InjectionPointMethodImpl(setter, getter, annot);
            }
            catch (NoSuchMethodException e) {
                ip = new InjectionPointMethodImpl(setter, annot);
            }
        } else {
            Field field = (Field)ao;
            ip = new InjectionPointFieldImpl(field, annot);
            return ip;
        }
        return ip;
    }
}

