/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.ow2.frascati.tinfi.reflect.DuplicationInjectionPointException;
import org.ow2.frascati.tinfi.reflect.InjectionPoint;
import org.ow2.frascati.tinfi.reflect.InjectionPointImpl;
import org.ow2.frascati.tinfi.reflect.NoSuchInjectionPointException;
import org.ow2.frascati.tinfi.reflect.SetterMethodFilter;
import org.ow2.frascati.tinfi.reflect.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionPointMap
extends HashMap<String, InjectionPoint> {
    private static final long serialVersionUID = -2199033442372122424L;
    private Class<?> cl;
    private String[] annotClassNames;

    public InjectionPointMap(Class<?> cl, String ... annotClassNames) {
        this.cl = cl;
        this.annotClassNames = annotClassNames;
    }

    public void putAll() throws DuplicationInjectionPointException {
        AccessibleObject[] aos;
        for (AccessibleObject ao : aos = Util.getAllAnnotatedSettersAndFields(this.cl, this.annotClassNames)) {
            String ipname = this.getInjectionPointName(ao);
            Annotation annot = Util.getAnnotation(ao, this.annotClassNames);
            InjectionPoint ip = InjectionPointImpl.getInjectionPoint(ao, annot);
            if (this.containsKey(ipname)) {
                InjectionPoint other = (InjectionPoint)this.get(ipname);
                boolean b = ip.override(other);
                if (b) {
                    this.remove(other);
                    this.put(ipname, ip);
                    continue;
                }
                b = other.override(ip);
                if (b) continue;
                throw new DuplicationInjectionPointException(ipname, this.cl, this.annotClassNames);
            }
            this.put(ipname, ip);
        }
    }

    public void put(String name) throws NoSuchInjectionPointException, DuplicationInjectionPointException {
        AccessibleObject[] aos = Util.getAllAnnotatedSettersAndFields(this.cl, this.annotClassNames);
        boolean found = false;
        for (AccessibleObject ao : aos) {
            String ipname = this.getInjectionPointName(ao);
            if (!ipname.equals(name)) continue;
            if (this.containsKey(name)) {
                throw new DuplicationInjectionPointException(name, this.cl, this.annotClassNames);
            }
            Annotation annot = Util.getAnnotation(ao, this.annotClassNames);
            InjectionPoint ip = InjectionPointImpl.getInjectionPoint(ao, annot);
            this.put(name, ip);
            found = true;
        }
        if (!found) {
            throw new NoSuchInjectionPointException(name, this.cl, this.annotClassNames);
        }
    }

    @Override
    public void put(Field field, Annotation annot) throws DuplicationInjectionPointException {
        String name = field.getName();
        if (this.containsKey(name)) {
            throw new DuplicationInjectionPointException(name, this.cl, this.annotClassNames);
        }
        InjectionPoint ip = InjectionPointImpl.getInjectionPoint(field, annot);
        this.put(name, ip);
    }

    @Override
    public void put(Method setter, Annotation annot) throws DuplicationInjectionPointException {
        SetterMethodFilter.checkSetterMethod(setter);
        String name = SetterMethodFilter.getSetterPropertyName(setter);
        if (this.containsKey(name)) {
            throw new DuplicationInjectionPointException(name, this.cl, this.annotClassNames);
        }
        InjectionPoint ip = InjectionPointImpl.getInjectionPoint(setter, annot);
        this.put(name, ip);
    }

    private String getInjectionPointName(AccessibleObject ao) {
        Annotation annot = Util.getAnnotation(ao, this.annotClassNames);
        String name = (String)Util.getAnnotationParamValue(annot, "name");
        if (name == null || name.length() == 0) {
            if (ao instanceof Method) {
                Method method = (Method)ao;
                name = SetterMethodFilter.getSetterPropertyName(method);
            } else {
                Field field = (Field)ao;
                name = field.getName();
            }
        }
        return name;
    }
}

