/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ow2.frascati.tinfi.reflect.InjectionPoint;
import org.ow2.frascati.tinfi.reflect.InjectionPointImpl;
import org.ow2.frascati.tinfi.reflect.SetterMethodFilter;
import org.ow2.frascati.tinfi.reflect.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionPointMethodImpl
extends InjectionPointImpl {
    private Method setter;
    private Method getter;

    public InjectionPointMethodImpl(Method setter, Annotation annot) throws IllegalArgumentException {
        super(annot);
        SetterMethodFilter.checkSetterMethod(setter);
        this.setter = setter;
        setter.setAccessible(true);
    }

    public InjectionPointMethodImpl(Method setter, Method getter, Annotation annot) throws IllegalArgumentException {
        super(annot);
        Util.checkMatchingSetterGetterMethods(setter, getter);
        this.setter = setter;
        this.getter = getter;
        setter.setAccessible(true);
        getter.setAccessible(true);
    }

    @Override
    public void set(Object target, Object value) throws IllegalAccessException, InvocationTargetException {
        this.setter.invoke(target, value);
    }

    @Override
    public Object get(Object target) throws IllegalAccessException, InvocationTargetException, UnsupportedOperationException {
        if (this.getter == null) {
            String msg = "Can not get the value with a setter method";
            throw new UnsupportedOperationException(msg);
        }
        Object value = this.getter.invoke(target, new Object[0]);
        return value;
    }

    public Method getGetterMethod() {
        return this.getter;
    }

    public Method getSetterMethod() {
        return this.setter;
    }

    @Override
    public Class<?> getType() {
        Class<?>[] ptypes = this.setter.getParameterTypes();
        return ptypes[0];
    }

    @Override
    public boolean override(InjectionPoint other) {
        if (!(other instanceof InjectionPointMethodImpl)) {
            return false;
        }
        Method othersetter = ((InjectionPointMethodImpl)other).setter;
        boolean b = Util.override(this.setter, othersetter);
        return b;
    }
}

