/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.reflect;

import java.lang.reflect.Method;
import org.ow2.frascati.tinfi.reflect.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetterMethodFilter
implements Filter<Method> {
    @Override
    public boolean accept(Method method) {
        boolean b = SetterMethodFilter.isSetterMethod(method);
        return b;
    }

    public static boolean isSetterMethod(Method setter) {
        try {
            SetterMethodFilter.checkSetterMethod(setter);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public static void checkSetterMethod(Method setter) throws IllegalArgumentException {
        String name = setter.getName();
        if (!name.startsWith("set")) {
            String msg = "The name of a setter method should start with set: " + setter;
            throw new IllegalArgumentException(msg);
        }
        Class<?> rtype = setter.getReturnType();
        if (!rtype.equals(Void.TYPE)) {
            String msg = "A setter method should return void: " + setter;
            throw new IllegalArgumentException(msg);
        }
        Class<?>[] ptypes = setter.getParameterTypes();
        if (ptypes.length != 1) {
            String msg = "A setter method should define only one parameter: " + setter;
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkSetterMethod(Method setter, Class<?> proptype) throws IllegalArgumentException {
        Class<?> type = SetterMethodFilter.getSetterPropertyType(setter);
        if (!proptype.isAssignableFrom(type)) {
            String msg = "Method " + setter + " is not a setter method for property type " + proptype.getName();
            throw new IllegalArgumentException(msg);
        }
    }

    public static Class<?> getSetterPropertyType(Method setter) throws IllegalArgumentException {
        SetterMethodFilter.checkSetterMethod(setter);
        Class<?>[] ptypes = setter.getParameterTypes();
        return ptypes[0];
    }

    public static String getSetterPropertyName(Method setter) throws IllegalArgumentException {
        SetterMethodFilter.checkSetterMethod(setter);
        String name = setter.getName();
        name = name.substring(3);
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        return name;
    }
}

