/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.juliac.runtime.ClassLoaderItf;
import org.objectweb.fractal.juliac.runtime.Juliac;
import org.ow2.frascati.tinfi.TinfiRuntimeException;
import org.ow2.frascati.tinfi.reflect.AnnotatedElementFilter;
import org.ow2.frascati.tinfi.reflect.Filters;
import org.ow2.frascati.tinfi.reflect.SetterMethodFilter;
import org.ow2.frascati.tinfi.reflect.UnAnnotatedElementFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static void checkGetterMethod(Method getter) throws IllegalArgumentException {
        String name = getter.getName();
        if (!name.startsWith("get")) {
            String msg = "The name of a getter method should start with get: " + getter;
            throw new IllegalArgumentException(msg);
        }
        Class<?>[] ptypes = getter.getParameterTypes();
        if (ptypes.length != 0) {
            String msg = "A getter method should not define any parameter: " + getter;
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkMatchingSetterGetterMethods(Method setter, Method getter) throws IllegalArgumentException {
        Class<?> getterPropType;
        SetterMethodFilter.checkSetterMethod(setter);
        Util.checkGetterMethod(getter);
        String setterPropName = SetterMethodFilter.getSetterPropertyName(setter);
        String getterPropName = Util.getGetterPropertyName(getter);
        if (!setterPropName.equals(getterPropName)) {
            String msg = "Property names differ: " + setterPropName + " vs " + getterPropName;
            throw new IllegalArgumentException(msg);
        }
        Class<?> setterPropType = SetterMethodFilter.getSetterPropertyType(setter);
        if (!setterPropType.equals(getterPropType = Util.getGetterPropertyType(getter))) {
            String msg = "Property types differ: " + setterPropType + " vs " + getterPropType;
            throw new IllegalArgumentException(msg);
        }
    }

    public static Field[] getAllFields(Class<?> cl) {
        ArrayList<Field> result = new ArrayList<Field>();
        Util.addAllFields(cl, result);
        return result.toArray(new Field[result.size()]);
    }

    public static void addAllFields(Class<?> cl, List<Field> list) {
        Field[] fields;
        for (Field field : fields = cl.getDeclaredFields()) {
            list.add(field);
        }
        Class<?> supercl = cl.getSuperclass();
        if (!supercl.equals(Object.class)) {
            Util.addAllFields(supercl, list);
        }
    }

    public static Method[] getAllMethods(Class<?> cl) {
        ArrayList<Method> result = new ArrayList<Method>();
        Util.addAllMethods(cl, result);
        return result.toArray(new Method[result.size()]);
    }

    public static void addAllMethods(Class<?> cl, List<Method> list) {
        Method[] methods;
        for (Method method : methods = cl.getDeclaredMethods()) {
            list.add(method);
        }
        Class<?> supercl = cl.getSuperclass();
        if (!supercl.equals(Object.class)) {
            Util.addAllMethods(supercl, list);
        }
    }

    public static AccessibleObject[] getAllAnnotatedSettersAndFields(Class<?> cl, String ... annotClassNames) {
        Method[] methods = Util.getAllMethods(cl);
        Method[] ms0 = Filters.filter(methods, new SetterMethodFilter());
        AnnotatedElementFilter filter = new AnnotatedElementFilter(annotClassNames);
        Method[] ms1 = Filters.filter(ms0, filter);
        Field[] fields = Util.getAllFields(cl);
        Field[] fs0 = Filters.filter(fields, filter);
        AccessibleObject[] aos = new AccessibleObject[ms1.length + fs0.length];
        System.arraycopy(ms1, 0, aos, 0, ms1.length);
        System.arraycopy(fs0, 0, aos, ms1.length, fs0.length);
        return aos;
    }

    public static AccessibleObject[] getAnnotatedSettersAndFields(Class<?> cl, String ... annotClassNames) {
        Method[] methods = cl.getMethods();
        Method[] ms0 = Filters.filter(methods, new SetterMethodFilter());
        AnnotatedElementFilter filter = new AnnotatedElementFilter(annotClassNames);
        Method[] ms1 = Filters.filter(ms0, filter);
        Field[] fields = cl.getFields();
        Field[] fs0 = Filters.filter(fields, filter);
        AccessibleObject[] aos = new AccessibleObject[ms1.length + fs0.length];
        System.arraycopy(ms1, 0, aos, 0, ms1.length);
        System.arraycopy(fs0, 0, aos, ms1.length, fs0.length);
        return aos;
    }

    public static Annotation getAnnotation(Class<?> cl, String ... annotClassNames) {
        Annotation[] annots = cl.getAnnotations();
        for (String annotClassName : annotClassNames) {
            for (Annotation annot : annots) {
                String name = annot.annotationType().getName();
                if (!name.equals(annotClassName)) continue;
                return annot;
            }
        }
        Class<?> supercl = cl.getSuperclass();
        if (!supercl.equals(Object.class)) {
            Annotation annot = Util.getAnnotation(supercl, annotClassNames);
            return annot;
        }
        return null;
    }

    public static Annotation getAnnotation(AccessibleObject ao, String ... annotClassNames) {
        Annotation[] annots = ao.getAnnotations();
        for (String annotClassName : annotClassNames) {
            for (Annotation annot : annots) {
                String name = annot.annotationType().getName();
                if (!name.equals(annotClassName)) continue;
                return annot;
            }
        }
        return null;
    }

    public static <T> T getAnnotationParamValue(Annotation annot, String name) {
        if (annot == null) {
            return null;
        }
        Class<?> annotcl = annot.getClass();
        try {
            Method meth = annotcl.getMethod(name, new Class[0]);
            Object value = meth.invoke((Object)annot, new Object[0]);
            return (T)value;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static Method getGetterForSetter(Method setter) throws NoSuchMethodException {
        Method[] methods;
        Class<?> cl = setter.getDeclaringClass();
        for (Method method : methods = cl.getDeclaredMethods()) {
            if (!Util.isMatchingSetterGetter(setter, method)) continue;
            return method;
        }
        for (Method method : methods = cl.getMethods()) {
            if (!Util.isMatchingSetterGetter(setter, method)) continue;
            return method;
        }
        throw new NoSuchMethodException();
    }

    public static String getGetterPropertyName(Method getter) throws IllegalArgumentException {
        Util.checkGetterMethod(getter);
        String name = getter.getName();
        name = name.substring(3);
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        return name;
    }

    public static Class<?> getGetterPropertyType(Method getter) throws IllegalArgumentException {
        Util.checkGetterMethod(getter);
        Class<?> rtype = getter.getReturnType();
        return rtype;
    }

    public static Map<String, Method> getAllUnAnnotatedSetterMethods(Class<?> cl) {
        Method[] methods = Util.getAllMethods(cl);
        Method[] ms0 = Filters.filter(methods, new SetterMethodFilter());
        UnAnnotatedElementFilter filter = new UnAnnotatedElementFilter();
        Method[] ms1 = Filters.filter(ms0, filter);
        HashMap<String, Method> result = new HashMap<String, Method>();
        for (Method setter : ms1) {
            String propName = SetterMethodFilter.getSetterPropertyName(setter);
            result.put(propName, setter);
        }
        return result;
    }

    public static boolean isAnnotationPresent(Class<?> cl, String ... annotClassNames) {
        Annotation annot = Util.getAnnotation(cl, annotClassNames);
        return annot != null;
    }

    public static boolean isGetterMethod(Method getter) {
        try {
            Util.checkGetterMethod(getter);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public static boolean isMatchingSetterGetter(Method setter, Method getter) {
        try {
            Util.checkMatchingSetterGetterMethods(setter, getter);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public static Class<?> loadClass(String name, ClassLoader cl) throws ClassNotFoundException {
        Class<?> c = cl.loadClass(name);
        return c;
    }

    public static Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassLoaderItf cl = null;
        try {
            Component boot = new Juliac().newFcInstance();
            cl = (ClassLoaderItf)boot.getFcInterface("classloader");
        }
        catch (NoSuchInterfaceException nsie) {
            throw new TinfiRuntimeException(nsie);
        }
        Class c = cl.loadClass(name);
        return c;
    }

    public static String getShortSignature(Method src) {
        int parenthesis;
        String s;
        int methoddot;
        String signature = src.toString();
        String ret = signature.substring((methoddot = (s = signature.substring(0, parenthesis = signature.indexOf(40))).lastIndexOf(46)) + 1);
        int thr = ret.indexOf(" throws");
        if (thr != -1) {
            ret = ret.substring(0, thr);
        }
        return ret;
    }

    public static boolean sameSignature(Method src, Method target) {
        String srcsig = Util.getShortSignature(src);
        String targetsig = Util.getShortSignature(target);
        boolean b = srcsig.equals(targetsig);
        return b;
    }

    public static boolean override(Field src, Field target) {
        String targetname;
        String srcname = src.getName();
        boolean b = srcname.equals(targetname = target.getName());
        if (!b) {
            return false;
        }
        Class<?> srccl = src.getDeclaringClass();
        Class<?> targetcl = target.getDeclaringClass();
        return targetcl.isAssignableFrom(srccl);
    }

    public static boolean override(Method src, Method target) {
        boolean b = Util.sameSignature(src, target);
        if (!b) {
            return false;
        }
        Class<?> srccl = src.getDeclaringClass();
        Class<?> targetcl = target.getDeclaringClass();
        return targetcl.isAssignableFrom(srccl);
    }

    public static Method[] removeOverriden(Method[] methods) {
        ArrayList<Method> res = new ArrayList<Method>();
        res.addAll(Arrays.asList(methods));
        for (int i = 0; i < methods.length; ++i) {
            for (int j = 0; j < methods.length; ++j) {
                boolean b;
                if (j == i || !(b = Util.override(methods[j], methods[i]))) continue;
                res.remove(methods[i]);
            }
        }
        return res.toArray(new Method[res.size()]);
    }

    public static AccessibleObject[] removeOverriden(AccessibleObject[] aos) {
        ArrayList<AccessibleObject> res = new ArrayList<AccessibleObject>();
        res.addAll(Arrays.asList(aos));
        for (int i = 0; i < aos.length; ++i) {
            for (int j = 0; j < aos.length; ++j) {
                if (j == i) continue;
                boolean b = false;
                if (aos[i] instanceof Method && aos[j] instanceof Method) {
                    b = Util.override((Method)aos[j], (Method)aos[i]);
                } else if (aos[i] instanceof Field && aos[j] instanceof Field) {
                    b = Util.override((Field)aos[j], (Field)aos[i]);
                }
                if (!b) continue;
                res.remove(aos[i]);
            }
        }
        return res.toArray(new AccessibleObject[res.size()]);
    }
}

