/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.tinfi.tinfilet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.fraclet.extensions.Membrane;
import org.objectweb.fractal.fraclet.types.Constants;
import org.objectweb.fractal.julia.type.BasicComponentType;
import org.objectweb.fractal.julia.type.BasicInterfaceType;
import org.objectweb.fractal.juliac.Juliac;
import org.objectweb.fractal.juliac.api.ADLParserSupportItf;
import org.objectweb.fractal.juliac.conf.JuliacConfig;
import org.objectweb.fractal.juliac.conf.JulietLoader;
import org.objectweb.fractal.juliac.conf.MembraneHelper;
import org.objectweb.fractal.juliac.opt.InitializerClassGenerator;
import org.objectweb.fractal.juliac.ucf.UnifiedClass;
import org.objectweb.fractal.juliac.ucf.UnifiedClassHelper;
import org.objectweb.fractal.juliac.ucf.UnifiedField;
import org.ow2.frascati.tinfi.tinfilet.EmptySubClassGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinfiParserSupportImpl
implements ADLParserSupportItf {
    protected Juliac jc;
    public static final String FACTORY_SUFFIX = "Factory";

    @Override
    public void init(Juliac jc) {
        this.jc = jc;
    }

    @Override
    public void close(Juliac jc) {
    }

    @Override
    public boolean acceptADLDesc(String adl) {
        return true;
    }

    @Override
    public <T> T parse(String adl, Object context) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generate(String adl, String targetname, Object context) throws IOException {
        String signature;
        Object service;
        UnifiedClass uc = this.jc.create(adl);
        HashMap servicemap = new HashMap();
        Service serviceannot = UnifiedClassHelper.getAnnotation(uc, Service.class);
        if (serviceannot != null) {
            Class<?>[] services = serviceannot.value();
            String[] servicenames = serviceannot.names();
            for (int i = 0; i < services.length; ++i) {
                String name = null;
                if (i < servicenames.length) {
                    name = servicenames[i];
                } else {
                    String s = services[i].getSimpleName();
                    String head = s.substring(0, 1).toLowerCase();
                    String tail = s.substring(1);
                    name = head + tail;
                }
                if (servicemap.containsKey(name)) {
                    String msg = "Duplicate service name " + name + " in " + adl;
                    throw new IOException(msg);
                }
                servicemap.put(name, services[i]);
            }
        }
        HashMap<String, UnifiedClass> refmap = new HashMap<String, UnifiedClass>();
        HashMap<String, Boolean> refcontingencymap = new HashMap<String, Boolean>();
        HashMap<String, Boolean> refcardinalitymap = new HashMap<String, Boolean>();
        UnifiedClass uclist = this.jc.create(List.class.getName());
        UnifiedField[] fields = UnifiedClassHelper.getAllFields(uc);
        for (UnifiedField field : fields = UnifiedClassHelper.removeOverriden(fields)) {
            Reference annot = field.getAnnotation(Reference.class);
            if (annot == null) continue;
            String name = annot.name();
            if (name.length() == 0) {
                name = field.getName();
            }
            if (servicemap.containsKey(name) || refmap.containsKey(name)) {
                String msg = "Duplicate service/reference name " + name + " in " + adl;
                throw new IOException(msg);
            }
            UnifiedClass fieldtype = field.getType();
            boolean isMultiple = uclist.isAssignableFrom(fieldtype);
            refcardinalitymap.put(name, isMultiple);
            UnifiedClass reftype = null;
            if (isMultiple) {
                String gt = field.getGenericType();
                String[] strs = gt.split("<");
                if (strs.length != 2) {
                    String msg = "Illegal field type " + gt + " for multiple references. Expected type is List<T>.";
                    throw new IOException(msg);
                }
                String reftypename = strs[1].substring(0, strs[1].length() - 1);
                reftype = this.jc.create(reftypename);
            } else {
                reftype = fieldtype;
            }
            refmap.put(name, reftype);
            boolean required = annot.required();
            refcontingencymap.put(name, required);
        }
        int size = servicemap.size() + refmap.size();
        InterfaceType[] its = new InterfaceType[size];
        int i = 0;
        for (String name : servicemap.keySet()) {
            service = (Class)servicemap.get(name);
            signature = ((Class)service).getName();
            its[i] = new BasicInterfaceType(name, signature, false, false, false);
            ++i;
        }
        for (String name : refmap.keySet()) {
            service = (UnifiedClass)refmap.get(name);
            signature = service.getName();
            boolean isOptional = (Boolean)refcontingencymap.get(name) == false;
            boolean isCollection = (Boolean)refcardinalitymap.get(name);
            its[i] = new BasicInterfaceType(name, signature, true, isOptional, isCollection);
            ++i;
        }
        BasicComponentType ct = null;
        try {
            ct = new BasicComponentType(its);
        }
        catch (InstantiationException ie) {
            IOException ioe = new IOException();
            ioe.initCause(ie);
            throw ioe;
        }
        String controller = "scaPrimitive";
        Membrane mAnnot = UnifiedClassHelper.getAnnotation(uc, Membrane.class);
        if (mAnnot != null) {
            controller = mAnnot.controller();
            Class<?> controllerDesc = mAnnot.controllerDesc();
            if (controller.equals("") && controllerDesc.equals(Constants.class)) {
                String msg = "Both controller and controllerDesc can not be null in " + mAnnot + " for class " + uc.getName();
                throw new IOException(msg);
            }
            if (!controllerDesc.equals(Constants.class)) {
                Class<?> cl = MembraneHelper.getMembraneDef(mAnnot, uc.getName());
                Membrane mdef = cl.getAnnotation(Membrane.class);
                controller = mdef.desc();
                JuliacConfig jconf = this.jc.getJuliacConfig();
                JulietLoader julietLoader = jconf.getJulietLoader();
                julietLoader.put(controller, cl);
            }
        } else {
            PolicySets psAnnot = UnifiedClassHelper.getAnnotation(uc, PolicySets.class);
            if (psAnnot != null) {
                String[] strs;
                String prefix = "frascati:";
                for (String str : strs = psAnnot.value()) {
                    if (!str.startsWith("frascati:")) continue;
                    controller = str.substring("frascati:".length());
                }
            }
        }
        InitializerClassGenerator<?> icg = this.jc.generate(ct, (Object)controller, (Object)adl);
        String compFactClassName = adl + FACTORY_SUFFIX;
        String superClassName = icg.getTargetClassName();
        EmptySubClassGenerator cg = new EmptySubClassGenerator(compFactClassName, superClassName);
        this.jc.generateSourceCode(cg);
    }
}

