/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel.test.examples.definitions;

import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.BPELCompilerImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.BPELStaticAnalysisImpl;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.BPELValidator;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResult;
import com.ebmwebsourcing.easybpel.model.bpel.tools.validator.ValidatorResultPrinter;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.BPELGenerator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.compiler.validation.Error;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import junit.framework.Assert;
import org.w3c.dom.Document;

public class AbstractBPELGeneratorTest {
    public static void testBPELGeneration(String defsPath, String outputPath, int expectedNumberOfProcess) throws XmlObjectReadException, BPMNException, CoreException, URISyntaxException {
        File dir = new File(outputPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.listFiles() != null) {
            for (File f : dir.listFiles()) {
                f.delete();
            }
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource(defsPath);
        Definitions definitions = (Definitions)new XmlContextFactory().newContext().createReader().readDocument(url, Definitions.class);
        Assert.assertNotNull((Object)definitions);
        try {
            definitions.getXmlContext().createValidator().failFastValidate((XmlObject)definitions);
        }
        catch (XmlObjectValidationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        BPELGenerator bpelGen = new BPELGenerator();
        List procs = bpelGen.generate(definitions, outputPath);
        Assert.assertEquals((int)expectedNumberOfProcess, (int)procs.size());
        File outputDir = new File(outputPath);
        for (File f : outputDir.listFiles()) {
            if (!f.getName().endsWith(".bpel")) continue;
            BPELProcess proc = BPELFactoryImpl.getInstance().newBPELReader().readBPEL(f.toURI());
            Document doc = BPELFactoryImpl.getInstance().newBPELWriter().getDocument(proc);
            System.out.println("bpel: \n" + XMLPrettyPrinter.prettyPrint((Document)doc));
            BPELValidator validator = new BPELValidator();
            ValidatorResult result = validator.validate(proc);
            System.out.println(ValidatorResultPrinter.getInstance().printAll(result));
            System.out.println("XPath Links:");
            System.out.println(ValidatorResultPrinter.getInstance().printAllXPathExpression(result));
            Assert.assertEquals((int)0, (int)result.getWarnings().size());
            Assert.assertEquals((int)0, (int)result.getErrors().size());
        }
        BPELCompilerImpl compiler = new BPELCompilerImpl();
        for (BPELProcess proc : procs) {
            URI uri = new URI(outputPath + "/" + proc.getName() + ".bpel");
            compiler.validate(uri);
            for (Error err : BPELStaticAnalysisImpl.getInstance().getErrors()) {
                System.out.println(err.getError().getMessage());
            }
            Assert.assertEquals((int)0, (int)BPELStaticAnalysisImpl.getInstance().getErrors().size());
        }
    }
}

