/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel.test.unit.activity.service;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.ImportType;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Error;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Message;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Operation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.RootElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TItemKind;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.AbstractWSDLGenerator;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.WSDLGeneratorHelper;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BPELServiceGeneratorTest {
    private XmlContext context;

    @Before
    public void init() throws Exception {
        this.context = new XmlContextFactory().newContext();
    }

    @Test
    public void testMessage() throws BPMNException, XmlObjectWriteException {
        com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions definitions = (com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions)this.context.getXmlObjectFactory().create(com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions.class);
        definitions.setTargetNamespace("http://easybpmn.com");
        definitions.setTypeLanguage("http://www.w3.org/2001/XMLSchema");
        Schema schema = (Schema)this.context.getXmlObjectFactory().create(Schema.class);
        schema.setTargetNamespace("http://easybpmn.com/schema");
        Element element = (Element)this.context.getXmlObjectFactory().create(Element.class);
        element.setType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        element.setName("elementName");
        schema.addElement(element);
        Import i = (Import)this.context.getXmlObjectFactory().create(Import.class);
        i.setImportType(ImportType.XSD.getValue());
        i.setNamespace(schema.getTargetNamespace());
        i.setImportContent((XmlObject)schema);
        definitions.addImport(i);
        Interface itf = (Interface)this.context.getXmlObjectFactory().create(Interface.class);
        definitions.addRootElement((RootElement)itf);
        itf.setName("MyItf");
        ItemDefinition itemDefinition = (ItemDefinition)this.context.getXmlObjectFactory().create(ItemDefinition.class);
        itemDefinition.setId("idItemDefinition");
        itemDefinition.setItemKind(TItemKind.Information);
        itemDefinition.setIsCollection(true);
        itemDefinition.setStructureRef(new QName(schema.getTargetNamespace(), element.getName()));
        definitions.addRootElement((RootElement)itemDefinition);
        Operation operation = (Operation)this.context.getXmlObjectFactory().create(Operation.class);
        itf.addOperation(operation);
        operation.setName("MyOperation");
        operation.setId("MyOperation");
        Message message = (Message)this.context.getXmlObjectFactory().create(Message.class);
        definitions.addRootElement((RootElement)message);
        message.setId("MyMessageIn");
        message.setName("MyMessageIn");
        message.setItemRef(new QName(itemDefinition.getId()));
        operation.setInMessageRef(new QName(message.getId()));
        itf.addOperation(operation);
        GenerationProperties gp = new GenerationProperties(definitions);
        WSDLGeneratorHelper.init();
        Definitions des = AbstractWSDLGenerator.generateAbstractWSDL((Interface)itf, (GenerationProperties)gp);
        Assert.assertEquals((Object)message.getName(), (Object)des.getPortTypes()[0].getOperations()[0].getInput().getName());
        com.ebmwebsourcing.easywsdl11.api.element.Message wsdlMsg = des.getMessageByName(des.getPortTypes()[0].getOperations()[0].getInput().getMessage().getLocalPart());
        Assert.assertEquals((Object)element.getName(), (Object)wsdlMsg.getParts()[0].getName());
        this.context.createWriter().writeDocument((XmlObject)des, (OutputStream)System.out);
    }

    @Test
    public void testInterfaceOperation() throws BPMNException, XmlObjectWriteException {
        com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions definitions = (com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions)this.context.getXmlObjectFactory().create(com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions.class);
        definitions.setTargetNamespace("http://easybpmn.com");
        definitions.setTypeLanguage("http://www.w3.org/2001/XMLSchema");
        Schema schema = (Schema)this.context.getXmlObjectFactory().create(Schema.class);
        schema.setTargetNamespace("http://easybpmn.com/schema");
        Element element = (Element)this.context.getXmlObjectFactory().create(Element.class);
        element.setType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        element.setName("elementName");
        schema.addElement(element);
        Import i = (Import)this.context.getXmlObjectFactory().create(Import.class);
        i.setImportType(ImportType.XSD.getValue());
        i.setNamespace(schema.getTargetNamespace());
        i.setImportContent((XmlObject)schema);
        definitions.addImport(i);
        Participant participant = (Participant)this.context.getXmlObjectFactory().create(Participant.class);
        Interface itf = (Interface)this.context.getXmlObjectFactory().create(Interface.class);
        definitions.addRootElement((RootElement)itf);
        itf.setId("MyItf");
        itf.setName("MyItf");
        participant.addInterfaceRef(new QName(itf.getId()));
        ItemDefinition itemDefinition = (ItemDefinition)this.context.getXmlObjectFactory().create(ItemDefinition.class);
        itemDefinition.setId("idItemDefinition");
        itemDefinition.setItemKind(TItemKind.Information);
        itemDefinition.setIsCollection(true);
        itemDefinition.setStructureRef(new QName(schema.getTargetNamespace(), element.getName()));
        Operation operation = (Operation)this.context.getXmlObjectFactory().create(Operation.class);
        itf.addOperation(operation);
        operation.setName("MyOperationName");
        operation.setId("MyOperation");
        itf.addOperation(operation);
        Message messageIn = (Message)this.context.getXmlObjectFactory().create(Message.class);
        messageIn.setName("MyMessageIn");
        messageIn.setId("MyMessageIn");
        operation.setInMessageRef(new QName(messageIn.getId()));
        messageIn.setItemRef(new QName(itemDefinition.getId()));
        definitions.addRootElement((RootElement)messageIn);
        Message messageOut = (Message)this.context.getXmlObjectFactory().create(Message.class);
        messageOut.setName("MyMessageOut");
        messageOut.setId("MyMessageOut");
        operation.setOutMessageRef(new QName(messageOut.getId()));
        definitions.addRootElement((RootElement)messageOut);
        Element elementError = (Element)this.context.getXmlObjectFactory().create(Element.class);
        elementError.setRef(new QName("elementRef"));
        elementError.setType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        Error messageError = (Error)this.context.getXmlObjectFactory().create(Error.class);
        messageError.setName("ErrorName");
        messageError.setId("Error");
        messageError.setStructureRef(new QName(schema.getTargetNamespace(), element.getName()));
        operation.addErrorRef(new QName(messageError.getId()));
        definitions.addRootElement((RootElement)messageError);
        GenerationProperties gp = new GenerationProperties(definitions);
        WSDLGeneratorHelper.init();
        Definitions des = AbstractWSDLGenerator.generateAbstractWSDL((Interface)itf, (GenerationProperties)gp);
        Assert.assertEquals((Object)itf.getName(), (Object)des.getPortTypes()[0].getName());
        Assert.assertEquals((Object)operation.getName(), (Object)des.getPortTypes()[0].getOperations()[0].getName());
        Assert.assertEquals((Object)messageIn.getName(), (Object)des.getPortTypes()[0].getOperations()[0].getInput().getName());
        Assert.assertEquals((Object)messageOut.getName(), (Object)des.getPortTypes()[0].getOperations()[0].getOutput().getName());
        Assert.assertEquals((Object)messageError.getName(), (Object)des.getPortTypes()[0].getOperations()[0].getFaults()[0].getName());
        this.context.createWriter().writeDocument((XmlObject)des, (OutputStream)System.out);
    }
}

