/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel.test.unit.activity.task;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Empty;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.executable.ObjectFactory;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TEmpty;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInvoke;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReceive;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSequence;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.SequenceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.compiler.validation.validator.ValidatorManagerImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.inout.BPELWriterImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.ImportType;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Message;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Operation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.PartnerRole;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ReceiveTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.RootElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SendTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ServiceTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Task;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.BPELGenerator;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.BPELGeneratorHelper;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.PartnerLinkTypeGenerator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import java.net.URI;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BPELTaskGeneratorTest {
    private static DocumentBuilderFactory domFactory;
    private static ObjectFactory bpelFactory;
    private static XmlContext context;
    static Sequence seq;
    static GenerationProperties gp;
    static Participant participant;
    static PartnerRole role;
    static Operation operation;
    static Interface itf;
    static String inputVariableName;
    static String outputVariableName;

    @BeforeClass
    public static void init() throws Exception {
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        ValidatorManagerImpl.getInstance();
        domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        bpelFactory = new ObjectFactory();
        context = new XmlContextFactory().newContext();
        seq = new SequenceImpl(new TSequence(), null);
        Definitions definitions = (Definitions)context.getXmlObjectFactory().create(Definitions.class);
        definitions.setId("defsID");
        definitions.setTargetNamespace("http://TNS");
        gp = new GenerationProperties(definitions);
        Import impt = (Import)context.getXmlObjectFactory().create(Import.class);
        impt.setImportType(ImportType.XSD.getValue());
        impt.setNamespace("imptNS");
        definitions.addImport(impt);
        Schema s = (Schema)context.getXmlObjectFactory().create(Schema.class);
        impt.setImportContent((XmlObject)s);
        s.setTargetNamespace(impt.getNamespace());
        Element elt = (Element)context.getXmlObjectFactory().create(Element.class);
        elt.setName("structure");
        elt.setType(new QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        s.addElement(elt);
        participant = (Participant)context.getXmlObjectFactory().create(Participant.class);
        participant.setName("MyPartner");
        participant.setId("MyPartnerId");
        gp.setCurrentParticipant(participant);
        role = (PartnerRole)context.getXmlObjectFactory().create(PartnerRole.class);
        role.setId("MyRoleId");
        role.setName("MyRoleName");
        role.addParticipantRef(new QName(participant.getId()));
        definitions.addRootElement((RootElement)role);
        Collaboration c = (Collaboration)context.getXmlObjectFactory().create(Collaboration.class);
        c.setName("collName");
        c.setId("collId");
        c.addParticipant(participant);
        definitions.addRootElement((RootElement)c);
        itf = (Interface)context.getXmlObjectFactory().create(Interface.class);
        itf.setName("MyItf");
        itf.setId("MyItf");
        definitions.addRootElement((RootElement)itf);
        operation = (Operation)context.getXmlObjectFactory().create(Operation.class);
        operation.setName("MyOperation");
        operation.setId("MyOperation");
        itf.addOperation(operation);
        ItemDefinition itemDef = (ItemDefinition)context.getXmlObjectFactory().create(ItemDefinition.class);
        itemDef.setId("itemDefId");
        itemDef.setStructureRef(new QName(impt.getNamespace(), elt.getName()));
        definitions.addRootElement((RootElement)itemDef);
        Message msgIn = (Message)context.getXmlObjectFactory().create(Message.class);
        msgIn.setId("msgInId");
        msgIn.setName("msgIn");
        msgIn.setItemRef(new QName(itemDef.getId()));
        operation.setInMessageRef(new QName(msgIn.getId()));
        definitions.addRootElement((RootElement)msgIn);
        Message msgOut = (Message)context.getXmlObjectFactory().create(Message.class);
        msgOut.setId("msgOutId");
        msgOut.setName("msgOut");
        msgOut.setItemRef(new QName(itemDef.getId()));
        operation.setOutMessageRef(new QName(msgOut.getId()));
        definitions.addRootElement((RootElement)msgOut);
        participant.addInterfaceRef(new QName(itf.getId()));
        BPELProcessImpl bp = new BPELProcessImpl(URI.create("bpel"), new TProcess(), null, null);
        gp.setBpelProcess((BPELProcess)bp);
        inputVariableName = BPELGeneratorHelper.getVariableName((String)msgIn.getName());
        outputVariableName = BPELGeneratorHelper.getVariableName((String)msgOut.getName());
        com.ebmwebsourcing.easywsdl11.api.element.Definitions wsdlDefs = (com.ebmwebsourcing.easywsdl11.api.element.Definitions)context.getXmlObjectFactory().create(com.ebmwebsourcing.easywsdl11.api.element.Definitions.class);
        wsdlDefs.setTargetNamespace("wsdlNS");
        PartnerLinkTypeGenerator.generatePartnerLinkType((Interface)itf, (Participant)participant, (com.ebmwebsourcing.easywsdl11.api.element.Definitions)wsdlDefs, (GenerationProperties)gp);
    }

    private void printBpelElement(Object bpelElement) throws ParserConfigurationException, JAXBException, BPELException {
        Document doc = domFactory.newDocumentBuilder().newDocument();
        ((BPELWriterImpl)BPELFactoryImpl.getInstance().newBPELWriter()).getJaxbContext().createMarshaller().marshal(bpelElement, (Node)doc);
        System.out.println(XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    @Test
    public void testServiceTask() throws BPMNException, BPELException, ParserConfigurationException, JAXBException {
        ServiceTask serviceTask = (ServiceTask)context.getXmlObjectFactory().create(ServiceTask.class);
        serviceTask.setName("MyService");
        serviceTask.setOperationRef(new QName(operation.getId()));
        BPELGenerator gen = new BPELGenerator();
        gen.generatePartnerLinks(participant, gp);
        Invoke invoke = (Invoke)gen.generateActivity((FlowElement)serviceTask, (Activity)seq, gp);
        Assert.assertEquals((Object)serviceTask.getName(), (Object)invoke.getName());
        Assert.assertEquals((Object)operation.getName(), (Object)invoke.getOperation());
        Assert.assertEquals((Object)participant.getInterfaceRef()[0].getLocalPart(), (Object)invoke.getInterface().getLocalPart());
        Assert.assertEquals((Object)inputVariableName, (Object)invoke.getInputVariable());
        Assert.assertEquals((Object)outputVariableName, (Object)invoke.getOutputVariable());
        this.printBpelElement(bpelFactory.createInvoke((TInvoke)((AbstractSchemaElementImpl)invoke).getModel()));
    }

    @Test
    public void testReceiveTask() throws BPMNException, BPELException, ParserConfigurationException, JAXBException {
        ReceiveTask receiveTask = (ReceiveTask)context.getXmlObjectFactory().create(ReceiveTask.class);
        receiveTask.setName("Mytask");
        receiveTask.setInstantiate(true);
        receiveTask.setOperationRef(new QName(operation.getId()));
        BPELGenerator gen = new BPELGenerator();
        gen.generatePartnerLinks(participant, gp);
        Receive receive = (Receive)gen.generateActivity((FlowElement)receiveTask, (Activity)seq, gp);
        Assert.assertEquals((Object)receiveTask.getName(), (Object)receive.getName());
        Assert.assertEquals((Object)receiveTask.isInstantiate(), (Object)receive.getCreateInstance());
        Assert.assertEquals((Object)operation.getName(), (Object)receive.getOperation());
        Assert.assertEquals((Object)itf.getName(), (Object)receive.getInterface().getLocalPart());
        Assert.assertEquals((Object)inputVariableName, (Object)receive.getInputVariable());
        this.printBpelElement(bpelFactory.createReceive((TReceive)((AbstractSchemaElementImpl)receive).getModel()));
    }

    @Test
    public void testSendTask() throws BPMNException, BPELException, ParserConfigurationException, JAXBException {
        SendTask sendTask = (SendTask)context.getXmlObjectFactory().create(SendTask.class);
        sendTask.setName("MyTask");
        sendTask.setOperationRef(new QName(operation.getId()));
        participant.setName("MyPartner");
        BPELGenerator gen = new BPELGenerator();
        gen.generatePartnerLinks(participant, gp);
        Reply sendInvoke = (Reply)gen.generateActivity((FlowElement)sendTask, (Activity)seq, gp);
        Assert.assertEquals((Object)sendTask.getName(), (Object)sendInvoke.getName());
        Assert.assertEquals((Object)itf.getName(), (Object)sendInvoke.getInterface().getLocalPart());
        Assert.assertEquals((Object)operation.getName(), (Object)sendInvoke.getOperation());
        Assert.assertNotNull((Object)sendInvoke.getOutputVariable());
        Assert.assertEquals((Object)outputVariableName, (Object)sendInvoke.getOutputVariable());
    }

    @Test
    public void testAbstractTask() throws BPMNException, BPELException, ParserConfigurationException, JAXBException {
        Task abstractTask = (Task)context.getXmlObjectFactory().create(Task.class);
        abstractTask.setName("MyTask");
        Empty empty = (Empty)new BPELGenerator().generateActivity((FlowElement)abstractTask, (Activity)seq, gp);
        this.printBpelElement(bpelFactory.createEmpty((TEmpty)((AbstractSchemaElementImpl)empty).getModel()));
        Assert.assertEquals((Object)abstractTask.getName(), (Object)empty.getName());
    }
}

