/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel.test.unit.process.event;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSequence;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.SequenceImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.ImportType;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EndEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Lane;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.LaneSet;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Message;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.MessageEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Operation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.PartnerRole;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Process;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ReceiveTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.RootElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.StartEvent;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithFlowElements;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.BPELGenerator;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.BPELGeneratorHelper;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.PartnerLinkTypeGenerator;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class BPELEventGeneratorTest {
    private XmlContext context;
    private Definitions definitions;
    private Lane lane;
    private Process process;
    private Message message;
    private ItemDefinition itemDef;
    private Operation operation;
    private Interface itf;
    private Participant participant;
    private String variableName;

    @Before
    public void init() throws Exception {
        this.context = new XmlContextFactory().newContext();
        this.definitions = (Definitions)this.context.getXmlObjectFactory().create(Definitions.class);
        this.definitions.setTargetNamespace("http://TNS");
        Collaboration c = (Collaboration)this.context.getXmlObjectFactory().create(Collaboration.class);
        this.definitions.addRootElement((RootElement)c);
        c.setId("collId");
        c.setName("collName");
        this.process = (Process)this.context.getXmlObjectFactory().create(Process.class);
        this.process.setName("MyProcess");
        this.process.setId("MyProcess");
        this.definitions.addRootElement((RootElement)this.process);
        this.participant = (Participant)this.context.getXmlObjectFactory().create(Participant.class);
        this.participant.setId("MyPartner");
        this.participant.setName("MyPartner");
        this.participant.setProcessRef(new QName(this.process.getId()));
        c.addParticipant(this.participant);
        PartnerRole role = (PartnerRole)this.context.getXmlObjectFactory().create(PartnerRole.class);
        role.setId("MyRoleId");
        role.setName("MyRoleName");
        role.addParticipantRef(new QName(this.participant.getId()));
        this.definitions.addRootElement((RootElement)role);
        LaneSet laneSet = (LaneSet)this.context.getXmlObjectFactory().create(LaneSet.class);
        this.process.addLaneSet(laneSet);
        this.lane = (Lane)this.context.getXmlObjectFactory().create(Lane.class);
        laneSet.addLane(this.lane);
        this.itemDef = (ItemDefinition)this.context.getXmlObjectFactory().create(ItemDefinition.class);
        this.itemDef.setId("itemDefId");
        this.itemDef.setStructureRef(new QName("tns", "lp"));
        this.definitions.addRootElement((RootElement)this.itemDef);
        this.message = (Message)this.context.getXmlObjectFactory().create(Message.class);
        this.message.setName("MyMessage");
        this.message.setId("MyMessage");
        this.message.setItemRef(new QName(this.itemDef.getId()));
        this.definitions.addRootElement((RootElement)this.message);
        this.itf = (Interface)this.context.getXmlObjectFactory().create(Interface.class);
        this.itf.setName("MyItfName");
        this.itf.setId("MyItf");
        this.participant.addInterfaceRef(new QName(this.itf.getId()));
        this.definitions.addRootElement((RootElement)this.itf);
        this.operation = (Operation)this.context.getXmlObjectFactory().create(Operation.class);
        this.operation.setName("MyOperationName");
        this.operation.setId("MyOperation");
        this.operation.setInMessageRef(new QName(this.message.getId()));
        this.itf.addOperation(this.operation);
        this.variableName = BPELGeneratorHelper.getVariableName((String)this.message.getName());
        Schema s = (Schema)this.context.getXmlObjectFactory().create(Schema.class);
        s.setTargetNamespace(this.itemDef.getStructureRef().getNamespaceURI());
        Element elt = (Element)this.context.getXmlObjectFactory().create(Element.class);
        elt.setName(this.itemDef.getStructureRef().getLocalPart());
        s.addElement(elt);
        Import impt = (Import)this.context.getXmlObjectFactory().create(Import.class);
        impt.setNamespace(this.itemDef.getStructureRef().getNamespaceURI());
        impt.setImportType(ImportType.XSD.getValue());
        impt.setImportContent((XmlObject)s);
        this.definitions.addImport(impt);
    }

    @Test
    public void testEmptyStartEvent() throws BPMNException, BPELException {
        StartEvent startEvent = (StartEvent)this.context.getXmlObjectFactory().create(StartEvent.class);
        startEvent.setName("MyStartEvent");
        this.lane.addFlowNodeRef((FlowNode)startEvent);
        this.process.addFlowElement((FlowElement)startEvent);
        ReceiveTask receiveTask = (ReceiveTask)this.context.getXmlObjectFactory().create(ReceiveTask.class);
        receiveTask.setName("Mytask");
        receiveTask.setInstantiate(true);
        this.lane.addFlowNodeRef((FlowNode)receiveTask);
        this.process.addFlowElement((FlowElement)receiveTask);
        SequenceFlow sequenceFlow = (SequenceFlow)this.context.getXmlObjectFactory().create(SequenceFlow.class);
        sequenceFlow.setName("MySequenceFlow");
        sequenceFlow.setSourceRef((FlowNode)startEvent);
        sequenceFlow.setTargetRef((FlowNode)receiveTask);
        this.process.addFlowElement((FlowElement)sequenceFlow);
        receiveTask.setMessageRef(new QName(this.message.getId()));
        receiveTask.setOperationRef(new QName(this.operation.getId()));
        GenerationProperties gp = new GenerationProperties(this.definitions);
        BPELProcessImpl bp = new BPELProcessImpl(URI.create("bpel"), new TProcess(), null, null);
        gp.setBpelProcess((BPELProcess)bp);
        Set s = BPELGeneratorHelper.getAllStartingNodes((Process)this.process);
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((long)1L, (long)s.size());
        Assert.assertEquals((Object)startEvent, s.iterator().next());
        List l = new BPELGenerator().detectAllStartingNodes((WithFlowElements)this.process, gp);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)1L, (long)l.size());
        Assert.assertEquals((Object)receiveTask, l.get(0));
        com.ebmwebsourcing.easywsdl11.api.element.Definitions wsdlDefs = (com.ebmwebsourcing.easywsdl11.api.element.Definitions)this.context.getXmlObjectFactory().create(com.ebmwebsourcing.easywsdl11.api.element.Definitions.class);
        wsdlDefs.setTargetNamespace("wsdlNS");
        PartnerLinkTypeGenerator.generatePartnerLinkType((Interface)this.itf, (Participant)this.participant, (com.ebmwebsourcing.easywsdl11.api.element.Definitions)wsdlDefs, (GenerationProperties)gp);
        BPELGenerator gen = new BPELGenerator();
        gen.generatePartnerLinks(this.participant, gp);
        Receive receive = (Receive)gen.generateActivity((FlowElement)receiveTask, (Activity)new SequenceImpl(new TSequence(), null), gp);
        Assert.assertNotNull((Object)receive);
        Assert.assertEquals((Object)this.itf.getName(), (Object)receive.getInterface().getLocalPart());
        Assert.assertEquals((Object)this.operation.getName(), (Object)receive.getOperation());
        Assert.assertEquals((Object)receiveTask.getName(), (Object)receive.getName());
        Assert.assertEquals((Object)this.variableName, (Object)receive.getInputVariable());
        List procs = gen.generate(this.definitions);
        Assert.assertEquals((long)1L, (long)procs.size());
        Document doc = BPELFactoryImpl.getInstance().newBPELWriter().getDocument((BPELProcess)procs.get(0));
        System.out.println("bpel: \n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    @Test
    public void testMessageStartEvent() throws BPMNException, BPELException {
        StartEvent startEvent = (StartEvent)this.context.getXmlObjectFactory().create(StartEvent.class);
        startEvent.setName("MyStartEvent");
        MessageEventDefinition med = (MessageEventDefinition)this.context.getXmlObjectFactory().create(MessageEventDefinition.class);
        med.setMessageRef(new QName(this.message.getId()));
        med.setOperationRef(new QName(this.operation.getId()));
        startEvent.addEventDefinition((EventDefinition)med);
        this.process.addFlowElement((FlowElement)startEvent);
        ReceiveTask receiveTask = (ReceiveTask)this.context.getXmlObjectFactory().create(ReceiveTask.class);
        receiveTask.setName("Mytask");
        receiveTask.setInstantiate(true);
        receiveTask.setMessageRef(new QName(this.message.getId()));
        receiveTask.setOperationRef(new QName(this.operation.getId()));
        this.lane.addFlowNodeRef((FlowNode)receiveTask);
        this.process.addFlowElement((FlowElement)receiveTask);
        SequenceFlow sf1 = (SequenceFlow)this.context.getXmlObjectFactory().create(SequenceFlow.class);
        sf1.setId("sf1");
        sf1.setSourceRef((FlowNode)startEvent);
        sf1.setTargetRef((FlowNode)receiveTask);
        this.process.addFlowElement((FlowElement)sf1);
        EndEvent endEvent = (EndEvent)this.context.getXmlObjectFactory().create(EndEvent.class);
        endEvent.setId("eeId");
        this.process.addFlowElement((FlowElement)endEvent);
        SequenceFlow sf2 = (SequenceFlow)this.context.getXmlObjectFactory().create(SequenceFlow.class);
        sf2.setId("sf2");
        sf2.setSourceRef((FlowNode)receiveTask);
        sf2.setTargetRef((FlowNode)endEvent);
        this.process.addFlowElement((FlowElement)sf2);
        GenerationProperties gp = new GenerationProperties(this.definitions);
        BPELProcessImpl bp = new BPELProcessImpl(URI.create("bpel"), new TProcess(), null, null);
        gp.setBpelProcess((BPELProcess)bp);
        List l = new BPELGenerator().detectAllStartingNodes((WithFlowElements)this.process, gp);
        Assert.assertNotNull((Object)l);
        Assert.assertEquals((long)1L, (long)l.size());
        Assert.assertEquals((Object)startEvent, l.get(0));
        com.ebmwebsourcing.easywsdl11.api.element.Definitions wsdlDefs = (com.ebmwebsourcing.easywsdl11.api.element.Definitions)this.context.getXmlObjectFactory().create(com.ebmwebsourcing.easywsdl11.api.element.Definitions.class);
        wsdlDefs.setTargetNamespace("wsdlNS");
        PartnerLinkTypeGenerator.generatePartnerLinkType((Interface)this.itf, (Participant)this.participant, (com.ebmwebsourcing.easywsdl11.api.element.Definitions)wsdlDefs, (GenerationProperties)gp);
        BPELGenerator gen = new BPELGenerator();
        gen.generatePartnerLinks(this.participant, gp);
        Receive receive = (Receive)gen.generateActivity((FlowElement)startEvent, (Activity)new SequenceImpl(new TSequence(), null), gp);
        Assert.assertNotNull((Object)receive);
        Assert.assertEquals((Object)this.itf.getName(), (Object)receive.getInterface().getLocalPart());
        Assert.assertEquals((Object)this.operation.getName(), (Object)receive.getOperation());
        Assert.assertEquals((Object)startEvent.getName(), (Object)receive.getName());
        Assert.assertEquals((Object)this.variableName, (Object)receive.getInputVariable());
        List procs = gen.generate(this.definitions);
        Assert.assertEquals((long)1L, (long)procs.size());
        Document doc = BPELFactoryImpl.getInstance().newBPELWriter().getDocument((BPELProcess)procs.get(0));
        System.out.println("bpel: \n" + XMLPrettyPrinter.prettyPrint((Document)doc));
        BPELProcess proc = (BPELProcess)procs.get(0);
        Sequence mainSeq = (Sequence)proc.getActivity();
        Assert.assertEquals((long)2L, (long)mainSeq.getActivities().size());
        Receive r1 = (Receive)mainSeq.getActivities().get(0);
        Assert.assertEquals((Object)startEvent.getName(), (Object)r1.getName());
        Receive r2 = (Receive)mainSeq.getActivities().get(1);
        Assert.assertEquals((Object)receiveTask.getName(), (Object)r2.getName());
    }
}

