/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.model.bpmn.tools.bpmn2bpel;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.BPMNException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.ow2.easywsdl.schema.SchemaFactoryImpl;
import org.ow2.easywsdl.schema.api.Import;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.util.XMLPrettyPrinter;
import org.ow2.easywsdl.wsdl.WSDLFactoryImpl;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Types;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.decorator.Decorator;
import org.w3c.dom.Document;

public class BPELFileWriter {
    public void write(List<BPELProcess> processes, String directoryPath) throws BPMNException {
        try {
            File dir = new File(directoryPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            for (BPELProcess process : processes) {
                File processDir = new File(directoryPath + "/" + process.getName());
                processDir.mkdir();
                Document bpel = BPELFactoryImpl.getInstance().newBPELWriter().getDocument(process);
                this.writeDocument(directoryPath + "/" + process.getName() + "/" + process.getName() + ".bpel", bpel);
                this.writeAllBPELImports(directoryPath + "/" + process.getName() + "/", process.getImports().getBPELImports());
            }
        }
        catch (BPELException e) {
            throw new BPMNException((Throwable)e);
        }
        catch (SchemaException e) {
            throw new BPMNException((Throwable)e);
        }
    }

    private void writeAllBPELImports(String path, List<com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import> imports) throws SchemaException {
        for (com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import impt : imports) {
            if (impt.getSchema() != null) {
                Schema schema = impt.getSchema();
                this.writeSchema(path, impt.getLocation().toString().substring(impt.getLocation().toString().lastIndexOf("/") + 1, impt.getLocation().toString().length()), schema);
                continue;
            }
            if (impt.getDescription() == null) continue;
            org.ow2.easywsdl.extensions.wsdl4bpel.api.Description desc = impt.getDescription();
            this.writeDescription(path, impt.getLocation().toString().substring(impt.getLocation().toString().lastIndexOf("/") + 1, impt.getLocation().toString().length()), (AbsItfDescription)desc);
        }
    }

    private void writeAllSchemaImports(String path, List<Import> importedSchemas) throws SchemaException {
        for (Import impt : importedSchemas) {
            this.writeSchema(path, impt.getLocationURI().toString().substring(impt.getLocationURI().toString().lastIndexOf("/") + 1, impt.getLocationURI().toString().length()), (Schema)impt.getSchema());
        }
    }

    private void writeAllWSDLImports(String path, List<org.ow2.easywsdl.wsdl.api.Import> imports) throws SchemaException {
        for (org.ow2.easywsdl.wsdl.api.Import impt : imports) {
            this.writeDescription(path, impt.getLocationURI().toString().substring(impt.getLocationURI().toString().lastIndexOf("/") + 1, impt.getLocationURI().toString().length()), impt.getDescription());
        }
    }

    private void writeDescription(String path, String fileName, AbsItfDescription desc) throws SchemaException {
        Description desc2print = null;
        desc2print = desc instanceof org.ow2.easywsdl.extensions.wsdl4bpel.api.Description ? (Description)((Decorator)desc).getInternalObject() : (Description)desc;
        Document wsdl = WSDLFactoryImpl.newInstance().newWSDLWriter().getDocument(desc2print);
        this.writeDocument(path + "/" + fileName, wsdl);
        this.writeAllWSDLImports(path, desc2print.getImports());
        this.writeAllSchemaImports(path, ((Types)desc2print.getTypes()).getImportedSchemas());
        for (Schema s : ((Types)desc2print.getTypes()).getSchemas()) {
            this.writeAllSchemaImports(path, s.getImports());
        }
    }

    private void writeSchema(String path, String fileName, Schema schema) throws SchemaException {
        Document xsd = SchemaFactoryImpl.newInstance().newSchemaWriter().getDocument(schema);
        this.writeDocument(path + "/" + fileName, xsd);
        this.writeAllSchemaImports(path, schema.getImports());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument(String fileName, Document bpel) {
        FileWriter writer = null;
        if (!new File(fileName).exists()) {
            try {
                writer = new FileWriter(fileName, true);
                writer.write(XMLPrettyPrinter.prettyPrint((Document)bpel));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public static boolean deleteDirectory(File path) {
        boolean resultat = true;
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    resultat &= BPELFileWriter.deleteDirectory(files[i]);
                    continue;
                }
                resultat &= files[i].delete();
            }
        }
        return resultat &= path.delete();
    }
}

