/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class ForkPatternTest {
    @Test
    public void testForkWithoutChildPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        Node initial = CreationPatternFactory.getInstance().createForkPattern("fork", null, (Scope)process);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        execution.runStepByStep();
        Assert.assertEquals((String)"node_supporting_fork", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_fork", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testForkWithOneChildPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createForkPattern("fork", childNodes, (Scope)process);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_fork", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_first", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_fork", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Ignore(value="Unpredictable test... FIXME")
    public void testForkWithTwoChildPattern() throws CoreException, NoSuchInterfaceException, InterruptedException, IOException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("second", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createForkPattern("fork", childNodes, (Scope)process);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"node_supporting_fork", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Execution childExecution1 = (Execution)execution.getChildExecutions().get(0);
        Execution childExecution2 = (Execution)execution.getChildExecutions().get(1);
        Assert.assertEquals((String)"node_supporting_first", (String)childExecution1.getCurrentTarget().getName());
        Assert.assertEquals((String)"node_supporting_second", (String)childExecution2.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)childExecution1.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)childExecution2.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        childExecution1.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)childExecution1.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        execution.signal();
        Assert.assertEquals((int)1, (int)execution.getChildExecutions().size());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        childExecution2.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)childExecution2.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution.getState());
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
    }

    @Test
    @Ignore(value="Unpredictable test... FIXME")
    public void testForkWithTwoChildPatternDifferentSteppingOrder() throws CoreException, NoSuchInterfaceException, InterruptedException, IOException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("second", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createForkPattern("fork", childNodes, (Scope)process);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        execution.runStepByStep();
        execution.signal();
        Assert.assertEquals((String)"fork", (String)process.getParentExecution().getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Execution childExecution1 = (Execution)execution.getChildExecutions().get(0);
        Execution childExecution2 = (Execution)execution.getChildExecutions().get(1);
        Assert.assertEquals((String)"node_supporting_first", (String)childExecution1.getCurrentTarget().getName());
        Assert.assertEquals((String)"node_supporting_second", (String)childExecution2.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)childExecution1.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)childExecution2.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        childExecution1.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)childExecution1.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        childExecution2.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)childExecution2.getState());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        execution.signal();
        Assert.assertEquals((int)1, (int)execution.getChildExecutions().size());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)execution.getState());
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
    }

    @Test
    public void testForkWithTwoChildAndAroundNodePattern() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("first", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("second", EmptyBehaviourImpl.class, null));
        Node initial = process.createNode("start", EmptyBehaviourImpl.class, null);
        Node fork = CreationPatternFactory.getInstance().createForkPattern("fork", childNodes, (Scope)process);
        Node end = process.createNode("end", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(initial, fork);
        process.linkedBrotherNodes(fork, end);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        execution.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testForkWithUnderForkAndWithTwoChildAndAroundNodePatternStepByStep() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> childNodesFirst = new ArrayList<Node>();
        childNodesFirst.add(process.createNode("childfirst_1", EmptyBehaviourImpl.class, null));
        childNodesFirst.add(process.createNode("childfirst_2", EmptyBehaviourImpl.class, null));
        Node childfork1 = CreationPatternFactory.getInstance().createForkPattern("firstfork", childNodesFirst, (Scope)process);
        ArrayList<Node> childNodesSecond = new ArrayList<Node>();
        childNodesSecond.add(process.createNode("childsecond_1", EmptyBehaviourImpl.class, null));
        childNodesSecond.add(process.createNode("childsecond_2", EmptyBehaviourImpl.class, null));
        Node childfork2 = CreationPatternFactory.getInstance().createForkPattern("secondfork", childNodesSecond, (Scope)process);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(childfork1);
        childNodes.add(childfork2);
        Node initial = process.createNode("start", EmptyBehaviourImpl.class, null);
        Node fork = CreationPatternFactory.getInstance().createForkPattern("fork", childNodes, (Scope)process);
        Node end = process.createNode("end", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(initial, fork);
        process.linkedBrotherNodes(fork, end);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        Assert.assertEquals((Object)Execution.State.INACTIVE, (Object)execution.getState());
        execution.runStepByStep();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertTrue((boolean)(execution.getCurrentTarget() instanceof Node));
        Node currentTarget = execution.getCurrentTarget();
        Assert.assertEquals((String)"node_supporting_start", (String)currentTarget.getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertTrue((boolean)(execution.getCurrentTarget() instanceof Node));
        currentTarget = execution.getCurrentTarget();
        Assert.assertEquals((String)"node_supporting_start", (String)currentTarget.getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertTrue((boolean)(execution.getCurrentTarget() instanceof Node));
        currentTarget = execution.getCurrentTarget();
        Assert.assertEquals((String)"node_supporting_fork", (String)currentTarget.getName());
        Execution firstExecution = (Execution)execution.getChildExecutions().get(0);
        Execution secondExecution = (Execution)execution.getChildExecutions().get(1);
        firstExecution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)firstExecution.getState());
        Assert.assertEquals((int)0, (int)firstExecution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_firstfork", (String)firstExecution.getCurrentTarget().getName());
        secondExecution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)secondExecution.getState());
        Assert.assertEquals((int)0, (int)secondExecution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_secondfork", (String)secondExecution.getCurrentTarget().getName());
        firstExecution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)firstExecution.getState());
        Assert.assertEquals((int)2, (int)firstExecution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_firstfork", (String)firstExecution.getCurrentTarget().getName());
        Execution childFirst1Execution = (Execution)firstExecution.getChildExecutions().get(0);
        Execution childFirst2Execution = (Execution)firstExecution.getChildExecutions().get(1);
        secondExecution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)secondExecution.getState());
        Assert.assertEquals((int)2, (int)secondExecution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_secondfork", (String)secondExecution.getCurrentTarget().getName());
        Execution childSecond1Execution = (Execution)secondExecution.getChildExecutions().get(0);
        Execution childSecond2Execution = (Execution)secondExecution.getChildExecutions().get(1);
        childFirst1Execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)childFirst1Execution.getState());
        Assert.assertEquals((String)"node_supporting_childfirst_1", (String)childFirst1Execution.getCurrentTarget().getName());
        firstExecution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)firstExecution.getState());
        Assert.assertEquals((int)1, (int)firstExecution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_firstfork", (String)firstExecution.getCurrentTarget().getName());
        childFirst2Execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)childFirst2Execution.getState());
        Assert.assertEquals((String)"node_supporting_childfirst_2", (String)childFirst2Execution.getCurrentTarget().getName());
        firstExecution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)2, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)firstExecution.getState());
        Assert.assertEquals((int)0, (int)firstExecution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_firstfork", (String)firstExecution.getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)1, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        childSecond1Execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)childSecond1Execution.getState());
        Assert.assertEquals((String)"node_supporting_childsecond_1", (String)childSecond1Execution.getCurrentTarget().getName());
        secondExecution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)1, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)secondExecution.getState());
        Assert.assertEquals((int)1, (int)secondExecution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_secondfork", (String)secondExecution.getCurrentTarget().getName());
        childSecond2Execution.signal();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)childSecond2Execution.getState());
        Assert.assertEquals((String)"node_supporting_childsecond_2", (String)childSecond2Execution.getCurrentTarget().getName());
        secondExecution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)1, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)secondExecution.getState());
        Assert.assertEquals((int)0, (int)secondExecution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_secondfork", (String)secondExecution.getCurrentTarget().getName());
        execution.signal();
        Assert.assertEquals((Object)Execution.State.ACTIVE, (Object)execution.getState());
        Assert.assertEquals((int)0, (int)execution.getChildExecutions().size());
        Assert.assertEquals((String)"node_supporting_fork", (String)execution.getCurrentTarget().getName());
    }

    @Test
    public void testForkWithUnderForkAndWithTwoChildAndAroundNodePatternRun() throws CoreException, NoSuchInterfaceException, InterruptedException, SCAException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("ForkProcess"), null);
        ArrayList<Node> childNodesFirst = new ArrayList<Node>();
        childNodesFirst.add(process.createNode("childfirst_1", EmptyBehaviourImpl.class, null));
        childNodesFirst.add(process.createNode("childfirst_2", EmptyBehaviourImpl.class, null));
        Node childfork1 = CreationPatternFactory.getInstance().createForkPattern("firstfork", childNodesFirst, (Scope)process);
        ArrayList<Node> childNodesSecond = new ArrayList<Node>();
        childNodesSecond.add(process.createNode("childsecond_1", EmptyBehaviourImpl.class, null));
        childNodesSecond.add(process.createNode("childsecond_2", EmptyBehaviourImpl.class, null));
        Node childfork2 = CreationPatternFactory.getInstance().createForkPattern("secondfork", childNodesSecond, (Scope)process);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(childfork1);
        childNodes.add(childfork2);
        Node initial = process.createNode("start", EmptyBehaviourImpl.class, null);
        Node fork = CreationPatternFactory.getInstance().createForkPattern("fork", childNodes, (Scope)process);
        Node end = process.createNode("end", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(initial, fork);
        process.linkedBrotherNodes(fork, end);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        Execution execution = process.createParentExecution();
        Component exec = SCAHelper.getSCAHelper().getComponentByInterface(process.getComponent(), (Interface)execution, "service");
        SCAHelper.getSCAHelper().startComponent(exec);
        Assert.assertEquals((Object)Execution.State.INACTIVE, (Object)execution.getState());
        execution.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
    }
}

