/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.pattern.creation;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class SequencePatternTest {
    @Test
    public void testSequencePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("sequence"), null);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("start", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("a", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("b", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("c", EmptyBehaviourImpl.class, null));
        Node initial = CreationPatternFactory.getInstance().createSequencePattern("seq", childNodes, (Scope)process);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_seq", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testEmptySequencePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("sequence"), null);
        ArrayList childNodes = new ArrayList();
        Node initial = CreationPatternFactory.getInstance().createSequencePattern("seq", childNodes, (Scope)process);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_seq", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testNullSequencePattern() throws CoreException, NoSuchInterfaceException, InterruptedException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("sequence"), null);
        Node initial = CreationPatternFactory.getInstance().createSequencePattern("seq", null, (Scope)process);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_seq", (String)process.getParentExecution().getCurrentTarget().getName());
    }

    @Test
    public void testSequencePatternWithNodeAround() throws CoreException, NoSuchInterfaceException, InterruptedException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("sequence"), null);
        Node start = process.createNode("start", EmptyBehaviourImpl.class, null);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(process.createNode("a", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("b", EmptyBehaviourImpl.class, null));
        childNodes.add(process.createNode("c", EmptyBehaviourImpl.class, null));
        Node end = process.createNode("end", EmptyBehaviourImpl.class, null);
        Node seq = CreationPatternFactory.getInstance().createSequencePattern("seq", childNodes, (Scope)process);
        process.setInitialNode(start);
        process.linkedBrotherNodes(start, seq);
        process.linkedBrotherNodes(seq, end);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        process.run();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        Assert.assertEquals((String)"node_supporting_end", (String)process.getParentExecution().getCurrentTarget().getName());
    }
}

