/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.WaitBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.DateExpression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.LongExpression;
import com.ebmwebsourcing.easyviper.core.impl.engine.time.WaitingThreadPool;
import java.util.Date;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

@Scope(value="COMPOSITE")
@Service(value={WaitBehaviour.class}, names={"service"})
public class WaitBehaviourImpl
extends AbstractBehaviourImpl
implements WaitBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(WaitBehaviourImpl.class.getName());
    @Property(name="time", required=false)
    private LongExpression<?> time;
    @Property(name="date", required=false)
    private DateExpression<?> date;
    private boolean alreadyWaited;

    public LongExpression<?> getDuration() {
        return this.time;
    }

    public void setDuration(LongExpression<?> time) {
        this.time = time;
    }

    public DateExpression<?> getDate() {
        return this.date;
    }

    public void setDate(DateExpression<?> date) {
        this.date = date;
    }

    public String toString() {
        return "WaitActivity";
    }

    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    public void terminateWaiting() throws CoreException {
        this.alreadyWaited = true;
        this.notifyParentBehaviour();
    }

    protected void executeOnEnded() throws CoreException {
        this.alreadyWaited = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void executeOnInactive() throws CoreException {
        if (this.alreadyWaited) {
            return;
        }
        this.log.finest("start wait behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_STARTED;
        Process process = this.getNode().getExecution().getParentScope().getProcess();
        if (this.time != null) {
            Long time = (Long)this.time.evaluate(this.getNode().getExecution().getParentScope());
            if (time == null) {
                throw new CoreException("Impossible to evaluate long expression: " + this.time.getContent());
            }
            if (time >= 0L) {
                this.log.finest("execute wait behaviour on node: " + this.node.getName() + " => wait during " + time + " ms");
                this.getNode().getExecution().setStateRecursively(Execution.State.SUSPENDED);
                WaitingThreadPool.addWaitingThread(process, this, time);
                return;
            }
            this.state = Behaviour.State.ACTIVITY_ENDED;
            return;
        }
        if (this.date == null) return;
        Date date = (Date)this.date.evaluate(this.getNode().getExecution().getParentScope());
        if (date == null) {
            throw new CoreException("Impossible to evaluate date expression: " + this.date.getContent());
        }
        this.log.finest("execute wait behaviour on node: " + this.node.getName() + " => wait until " + date);
        Long time = date.getTime() - System.currentTimeMillis();
        if (time >= 0L) {
            this.log.finest("execute wait behaviour on node: " + this.node.getName() + " => wait during " + time + " ms");
            this.getNode().getExecution().setStateRecursively(Execution.State.SUSPENDED);
            WaitingThreadPool.addWaitingThread(process, this, time);
            return;
        }
        this.state = Behaviour.State.ACTIVITY_ENDED;
    }

    protected void executeOnStarted() throws CoreException {
        if (this.alreadyWaited) {
            this.state = Behaviour.State.ACTIVITY_ENDED;
            this.alreadyWaited = false;
        }
    }
}

