/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.service;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.env.Receiver;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.AbstractCoreTest;
import com.ebmwebsourcing.easyviper.core.impl.TestBindingInputMessageAdapterImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.ReceiverBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.pattern.CreationPatternFactory;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.MessageImpl;
import com.ebmwebsourcing.easyviper.core.impl.test.util.TestVariableImpl;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.jdom.Element;
import org.junit.Test;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class AutoFlushServiceTest
extends AbstractCoreTest {
    @Test(timeout=10000L)
    public void testAutoFlushService() throws CoreException, NoSuchInterfaceException, InterruptedException {
        ConfigurationEngine conf = this.getDefaultEngineConfiguration();
        conf.setAutoFlushMessageFrequency(Integer.valueOf(1000));
        Core core = this.getCoreUnderTest();
        Engine engine = core.getEngine();
        MessageImpl message = new MessageImpl("dummyOperation");
        message.getBody().setPayload(new Element("helloworld"));
        ((Receiver)core.getExternalEnvironment().getReceivers().get(0)).accept((Message)message, null);
        Process process1 = this.createProcess(new QName("Process1"), core);
        Execution main = engine.run(process1);
        this.checkExecutionEndedProperly(main);
    }

    private Process createProcess(QName name, Core core) throws CoreException {
        TestVariableImpl v1 = new TestVariableImpl("v1", null);
        Process process = core.getEngine().createNewEmptyProcessInstance(name, null);
        process.getVariables().put(v1.getName(), v1);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("variableName", v1.getName());
        context.put("inputMessageAdapter", new TestBindingInputMessageAdapterImpl());
        Node receiver = process.createNode("receive", ReceiverBehaviourImpl.class, context);
        ArrayList<Node> childNodes = new ArrayList<Node>();
        childNodes.add(receiver);
        Node sequence = CreationPatternFactory.getInstance().createSequencePattern("seq", childNodes, (Scope)process);
        process.setInitialNode(sequence);
        return process;
    }
}

