/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.intent._default.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.MessageImpl;
import com.ebmwebsourcing.easyviper.intent._abstract.notify.impl.AbstractNotifyHandlerImpl;
import com.ebmwebsourcing.easyviper.intent._abstract.notify.impl.NotifyCallableImpl;
import com.ebmwebsourcing.easyviper.intent._abstract.notify.util.BehaviourWrapperUtil;
import com.ebmwebsourcing.easyviper.intent._default.api.DefaultNotifyIntentHandler;
import com.ebmwebsourcing.easyviper.intent._default.util.ServiceEndpointUtil;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.ow2.frascati.tinfi.api.IntentJoinPoint;
import org.ow2.frascati.tinfi.api.control.SCAContentController;
import org.w3c.dom.Document;

@Scope(value="COMPOSITE")
@Service(value={DefaultNotifyIntentHandler.class}, names={"notify"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class DefaultNotifyIntentImpl
extends AbstractNotifyHandlerImpl
implements DefaultNotifyIntentHandler {
    private ExecutorService exec = Executors.newCachedThreadPool();
    private XmlContext context = new XmlContextFactory().newContext();
    private List<String> addresses = new ArrayList<String>();
    private Map<Partner, Map<String, ExternalContext>> externalcontext = null;
    private Logger log = Logger.getLogger(this.getClass().getCanonicalName());

    public Object invoke(IntentJoinPoint ijp) throws Throwable {
        Document payload;
        Object o = ((SCAContentController)ijp.getComponent().getFcInterface("/sca-content-controller")).getFcContent();
        AbstractBehaviourImpl behaviour = null;
        Engine engine = null;
        if (o instanceof AbstractBehaviourImpl && ijp.getMethod().getName().equalsIgnoreCase("execute")) {
            behaviour = (AbstractBehaviourImpl)o;
            engine = behaviour.getNode().getScope().getProcess().getEngine();
        }
        Object ret = ijp.proceed();
        if (behaviour != null && engine != null && (payload = BehaviourWrapperUtil.writeBehaviour((Behaviour)behaviour)) != null) {
            URI dialect = new URI("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete");
            QName topicUsed = new QName("http://ebmwebsourcing.com/easyviper/topic", "root", "easyviper");
            TopicExpressionType topic = WSNHelper.createSimpleTopicExpression((QName)topicUsed, (String)dialect.toString());
            for (String address : this.addresses) {
                String endpoint = ServiceEndpointUtil.findEndpoint(address);
                QName service = ServiceEndpointUtil.findService(address);
                MessageImpl message = this.createNotificationMessage(payload, topic, endpoint, service);
                NotifyCallableImpl notify = new NotifyCallableImpl();
                notify.init(engine, (Message)message, address, this.externalcontext);
                Future future = this.exec.submit(notify);
                this.log.finest("SEND MESSAGE ");
                if (!Level.FINEST.equals(this.log.getLevel().equals(Level.FINEST))) continue;
                this.log.finest(XMLPrettyPrinter.prettyPrint((Document)payload));
            }
        }
        return ret;
    }

    public void addAddress(String address) {
        this.addresses.add(address);
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public Map<Partner, Map<String, ExternalContext>> getExternalcontext() {
        return this.externalcontext;
    }

    public void setExternalcontext(Map<Partner, Map<String, ExternalContext>> externalcontext) {
        this.externalcontext = externalcontext;
    }
}

