/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easywsdl11.api.type;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easywsdl11.api.element.Part;
import com.ebmwebsourcing.easywsdl11.api.type.TMessage;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public final class TMessageTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_PARTS = "expectedParts";

    public TMessageTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetParts() {
        TMessage tMessage = (TMessage)this.newXmlObjectUnderTest();
        Object[] expectedParts = (Part[])this.getTestData(EXPECTED_PARTS);
        Assert.assertArrayEquals((Object[])expectedParts, (Object[])tMessage.getParts());
    }

    @Test
    public void testGetPartByName() {
        Part[] expectedParts;
        TMessage tMessage = (TMessage)this.newXmlObjectUnderTest();
        for (Part expectedPart : expectedParts = (Part[])this.getTestData(EXPECTED_PARTS)) {
            if (expectedPart.getName() == null) continue;
            Assert.assertEquals((Object)expectedPart, (Object)tMessage.getPartByName(expectedPart.getName()));
        }
    }

    @Test
    public void testAddPart() {
        TMessage tMessage = (TMessage)this.newXmlObjectUnderTest();
        LinkedList<Part> expectedParts = new LinkedList<Part>(Arrays.asList((Part[])this.getTestData(EXPECTED_PARTS)));
        Part newPart = (Part)this.getXmlContext().getXmlObjectFactory().create(Part.class);
        newPart.setName("newPartName");
        expectedParts.add(newPart);
        tMessage.addPart(newPart);
        Assert.assertEquals(expectedParts, Arrays.asList(tMessage.getParts()));
    }

    @Test
    public void testRemovePart() {
        TMessage tMessage = (TMessage)this.newXmlObjectUnderTest();
        for (Part e : tMessage.getParts()) {
            tMessage.removePart(e);
            Assert.assertFalse((boolean)Arrays.asList(tMessage.getParts()).contains(e));
        }
    }

    @Test
    public void testClearParts() {
        TMessage tMessage = (TMessage)this.newXmlObjectUnderTest();
        tMessage.clearParts();
        Assert.assertEquals((long)0L, (long)tMessage.getParts().length);
    }

    @Test
    public void testGetParentAfterAdding() {
        TMessage tMessage = (TMessage)this.newXmlObjectUnderTest();
        Part newPart = (Part)this.getXmlContext().getXmlObjectFactory().create(Part.class);
        tMessage.addPart(newPart);
        Assert.assertEquals((Object)tMessage, (Object)newPart.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterRemoval() {
        TMessage tMessage = (TMessage)this.newXmlObjectUnderTest();
        Part newPart = (Part)this.getXmlContext().getXmlObjectFactory().create(Part.class);
        tMessage.addPart(newPart);
        tMessage.removePart(newPart);
        Assert.assertNull((Object)newPart.getXmlObjectParent());
    }
}

