/**
 * definitions-editor - BPMN Definitions Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.petalsbpm.definitionseditor;

import java.util.ArrayList;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IItemDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.common.IMessageBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.IImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.INamespaceDeclaration;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.xsd.IBPMN20ImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.xsd.IWSDLImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.infrastructure.xsd.IXSDImportBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.DefinitionsHelper;
import com.ebmwebsourcing.petalsbpm.definitionseditor.common.events.PropertyUpdateEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddErrorEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddEventDefinition;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddImportEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddInterfaceEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddItemDefinitionEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddMessageEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddPartnerEntityEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddPartnerRoleEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.AddSignalEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.DefinitionsHandler;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.RemoveErrorEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.RemoveEventDefinition;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.RemoveImportEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.RemoveInterfaceEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.RemoveItemDefinitionEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.RemoveMessageEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.RemovePartnerEntityEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.RemovePartnerRoleEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.definitions.events.RemoveSignalEvent;
import com.ebmwebsourcing.petalsbpm.definitionseditor.error.ErrorController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.conditional.ConditionalEventDefinitionController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.message.MessageEventDefinitionController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.signal.SignalEventDefinitionController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.eventdefinition.timer.TimerEventDefinitionController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.imports.ImportController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.interfaces.InterfaceController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.itemdefinition.ItemDefinitionController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.message.MessageController;
import com.ebmwebsourcing.petalsbpm.definitionseditor.signal.SignalController;
import com.google.gwt.event.shared.HandlerManager;

public class DefinitionsController implements DefinitionsHandler{
	
	private HandlerManager handlerManager;
	
	private IDefinitionsBean definitions;
	
	private DefinitionsEditor defsEditor;
	
	public DefinitionsController(DefinitionsEditor definitionsEditor,IDefinitionsBean definitions) {
		
		this.handlerManager = new HandlerManager(this);
		this.definitions 	= definitions;
		this.defsEditor		= definitionsEditor;
	
		bindControllers();

		displayData();
	}
	
	
	
	
	private void bindControllers(){
		
		//IMPORT
		ImportController importController = new ImportController(this.defsEditor.getImportPanel());
		importController.addDefinitionsHandler(this);
		
		//ITEM DEFINITION
		ItemDefinitionController itemDefinitionController = new ItemDefinitionController(this.defsEditor.getItemDefinitionPanel(), DefinitionsHelper.getInstance().getImportedStructureRefQnames(definitions));
		itemDefinitionController.addDefinitionsHandler(this);
		
		//MESSAGE
		MessageController messageController = new MessageController(this.defsEditor.getMessagePanel(), definitions.getItemDefinitions());
		messageController.addDefinitionsHandler(this);
		
		//ERROR
		ErrorController errorController = new ErrorController(this.defsEditor.getErrorPanel(),definitions.getItemDefinitions());
		errorController.addDefinitionsHandler(this);
		
		//INTERFACE
		InterfaceController interfaceController = new InterfaceController(this.defsEditor.getInterfacePanel(), definitions.getMessages(), definitions.getErrors()
				,DefinitionsHelper.getInstance().getImportedWSDLImplementationRefQnames(definitions)
				,DefinitionsHelper.getInstance().getImportedWSDLOperationsRefQnames(definitions));
		
		interfaceController.addDefinitionsHandler(this);
		
		//SIGNAL
		SignalController signalController = new SignalController(this.defsEditor.getSignalPanel(), definitions.getItemDefinitions());
		signalController.addDefinitionsHandler(this);
	
		/////////EVENT DEFINITIONS
		
		//CONDITIONAL EVENT DEFINITION
		ConditionalEventDefinitionController cedController = new ConditionalEventDefinitionController(this.defsEditor.getConditionalEventDefinitionPanel());
		cedController.addDefinitionsHandler(this);
		
		//MESSAGE EVENT DEFINITION
		MessageEventDefinitionController medController = new MessageEventDefinitionController(this.defsEditor.getMessageEventDefinitionPanel(), this.definitions.getOperations(), this.definitions.getMessages());
		medController.addDefinitionsHandler(this);
		
		//SIGNAL EVENT DEFINITION
		SignalEventDefinitionController sedController = new SignalEventDefinitionController(this.defsEditor.getSignalEventDefinitionPanel(), this.definitions.getSignals());
		sedController.addDefinitionsHandler(this);
		
		//TIMER EVENT DEFINITION
		TimerEventDefinitionController tedController = new TimerEventDefinitionController(this.defsEditor.getTimerEventDefinintionPanel());
		tedController.addDefinitionsHandler(this);
		
		
	}
	
	private void displayData(){
		
		//Imports
		this.defsEditor.getImportPanel().load(this.definitions.getImports());
		
		//Namespaces
		ArrayList<INamespaceDeclaration> namespaces =  new ArrayList<INamespaceDeclaration>(this.definitions.getImportsNsDeclarations());
		this.defsEditor.getImportNSPanel().load(namespaces);
		
		//Item Definitions
		this.defsEditor.getItemDefinitionPanel().load(this.definitions.getItemDefinitions());
		
		//Messages
		this.defsEditor.getMessagePanel().load(this.definitions.getMessages());
		
		//Errors
		this.defsEditor.getErrorPanel().load(this.definitions.getErrors());
		
		//Interfaces
		this.defsEditor.getInterfacePanel().load(this.definitions.getInterfaces());
		
		//Signals
		this.defsEditor.getSignalPanel().load(this.definitions.getSignals());
		
		//////EVENT DEFINITIONS
		
		//Conditional
		this.defsEditor.getConditionalEventDefinitionPanel().load(this.definitions.getConditionalEventDefinitions());
		
		//Message
		this.defsEditor.getMessageEventDefinitionPanel().load(this.definitions.getMessageEventDefinitions());
		
		// Signal
		this.defsEditor.getSignalEventDefinitionPanel().load(this.definitions.getSignalEventDefinitions());
		
		//Timer
		this.defsEditor.getTimerEventDefinintionPanel().load(this.definitions.getTimerEventDefinitions());
		
		//////////////////////
	
		
		
		
	}
	
	
	
	@Override
	public void onAddEventDefinition(AddEventDefinition event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAddImport(AddImportEvent event) {
		
		//create a new default namespace considering the existing ones
		IImportBean importBean = event.getImportBean();

		this.definitions.addImportNSDeclaration(importBean.getNSDeclaration());
		
		///=> reload NSDeclaration Panel
		this.defsEditor.getImportNSPanel().load(new ArrayList<INamespaceDeclaration>(this.definitions.getImportsNsDeclarations()));
		
		if (importBean instanceof IXSDImportBean){
		//1- when adding an xsd import is should add only new itemDefs			
		
			IXSDImportBean xsdImport = (IXSDImportBean) importBean;
			
			for(IItemDefinitionBean item:xsdImport.getItemDefinitions()){
				this.definitions.addItemDefinition(item);
			}
			
			///=> reload item definitions panel
			this.defsEditor.getItemDefinitionPanel().load(this.definitions.getItemDefinitions());
			
		}else if (importBean instanceof IWSDLImportBean){		
		//2- when adding an wsdl import it should add interface, operations, messages ? ,
		//and may add some itemDefs			
			
			IWSDLImportBean wsdlImport = (IWSDLImportBean) importBean;
			
			//INTERFACES
			for(IInterfaceBean i:wsdlImport.getInterfaces()){
				
				this.definitions.addInterface(i);
				
			}
			
			///=> reload interface panel
			this.defsEditor.getInterfacePanel().load(this.definitions.getInterfaces());
			
			//MESSAGES
			for(IMessageBean msg:wsdlImport.getMessages()){
				
				this.definitions.addMessage(msg);
				
			}
			
			///=> reload message panel
			this.defsEditor.getMessagePanel().load(this.definitions.getMessages());
			
			
			//ITEM DEFINITIONS
			for(IItemDefinitionBean i:wsdlImport.getItemDefinitions()){
				
				this.definitions.addItemDefinition(i);
				
			}
			
			///=> reload item definitions panel
			this.defsEditor.getItemDefinitionPanel().load(this.definitions.getItemDefinitions());
			
			
			
			
		}else if (importBean instanceof IBPMN20ImportBean){		
		//3- adding a bpmn import shouldn't add any specific information			
			
			
			
			
			
		}
		
		

		

	}

	@Override
	public void onAddInterface(AddInterfaceEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAddItemDefinition(AddItemDefinitionEvent event) {
		
		definitions.addItemDefinition(event.getItemDefinition());
		System.out.println("item def just added");
	}

	@Override
	public void onAddParnterRole(AddPartnerRoleEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAddPartnerEntity(AddPartnerEntityEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemoveEventDefinition(RemoveEventDefinition event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemoveImport(RemoveImportEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemoveInterface(RemoveInterfaceEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemoveItemDefinition(RemoveItemDefinitionEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemoveParnterEntity(RemovePartnerEntityEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRemovePartnerRole(RemovePartnerRoleEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onPropertyUpdate(PropertyUpdateEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onAddError(AddErrorEvent event) {
			
		definitions.addError(event.getError());
		System.out.println("Just added error:"+event.getError());
	}


	@Override
	public void onAddMessage(AddMessageEvent event) {
		
		definitions.addMessage(event.getMsgBean());
		System.out.println("Just added message:"+event.getMsgBean());
	}


	@Override
	public void onRemoveError(RemoveErrorEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onRemoveMessage(RemoveMessageEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onAddSignal(AddSignalEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onRemoveSignal(RemoveSignalEvent event) {
		// TODO Auto-generated method stub
		
	}

}
